/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ivmdm;

import gov.va.med.esr.common.model.ivmdm.IVMDMExtractRecord;
import gov.va.med.esr.common.model.lookup.IVMDMType;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class IVMDMExtractBatch
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -6697665245788864658L;
    private IVMDMType migrationType;
    private String extractFileName;
    private Date extractStartDate;
    private Date extractEndDate;
    private Integer extractRecordCount;
    private Set internalExtractRecords;

    public IVMDMType getMigrationType() {
        return this.migrationType;
    }

    public void setMigrationType(IVMDMType type) {
        this.migrationType = type;
    }

    public String getExtractFileName() {
        return this.extractFileName;
    }

    public void setExtractFileName(String name) {
        this.extractFileName = name;
    }

    public Date getExtractStartDate() {
        return this.extractStartDate;
    }

    public void setExtractStartDate(Date start) {
        this.extractStartDate = start;
    }

    public Date getExtractEndDate() {
        return this.extractEndDate;
    }

    public void setExtractEndDate(Date end) {
        this.extractEndDate = end;
    }

    public Integer getExtractRecordCount() {
        return this.extractRecordCount;
    }

    public void setExtractRecordCount(Integer count) {
        this.extractRecordCount = count;
    }

    public Set getExtractRecords() {
        return Collections.unmodifiableSet(this.getInternalExtractRecords());
    }

    public IVMDMExtractRecord getExtractRecordByEntityKey(EntityKey identifier) {
        return (IVMDMExtractRecord)AbstractKeyedEntity.getEntityByEntityKey((Collection)this.getExtractRecords(), (EntityKey)identifier);
    }

    public IVMDMExtractRecord removeExtractRecordByEntityKey(EntityKey identifier) {
        return (IVMDMExtractRecord)AbstractKeyedEntity.removeEntityByEntityKey((Collection)this.getInternalExtractRecords(), (EntityKey)identifier);
    }

    private Set getInternalExtractRecords() {
        if (this.internalExtractRecords == null) {
            this.internalExtractRecords = new HashSet();
        }
        return this.internalExtractRecords;
    }

    private void setInternalExtractRecords(Set extractRecords) {
        this.internalExtractRecords = extractRecords;
    }

    public void addExtractRecord(IVMDMExtractRecord extractRecord) {
        Validate.notNull((Object)((Object)extractRecord), (String)"Null extractRecord specified.");
        extractRecord.setExtractBatch(this);
        this.getInternalExtractRecords().add(extractRecord);
    }

    public void addAllExtractRecords(Set extractRecords) {
        Validate.notNull((Object)extractRecords, (String)"Null set of extractRecords specified.");
        Iterator iter = extractRecords.iterator();
        while (iter.hasNext()) {
            ((IVMDMExtractRecord)((Object)iter.next())).setExtractBatch(this);
        }
        Set internal = this.getInternalExtractRecords();
        internal.addAll(extractRecords);
    }

    public void removeExtractRecord(IVMDMExtractRecord extractRecord) {
        Validate.notNull((Object)((Object)extractRecord), (String)"Null extractRecord specified.");
        this.getInternalExtractRecords().remove((Object)extractRecord);
        extractRecord.setExtractBatch(null);
    }

    public void removeAllExtractRecords() {
        this.getInternalExtractRecords().clear();
    }
}

