/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.financials;

import gov.va.med.esr.common.model.financials.Financial;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Expense
extends Financial {
    private static final long serialVersionUID = -5913653844253658808L;
    private ExpenseType type = null;

    public Expense() {
    }

    public Expense(BigDecimal amount) {
        super(amount);
    }

    public ExpenseType getType() {
        return this.type;
    }

    protected void setType(ExpenseType type) {
        this.type = type;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("type", (Object)this.type);
    }

    public static Expense getExpenseOfType(Collection expenses, ExpenseType.Code typeCode) {
        Validate.notNull((Object)expenses, (String)"The set of expenses must not be null");
        Validate.notNull((Object)((Object)typeCode), (String)"Expense type code must not be null");
        for (Expense expense : expenses) {
            ExpenseType expenseType = expense.getType();
            if (expenseType == null || !expenseType.getCode().equals(typeCode.getName())) continue;
            return expense;
        }
        return null;
    }
}

