/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.ee.Decoration;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.fw.model.EntityKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PurpleHeart
extends Registry
implements Decoration {
    private static final long serialVersionUID = -4457957494390182672L;
    private Boolean phIndicator = null;
    private RejectionRemark rejectionRemark = null;
    private VAFacility facility = null;
    private DecorationStatus status = null;
    private Date statusLastEditDate = null;
    private String statusLastUpdateUser = null;
    private String assignedContactUser = null;
    private Set internalDocuments = null;

    public void setPhIndicator(Boolean indicator) {
        this.phIndicator = indicator;
    }

    public Boolean getPhIndicator() {
        return this.phIndicator;
    }

    public RejectionRemark getRejectionRemark() {
        return this.rejectionRemark;
    }

    public void setRejectionRemark(RejectionRemark rejectionRemark) {
        this.rejectionRemark = rejectionRemark;
    }

    public VAFacility getFacility() {
        return this.facility;
    }

    public void setFacility(VAFacility facility) {
        this.facility = facility;
    }

    @Override
    public DecorationStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(DecorationStatus status) {
        this.status = status;
    }

    public Date getStatusLastEditDate() {
        return this.statusLastEditDate;
    }

    public void setStatusLastEditDate(Date statusLastEditDate) {
        this.statusLastEditDate = statusLastEditDate;
    }

    public String getStatusLastUpdateUser() {
        return this.statusLastUpdateUser;
    }

    public void setStatusLastUpdateUser(String statusLastUpdateUser) {
        this.statusLastUpdateUser = statusLastUpdateUser;
    }

    public String getAssignedContactUser() {
        return this.assignedContactUser;
    }

    public void setAssignedContactUser(String assignedContactUser) {
        this.assignedContactUser = assignedContactUser;
    }

    public Set getDocuments() {
        return Collections.unmodifiableSet(this.getInternalDocuments());
    }

    public void addPurpleHeartDocument(PurpleHeartDocument document) {
        Validate.notNull((Object)document, (String)"document cannot be null");
        this.getInternalDocuments().add(document);
        document.setPurpleHeart(this);
    }

    public void removePurpleHeartDocument(PurpleHeartDocument document) {
        Validate.notNull((Object)document, (String)"Document cannot be null");
        this.getInternalDocuments().remove(document);
        document.setPurpleHeart(null);
    }

    public void addDocument(PurpleHeartDocument document) {
        this.addPurpleHeartDocument(document);
    }

    public void addAllDocuments(Set documents) {
        Validate.notEmpty((Collection)documents, (String)"PH documents cannot be null or empty");
        for (Object document : documents) {
            if (!(document instanceof PurpleHeartDocument)) continue;
            this.addPurpleHeartDocument((PurpleHeartDocument)document);
        }
    }

    public void removeDocument(PurpleHeartDocument document) {
        this.removePurpleHeartDocument(document);
    }

    public PurpleHeartDocument getDocumentByEntityKey(EntityKey identifier) {
        return (PurpleHeartDocument)PurpleHeart.getEntityByEntityKey((Collection)this.getDocuments(), (EntityKey)identifier);
    }

    public PurpleHeartDocument removeDocumentByEntityKey(EntityKey identifier) {
        return (PurpleHeartDocument)PurpleHeart.removeEntityByEntityKey((Collection)this.getInternalDocuments(), (EntityKey)identifier);
    }

    public void removeAllDocuments() {
        this.getInternalDocuments().clear();
    }

    private Set getInternalDocuments() {
        if (this.internalDocuments == null) {
            this.internalDocuments = new HashSet();
        }
        return this.internalDocuments;
    }

    private void setInternalDocuments(Set internalDocuments) {
        this.internalDocuments = internalDocuments;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder.append("rejectionRemark", (Object)this.rejectionRemark).append("phIndicator", (Object)this.phIndicator).append("facility", (Object)this.facility).append("status", (Object)this.status).append("statusLastEditDate", (Object)this.statusLastEditDate).append("statusLastUpdateUser", (Object)this.statusLastUpdateUser).append("assignedContactUser", (Object)this.assignedContactUser));
    }
}

