/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.Activation;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.lookup.MilitaryServiceQueryStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.set.UnmodifiableSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MilitaryService
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -7702677194409852460L;
    private Person person = null;
    private Boolean disabilityRetirementIndicator = null;
    private Boolean dischargeDueToDisability = null;
    private Date combatVeteranEligibilityEndDate = null;
    private Set internalCombatServices = null;
    private Set internalActivations = null;
    private Set internalCombatEpisodes = null;
    private Set internalMilitaryServiceSiteRecords = null;
    private boolean voaHasAttachment = false;
    private MilitaryServiceQueryStatus militaryServiceQueryStatus = null;

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person, person);
        this.person = person;
    }

    public Boolean getDisabilityRetirementIndicator() {
        return this.disabilityRetirementIndicator;
    }

    public void setDisabilityRetirementIndicator(Boolean disabilityRetirementIndicator) {
        this.disabilityRetirementIndicator = disabilityRetirementIndicator;
    }

    public Boolean getDischargeDueToDisability() {
        return this.dischargeDueToDisability;
    }

    public void setDischargeDueToDisability(Boolean dischargeDueToDisability) {
        this.dischargeDueToDisability = dischargeDueToDisability;
    }

    public Date getCombatVeteranEligibilityEndDate() {
        return this.combatVeteranEligibilityEndDate;
    }

    public void setCombatVeteranEligibilityEndDate(Date combatVeteranEligibilityEndDate) {
        this.combatVeteranEligibilityEndDate = combatVeteranEligibilityEndDate;
    }

    private void setInternalActivations(Set activations) {
        this.internalActivations = activations;
    }

    private Set getInternalActivations() {
        if (this.internalActivations == null) {
            this.internalActivations = new HashSet();
        }
        return this.internalActivations;
    }

    public Set getActivations() {
        return UnmodifiableSet.decorate((Set)this.getInternalActivations());
    }

    public void addActivation(Activation activation) {
        Validate.notNull((Object)((Object)activation));
        this.getInternalActivations().add(activation);
        activation.setMilitaryService(this);
    }

    public void addAllActivations(Set activations) {
        if (activations != null) {
            for (Object record : activations) {
                if (!(record instanceof Activation)) continue;
                this.addActivation((Activation)((Object)record));
            }
        }
    }

    public void removeActivation(Activation activation) {
        Validate.notNull((Object)((Object)activation), (String)"Null Activation specified.");
        this.getInternalActivations().remove((Object)activation);
        activation.setMilitaryService(null);
    }

    public Activation getActivationByEntityKey(EntityKey identifier) {
        return (Activation)MilitaryService.getEntityByEntityKey((Collection)this.getActivations(), (EntityKey)identifier);
    }

    public Activation removeActivationByEntityKey(EntityKey identifier) {
        return (Activation)MilitaryService.removeEntityByEntityKey((Collection)this.getInternalActivations(), (EntityKey)identifier);
    }

    public void removeAllActivations() {
        this.getInternalActivations().clear();
    }

    private void setInternalCombatServices(Set combatServices) {
        this.internalCombatServices = combatServices;
    }

    private Set getInternalCombatServices() {
        if (this.internalCombatServices == null) {
            this.internalCombatServices = new HashSet();
        }
        return this.internalCombatServices;
    }

    public Set getCombatServices() {
        return UnmodifiableSet.decorate((Set)this.getInternalCombatServices());
    }

    public void addCombatService(CombatService combatService) {
        Validate.notNull((Object)((Object)combatService));
        this.getInternalCombatServices().add(combatService);
        combatService.setMilitaryService(this);
    }

    public void addAllCombatServices(Set combatServices) {
        if (combatServices != null) {
            for (Object record : combatServices) {
                if (!(record instanceof CombatService)) continue;
                this.addCombatService((CombatService)((Object)record));
            }
        }
    }

    public void removeCombatService(CombatService combatService) {
        Validate.notNull((Object)((Object)combatService), (String)"Null Combat Service specified.");
        this.getInternalCombatServices().remove((Object)combatService);
        combatService.setMilitaryService(null);
    }

    public CombatService getCombatServiceByEntityKey(EntityKey identifier) {
        return (CombatService)MilitaryService.getEntityByEntityKey((Collection)this.getCombatServices(), (EntityKey)identifier);
    }

    public CombatService removeCombatServiceByEntityKey(EntityKey identifier) {
        return (CombatService)MilitaryService.removeEntityByEntityKey((Collection)this.getInternalCombatServices(), (EntityKey)identifier);
    }

    public void removeAllCombatServices() {
        this.getInternalCombatServices().clear();
    }

    private void setInternalCombatEpisodes(Set combatEpisodes) {
        this.internalCombatEpisodes = combatEpisodes;
    }

    private Set getInternalCombatEpisodes() {
        if (this.internalCombatEpisodes == null) {
            this.internalCombatEpisodes = new HashSet();
        }
        return this.internalCombatEpisodes;
    }

    public Set getCombatEpisodes() {
        return UnmodifiableSet.decorate((Set)this.getInternalCombatEpisodes());
    }

    public void addCombatEpisode(CombatEpisode combatEpisode) {
        Validate.notNull((Object)((Object)combatEpisode));
        this.getInternalCombatEpisodes().add(combatEpisode);
        combatEpisode.setMilitaryService(this);
    }

    public void addAllCombatEpisodes(Set combatEpisodes) {
        if (combatEpisodes != null) {
            for (Object record : combatEpisodes) {
                if (!(record instanceof CombatEpisode)) continue;
                this.addCombatEpisode((CombatEpisode)((Object)record));
            }
        }
    }

    public void removeCombatEpisode(CombatEpisode combatEpisode) {
        Validate.notNull((Object)((Object)combatEpisode), (String)"Null Combat Episode specified.");
        this.getInternalCombatEpisodes().remove((Object)combatEpisode);
        combatEpisode.setMilitaryService(null);
    }

    public CombatEpisode getCombatEpisodeByEntityKey(EntityKey identifier) {
        return (CombatEpisode)MilitaryService.getEntityByEntityKey((Collection)this.getCombatEpisodes(), (EntityKey)identifier);
    }

    public CombatEpisode removeCombatEpisodeByEntityKey(EntityKey identifier) {
        return (CombatEpisode)MilitaryService.removeEntityByEntityKey((Collection)this.getInternalCombatEpisodes(), (EntityKey)identifier);
    }

    public void removeAllCombatEpisodes() {
        this.getInternalCombatEpisodes().clear();
    }

    private void setInternalMilitaryServiceSiteRecords(Set militaryServiceSiteRecords) {
        this.internalMilitaryServiceSiteRecords = militaryServiceSiteRecords;
    }

    private Set getInternalMilitaryServiceSiteRecords() {
        if (this.internalMilitaryServiceSiteRecords == null) {
            this.internalMilitaryServiceSiteRecords = new HashSet();
        }
        return this.internalMilitaryServiceSiteRecords;
    }

    public Set getMilitaryServiceSiteRecords() {
        return UnmodifiableSet.decorate((Set)this.getInternalMilitaryServiceSiteRecords());
    }

    public void addMilitaryServiceSiteRecord(MilitaryServiceSiteRecord militaryServiceSiteRecord) {
        Validate.notNull((Object)((Object)militaryServiceSiteRecord));
        Validate.notNull((Object)((Object)militaryServiceSiteRecord.getSite()));
        this.getInternalMilitaryServiceSiteRecords().add(militaryServiceSiteRecord);
        militaryServiceSiteRecord.setMilitaryService(this);
    }

    public void addAllMilitaryServiceSiteRecords(Set records) {
        if (records != null) {
            for (Object record : records) {
                if (!(record instanceof MilitaryServiceSiteRecord)) continue;
                this.addMilitaryServiceSiteRecord((MilitaryServiceSiteRecord)((Object)record));
            }
        }
    }

    public void removeMilitaryServiceSiteRecord(MilitaryServiceSiteRecord militaryServiceSiteRecord) {
        Validate.notNull((Object)((Object)militaryServiceSiteRecord), (String)"Null Military Service Site Record specified.");
        this.getInternalMilitaryServiceSiteRecords().remove((Object)militaryServiceSiteRecord);
        militaryServiceSiteRecord.setMilitaryService(null);
    }

    public MilitaryServiceSiteRecord getMilitaryServiceSiteRecordByEntityKey(EntityKey identifier) {
        return (MilitaryServiceSiteRecord)MilitaryService.getEntityByEntityKey((Collection)this.getMilitaryServiceSiteRecords(), (EntityKey)identifier);
    }

    public MilitaryServiceSiteRecord removeMilitaryServiceSiteRecordByEntityKey(EntityKey identifier) {
        return (MilitaryServiceSiteRecord)MilitaryService.removeEntityByEntityKey((Collection)this.getInternalMilitaryServiceSiteRecords(), (EntityKey)identifier);
    }

    public void removeAllMilitaryServiceSiteRecords() {
        this.getInternalMilitaryServiceSiteRecords().clear();
    }

    public MilitaryServiceSiteRecord getMilitaryServiceSiteRecordsBySite(VAFacility facility) {
        return this.getMilitaryServiceSiteRecordsBySite(facility.getStationNumber());
    }

    public MilitaryServiceSiteRecord getMilitaryServiceSiteRecordsBySite(String stationNum) {
        Set siteRecords = this.getInternalMilitaryServiceSiteRecords();
        if (siteRecords != null) {
            Iterator iter = siteRecords.iterator();
            while (iter.hasNext()) {
                VAFacility site;
                MilitaryServiceSiteRecord siteRecord;
                if (iter == null || (siteRecord = (MilitaryServiceSiteRecord)((Object)iter.next())) == null || !(site = siteRecord.getSite()).getStationNumber().equals(stationNum)) continue;
                return siteRecord;
            }
        }
        return null;
    }

    public MilitaryServiceSiteRecord getHECMilitaryServiceSiteRecord() {
        return this.getMilitaryServiceSiteRecordsBySite(VAFacility.CODE_HEC.getName());
    }

    public Date getServiceEntryDate() {
        Date serviceEntryDate = null;
        Set siteRecords = this.getMilitaryServiceSiteRecords();
        for (MilitaryServiceSiteRecord siteRec : siteRecords) {
            Set msEpisodes = siteRec.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode msEpisode : msEpisodes) {
                Date msStartDate = ImpreciseDateUtils.getDateWithDefault(msEpisode.getStartDate());
                if (serviceEntryDate != null && (msStartDate == null || !serviceEntryDate.after(msStartDate))) continue;
                serviceEntryDate = msStartDate;
            }
        }
        return serviceEntryDate;
    }

    public Date getServiceSeperationDate() {
        Date serviceSeperationDate = null;
        Set siteRecords = this.getMilitaryServiceSiteRecords();
        for (MilitaryServiceSiteRecord siteRec : siteRecords) {
            Set msEpisodes = siteRec.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode msEpisode : msEpisodes) {
                Date msEndDate = ImpreciseDateUtils.getDateWithDefault(msEpisode.getEndDate());
                if (serviceSeperationDate != null && (msEndDate == null || !serviceSeperationDate.before(msEndDate))) continue;
                serviceSeperationDate = msEndDate;
            }
        }
        return serviceSeperationDate;
    }

    public MilitaryServiceQueryStatus getMilitaryServiceQueryStatus() {
        return this.militaryServiceQueryStatus;
    }

    public void setMilitaryServiceQueryStatus(MilitaryServiceQueryStatus militaryServiceQueryStatus) {
        this.militaryServiceQueryStatus = militaryServiceQueryStatus;
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append("disabilityRetirementStatus", (Object)this.disabilityRetirementIndicator).append("dischargeDueToDisability", (Object)this.dischargeDueToDisability).append("combatVeteranEligibilityEndDate", (Object)this.combatVeteranEligibilityEndDate).append("internalMilitaryServiceSiteRecords", (Object)this.internalMilitaryServiceSiteRecords);
    }

    public boolean isVoaHasAttachment() {
        return this.voaHasAttachment;
    }

    public void setVoaHasAttachment(boolean voaHasAttachment) {
        this.voaHasAttachment = voaHasAttachment;
    }
}

