/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.CampLejeuneVerificationMethod;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.lookup.CampLejeuneChangeSource;
import gov.va.med.esr.common.model.lookup.CampLejeuneVerificationType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.util.StringUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CampLejeuneVerification
extends SpecialFactor {
    private static final long serialVersionUID = -2578203019462583585L;
    private CampLejeuneChangeSource changeSource;
    private VAFacility changeSite;
    private Set<CampLejeuneVerificationMethod> internalCampLejeuneVerificationMethods = null;
    private CampLejeuneVerificationType verificationType;
    private String comments;
    private Date changeDate_h = new Date();

    public CampLejeuneChangeSource getChangeSource() {
        return this.changeSource;
    }

    public void setChangeSource(CampLejeuneChangeSource changeSource) {
        this.changeSource = changeSource;
    }

    public VAFacility getChangeSite() {
        return this.changeSite;
    }

    public void setChangeSite(VAFacility changeSite) {
        this.changeSite = changeSite;
    }

    public CampLejeuneVerificationType getVerificationType() {
        return this.verificationType;
    }

    public void setVerificationType(CampLejeuneVerificationType verificationType) {
        this.verificationType = verificationType;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Date getChangeDate() {
        if (this.getRegistrationDate() != null) {
            return this.getRegistrationDate().getDate();
        }
        return null;
    }

    public void setChangeDate(Date changeDate) {
        if (changeDate != null) {
            this.setRegistrationDate(new ImpreciseDate(changeDate));
            this.changeDate_h = changeDate;
        }
    }

    public Set<CampLejeuneVerificationMethod> getInternalCampLejeuneVerificationMethods() {
        if (this.internalCampLejeuneVerificationMethods == null) {
            this.internalCampLejeuneVerificationMethods = new HashSet<CampLejeuneVerificationMethod>();
        }
        return this.internalCampLejeuneVerificationMethods;
    }

    public void setInternalCampLejeuneVerificationMethods(Set<CampLejeuneVerificationMethod> internalCampLejeuneVerificationMethods) {
        this.internalCampLejeuneVerificationMethods = internalCampLejeuneVerificationMethods;
    }

    public Set<CampLejeuneVerificationMethod> getCampLejeuneVerificationMethods() {
        return Collections.unmodifiableSet(this.getInternalCampLejeuneVerificationMethods());
    }

    public void addCampLejeuneVerificationMethod(CampLejeuneVerificationMethod method) {
        Validate.notNull((Object)((Object)method), (String)"CampLejeuneVerificationMethod cannot be null");
        if (this.getCampLejeuneMethodByType(method.getVerificationType()) == null) {
            method.setSpecialFactor(this);
            this.getInternalCampLejeuneVerificationMethods().add(method);
        }
    }

    public CampLejeuneVerificationMethod getCampLejeuneMethodByType(CampLejeuneVerificationType methodType) {
        Validate.notNull((Object)((Object)methodType), (String)"CampLejeuneVerificationType cannot be null");
        return this.getCampLejeuneMethodByType(methodType.getCode());
    }

    public CampLejeuneVerificationMethod getCampLejeuneMethodByType(String typeCode) {
        if (StringUtils.isNotEmpty((String)typeCode)) {
            for (CampLejeuneVerificationMethod clMethod : this.getInternalCampLejeuneVerificationMethods()) {
                String methodType = clMethod != null && clMethod.getVerificationType() != null ? clMethod.getVerificationType().getCode() : null;
                if (!StringUtils.equals(methodType, (String)typeCode)) continue;
                return clMethod;
            }
        }
        return null;
    }

    public Date getChangeDate_h() {
        return this.changeDate_h;
    }

    public void setChangeDate_h(Date changeDate_h) {
        this.changeDate_h = changeDate_h;
    }

    public void removeAllCampLejeuneVerificationMethods() {
        for (CampLejeuneVerificationMethod meth : this.getInternalCampLejeuneVerificationMethods()) {
            meth.setSpecialFactor(null);
        }
        this.getInternalCampLejeuneVerificationMethods().clear();
    }

    public void removeCampLejeuneVerificationMethod(CampLejeuneVerificationMethod campLejeuneVerMethod) {
        Validate.notNull((Object)((Object)campLejeuneVerMethod), (String)"CampLejeuneVerificationMethod cannot be null");
        this.removeCampLejeuneVerificationMethodByType(campLejeuneVerMethod.getVerificationType());
    }

    public void removeCampLejeuneVerificationMethodByType(CampLejeuneVerificationType verificationType) {
        Validate.notNull((Object)((Object)verificationType), (String)"CampLejeuneVerificationType connot be null");
        CampLejeuneVerificationMethod veriMethod = this.getCampLejeuneMethodByType(verificationType);
        if (veriMethod != null) {
            veriMethod.setSpecialFactor(null);
            this.internalCampLejeuneVerificationMethods.remove((Object)veriMethod);
        }
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("changeSource", (Object)this.changeSource);
        builder.append("changeSite", (Object)this.changeSite);
        builder.append("internalCampLejeuneVerificationMethods", this.internalCampLejeuneVerificationMethods);
        builder.append("verificationType", (Object)this.verificationType);
        builder.append("comments", (Object)this.comments);
        builder.append("changeDate_h", (Object)this.changeDate_h);
    }
}

