/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.cases;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.cases.Assignment;
import gov.va.med.esr.common.model.cases.AssignmentHistory;
import gov.va.med.esr.common.model.cases.Comment;
import gov.va.med.esr.common.model.cases.Status;
import gov.va.med.esr.common.model.cases.StatusHistory;
import gov.va.med.esr.common.model.cases.WorkflowPerson;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.WkfCaseRequestType;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.lookup.WkfIssueType;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class WorkflowCase
extends AbstractKeyedEntity
implements Serializable {
    private static final long serialVersionUID = -8421943638044133958L;
    public static final String UNASSIGNED_TO = "Unassigned";
    public static final int ERROR_MESSAGE_LENGTH = 250;
    private FunctionalGroup groupType = null;
    private WkfCaseType caseType = null;
    private WkfIssueType issueType = null;
    private Date dueDate = null;
    private WkfCaseRequestType requestReason = null;
    private Set internalAssignments = null;
    private Set internalComments = null;
    private Set internalStatuses = null;
    private VAFacility requestSource = null;
    private Date requestReceivedDate = null;
    private WorkflowPerson person = null;
    private Set historicalAssignments = null;
    private Set historicalStatuses = null;
    private String errorMessage = null;

    public BigDecimal getWorkflowCaseID() {
        return (BigDecimal)(this.getEntityKey() == null ? null : this.getEntityKey().getKeyValue());
    }

    public WkfIssueType getIssueType() {
        return this.issueType;
    }

    public BigDecimal getPersonID() {
        return (BigDecimal)(this.person == null ? null : this.person.getEntityKey().getKeyValue());
    }

    public FunctionalGroup getGroupType() {
        return this.groupType;
    }

    public void setGroupType(FunctionalGroup groupType) {
        this.groupType = groupType;
    }

    public void setIssueType(WkfIssueType issueType) {
        this.issueType = issueType;
    }

    public WkfCaseType getCaseType() {
        return this.caseType;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public WkfCaseRequestType getRequestReason() {
        return this.requestReason;
    }

    public VAFacility getRequestSource() {
        return this.requestSource;
    }

    public Date getRequestReceivedDate() {
        return this.requestReceivedDate;
    }

    public PersonEntityKey getPersonEntityKey() {
        return CommonEntityKeyFactory.createPersonIdEntityKey(this.getPersonID());
    }

    public String getName() {
        return this.person != null ? this.person.getName() : null;
    }

    public String getSsn() {
        return this.person != null ? this.person.getSsn() : null;
    }

    public VPIDEntityKey getVPIDEntityKey() {
        return this.person != null ? this.person.getVPIDEntityKey() : null;
    }

    public Set getComments() {
        return Collections.unmodifiableSet(this.getInternalComments());
    }

    public void setCaseType(WkfCaseType newWkfCaseType) {
        this.caseType = newWkfCaseType;
    }

    public void setDueDate(Date newDueDate) {
        this.dueDate = newDueDate;
    }

    public void setRequestReason(WkfCaseRequestType newRequestReason) {
        this.requestReason = newRequestReason;
    }

    public void setRequestSource(VAFacility newRequestSource) {
        this.requestSource = newRequestSource;
    }

    public void setRequestReceivedDate(Date newRequestReceivedDate) {
        this.requestReceivedDate = newRequestReceivedDate;
    }

    public void addComments(Comment comment) {
        this.getInternalComments().add(comment);
        comment.setWorkflowCase(this);
    }

    public boolean isOverdue() {
        return this.dueDate == null ? false : this.dueDate.before(DateUtils.getCurrentDate());
    }

    public Status getStatus() {
        Set statuses = this.getInternalStatuses();
        if (statuses.size() > 0) {
            return (Status)statuses.iterator().next();
        }
        return null;
    }

    public void setStatus(Status status) {
        this.getInternalStatuses().clear();
        if (status != null) {
            status.setWorkflowCase(this);
            this.getInternalStatuses().add(status);
        }
    }

    public Assignment getAssignment() {
        Set assignments = this.getInternalAssignments();
        if (assignments.size() > 0) {
            return (Assignment)assignments.iterator().next();
        }
        return null;
    }

    public void setAssignment(Assignment assignment) {
        this.getInternalAssignments().clear();
        if (assignment != null) {
            assignment.setWorkflowCase(this);
            this.getInternalAssignments().add(assignment);
        }
    }

    public WorkflowPerson getPerson() {
        return this.person;
    }

    public void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("WorkflowCase.workflowCaseID", (Object)this.getWorkflowCaseID());
        builder.append("WorkflowCase.WkfCaseType", (Object)this.caseType);
        builder.append("WorkflowCase.dueDate", (Object)this.dueDate);
        builder.append("WorkflowCase.requestReason", (Object)this.requestReason);
        if (this.internalComments != null) {
            builder.append("WorkflowCase.comments", (Object)this.internalComments.toString());
        }
        if (this.internalStatuses != null) {
            builder.append("WorkflowCase.statuses", (Object)this.internalStatuses.toString());
        }
        if (this.internalAssignments != null) {
            builder.append("WorkflowCase.assignments", (Object)this.internalAssignments.toString());
        }
    }

    public void setPerson(WorkflowPerson person) {
        this.person = person;
    }

    public Set getAssignmentHistory() {
        return Collections.unmodifiableSet(this.getHistoricalAssignments());
    }

    public List getAssignmentHistoryList() {
        ArrayList list = new ArrayList(this.getAssignmentHistory());
        Collections.sort(list);
        if (list.size() > 0) {
            AssignmentHistory assignmentHistory;
            int i;
            ArrayList<AssignmentHistory> uniqueList = new ArrayList<AssignmentHistory>();
            int index = 0;
            String assignedTo = null;
            for (i = 0; i < list.size(); ++i) {
                ++index;
                assignmentHistory = (AssignmentHistory)list.get(i);
                assignedTo = assignmentHistory.getAssignedTo();
                if (StringUtils.isEmpty((String)assignedTo) || UNASSIGNED_TO.equals(assignedTo)) continue;
                uniqueList.add(assignmentHistory);
                break;
            }
            for (i = index; i < list.size(); ++i) {
                assignmentHistory = (AssignmentHistory)list.get(i);
                String newAssignedTo = assignmentHistory.getAssignedTo();
                if (StringUtils.isEmpty((String)newAssignedTo) || UNASSIGNED_TO.equals(newAssignedTo) || assignedTo == null || newAssignedTo == null || assignedTo.equals(newAssignedTo)) continue;
                assignedTo = newAssignedTo;
                uniqueList.add(assignmentHistory);
            }
            return this.reverse(uniqueList);
        }
        return list;
    }

    public Set getStatusHistory() {
        return Collections.unmodifiableSet(this.getHistoricalStatuses());
    }

    public List getStatusHistoryList() {
        ArrayList list = new ArrayList(this.getStatusHistory());
        Collections.sort(list);
        if (list.size() > 1) {
            ArrayList uniqueList = new ArrayList();
            uniqueList.add(list.get(0));
            WkfCaseStatusType statusType = ((StatusHistory)list.get(0)).getStatusValue();
            for (int i = 1; i < list.size(); ++i) {
                WkfCaseStatusType newStatusType = ((StatusHistory)list.get(i)).getStatusValue();
                if (statusType == null || newStatusType == null || statusType.getCode().equals(newStatusType.getCode())) continue;
                statusType = newStatusType;
                uniqueList.add(list.get(i));
            }
            return this.reverse(uniqueList);
        }
        return this.reverse(list);
    }

    public List getCommentsHistoryList() {
        ArrayList list = new ArrayList(this.getComments());
        Collections.sort(list);
        return this.reverse(list);
    }

    public boolean isClosed() {
        Status status = this.getStatus();
        return status != null && WkfCaseStatusType.CLOSED.getCode().equals(status.getStatusValue().getCode());
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage != null && errorMessage.length() > 250 ? errorMessage.substring(0, 250) : errorMessage;
    }

    private Set getInternalComments() {
        if (this.internalComments == null) {
            this.internalComments = new HashSet();
        }
        return this.internalComments;
    }

    private void setInternalComments(Set internalComments) {
        this.internalComments = internalComments;
    }

    private Set getInternalStatuses() {
        if (this.internalStatuses == null) {
            this.internalStatuses = new HashSet();
        }
        return this.internalStatuses;
    }

    private void setInternalStatuses(Set newStatuses) {
        this.internalStatuses = newStatuses;
    }

    private Set getInternalAssignments() {
        if (this.internalAssignments == null) {
            this.internalAssignments = new HashSet();
        }
        return this.internalAssignments;
    }

    private void setInternalAssignments(Set internalAssignments) {
        this.internalAssignments = internalAssignments;
    }

    private Set getHistoricalAssignments() {
        if (this.historicalAssignments == null) {
            this.historicalAssignments = new HashSet();
        }
        return this.historicalAssignments;
    }

    private Set getHistoricalStatuses() {
        if (this.historicalStatuses == null) {
            this.historicalStatuses = new HashSet();
        }
        return this.historicalStatuses;
    }

    private void setHistoricalAssignments(Set historicalAssignments) {
        this.historicalAssignments = historicalAssignments;
    }

    private void setHistoricalStatuses(Set historicalStatuses) {
        this.historicalStatuses = historicalStatuses;
    }

    private List reverse(List sourceList) {
        if (sourceList != null & sourceList.size() > 1) {
            int size = sourceList.size();
            int n = sourceList.size() / 2;
            for (int i = 0; i < n; ++i) {
                Object temp = sourceList.get(i);
                int last = size - (i + 1);
                sourceList.set(i, sourceList.get(last));
                sourceList.set(last, temp);
            }
        }
        return sourceList;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.setHistoricalAssignments(null);
        this.setInternalComments(null);
        this.setHistoricalStatuses(null);
        this.setInternalStatuses(null);
        this.setInternalAssignments(null);
    }
}

