/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.cases;

import gov.va.med.esr.common.model.cases.WorkflowCase;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.DateUtils;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Assignment
extends AbstractKeyedEntity
implements Comparable {
    private static final long serialVersionUID = -5328997034827424491L;
    private WorkflowCase workflowCase;
    private String assignedTo = null;
    private String assignedBy = null;
    private Date assignmentDate = null;

    public String getAssignedBy() {
        return this.assignedBy;
    }

    public String getAssignedTo() {
        return this.assignedTo;
    }

    public Date getAssignmentDate() {
        return this.assignmentDate;
    }

    public WorkflowCase getWorkflowCase() {
        return this.workflowCase;
    }

    public void setAssignedBy(String assignedBy) {
        this.assignedBy = assignedBy;
    }

    public void setAssignedTo(String assignedTo) {
        this.assignedTo = assignedTo;
        if (assignedTo != null && this.assignmentDate == null) {
            this.assignmentDate = DateUtils.getCurrentDate();
        }
    }

    public void setAssignmentDate(Date assignmentDate) {
        this.assignmentDate = assignmentDate;
    }

    public void setWorkflowCase(WorkflowCase workflowCase) {
        this.workflowCase = workflowCase;
    }

    public BigDecimal getAssignmentID() {
        return (BigDecimal)(this.getEntityKey() == null ? null : this.getEntityKey().getKeyValue());
    }

    public BigDecimal getWorkflowCaseID() {
        if (this.getWorkflowCase() == null || this.getWorkflowCase().getEntityKey() == null) {
            return null;
        }
        return (BigDecimal)this.getWorkflowCase().getEntityKey().getKeyValue();
    }

    public void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("Assignment.assignedTo", (Object)this.assignedTo);
        builder.append("Assignment.assignedBy", (Object)this.assignedBy);
        builder.append("Assignment.assignmentDate", (Object)this.assignmentDate);
    }

    public int compareTo(Object obj) {
        if (obj != null && obj instanceof Assignment) {
            Date otherAssigmentDate = ((Assignment)obj).getAssignmentDate();
            if (this.assignmentDate != null && otherAssigmentDate != null) {
                return this.assignmentDate.compareTo(otherAssigmentDate);
            }
            if (this.assignmentDate != null) {
                return 1;
            }
            if (otherAssigmentDate != null) {
                return -1;
            }
        }
        return 0;
    }
}

