/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.infra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.set.AbstractSerializableSetDecorator;
import org.apache.commons.lang.Validate;

public class RemoveTransformedSet
extends AbstractSerializableSetDecorator {
    private static final long serialVersionUID = 6226884980920409498L;
    protected final Transformer transformer;

    public static Set decorate(Set set, Transformer transformer) {
        return new RemoveTransformedSet(set, transformer);
    }

    private RemoveTransformedSet(Set set, Transformer transformer) {
        super(set);
        Validate.notNull((Object)transformer, (String)"Transformer must not be null");
        this.transformer = transformer;
    }

    protected Collection contains(Collection coll) {
        ArrayList list = new ArrayList(coll.size());
        for (Object obj : coll) {
            if (!super.getCollection().contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    protected Collection notContains(Collection coll) {
        ArrayList list = new ArrayList(super.getCollection().size());
        for (Object obj : super.getCollection()) {
            if (coll.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    protected Object transform(Object object) {
        return this.transformer.transform(object);
    }

    protected Collection transform(Collection coll) {
        ArrayList<Object> list = new ArrayList<Object>(coll.size());
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            list.add(this.transform(it.next()));
        }
        return list;
    }

    public void clear() {
        ArrayList list = new ArrayList(super.getCollection());
        super.getCollection().clear();
        this.transform(list);
    }

    public boolean remove(Object object) {
        boolean returnValue = super.getCollection().remove(object);
        if (returnValue) {
            this.transform(object);
        }
        return returnValue;
    }

    public boolean removeAll(Collection coll) {
        boolean retValue = super.getCollection().removeAll(coll);
        this.transform(coll);
        return retValue;
    }

    public boolean retainAll(Collection coll) {
        boolean retValue = super.getCollection().retainAll(coll);
        this.transform(coll);
        return retValue;
    }
}

