/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.infra;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateStringFormat;
import gov.va.med.fw.util.DateUtils;
import java.util.Calendar;
import java.util.Date;

public class ImpreciseDateUtils {
    public static final int DEFAULT_DAY = 15;
    public static final int DEFAULT_MONTH = 5;
    public static final int DEFAULT_Reconciliation_DAY = 1;
    public static final int DEFAULT_Reconciliation_MONTH = 0;
    public static final String YYYYMMDD = "yyyyMMdd";

    public static Date getDateWithDefault(ImpreciseDate value) {
        return ImpreciseDateUtils.getDateWithDefault(value, 5, 15);
    }

    public static Date getReconcilitationDateWithDefault(ImpreciseDate value) {
        return ImpreciseDateUtils.getDateWithDefault(value, 0, 1);
    }

    public static Date getDateWithDefault(ImpreciseDate value, int defaultMonth, int defaultDay) {
        if (value == null) {
            return null;
        }
        if (value.isPrecise()) {
            return value.getDate();
        }
        if (value.isMonthPrecise()) {
            Calendar calendar = new ImpreciseDateStringFormat(value.getString()).getCalendar();
            calendar.set(5, defaultDay);
            return calendar.getTime();
        }
        Calendar calendar = new ImpreciseDateStringFormat(value.getString()).getCalendar();
        calendar.set(2, defaultMonth);
        calendar.set(5, defaultDay);
        return calendar.getTime();
    }

    public static ImpreciseDate createImpreciseDate(int year) {
        return new ImpreciseDate(DateUtils.createCalendar((int)year));
    }

    public static ImpreciseDate createImpreciseDate(int year, int month) {
        return new ImpreciseDate(DateUtils.createCalendar((int)year, (int)month));
    }

    public static ImpreciseDate createImpreciseDate(int year, int month, int day) {
        return new ImpreciseDate(DateUtils.createCalendar((int)year, (int)month, (int)day));
    }

    public static ImpreciseDate createImpreciseDateWithoutTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.clear();
        calendar.set(year, month, day);
        return new ImpreciseDate(calendar);
    }

    public static ImpreciseDate createImpreciseDate(int year, int month, int day, int hour) {
        return new ImpreciseDate(DateUtils.createCalendar((int)year, (int)month, (int)day, (int)hour));
    }

    public static ImpreciseDate createImpreciseDate(int year, int month, int day, int hour, int minute) {
        return new ImpreciseDate(DateUtils.createCalendar((int)year, (int)month, (int)day, (int)hour, (int)minute));
    }

    public static ImpreciseDate createImpreciseDate(int year, int month, int day, int hour, int minute, int second) {
        return new ImpreciseDate(DateUtils.createCalendar((int)year, (int)month, (int)day, (int)hour, (int)minute, (int)second));
    }

    public static ImpreciseDate createImpreciseDate(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return new ImpreciseDate(DateUtils.createCalendar((int)year, (int)month, (int)day, (int)hour, (int)minute, (int)second, (int)millisecond));
    }

    private ImpreciseDateUtils() {
    }

    public static boolean impreciseDatesEqualWithoutTime(ImpreciseDate date1, ImpreciseDate date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null && date2 != null || date1 != null && date2 == null) {
            return false;
        }
        return date1.getDate() != null && date2.getDate() != null ? ImpreciseDateUtils.createImpreciseDateWithoutTime(date1.getDate()).equals((Object)ImpreciseDateUtils.createImpreciseDateWithoutTime(date2.getDate())) : date1.equals((Object)date2);
    }
}

