/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.infra;

import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;

public class ImpreciseDateStringFormat {
    private static final String PATTERN = "([0-9]{4})([0-9]{2})?(00)?(00)?(00)?";
    private static final int GROUP_YEAR = 1;
    private static final int GROUP_MONTH = 2;
    private static final String FORMAT_MONTH = "00";
    private final Calendar calendar;
    private final String string;

    public ImpreciseDateStringFormat(Calendar calendar) {
        Validate.notNull((Object)calendar, (String)"calendar cannot be null");
        this.calendar = calendar;
        this.string = calendar.isSet(2) ? this.formatString(calendar.get(1), calendar.get(2)) : this.formatString(calendar.get(1));
    }

    public ImpreciseDateStringFormat(String string) {
        Validate.notNull((Object)string, (String)"string cannot be null");
        this.calendar = this.parseString(string);
        this.string = string;
    }

    private int convertToInt(String string) {
        return new Integer(string);
    }

    private String formatString(int year) {
        return this.formatYear(year);
    }

    private String formatString(int year, int month) {
        return this.formatYear(year) + this.formatMonth(month);
    }

    private String formatMonth(int month) {
        DecimalFormat format = new DecimalFormat(FORMAT_MONTH);
        return format.format(month + 1);
    }

    private String formatYear(int year) {
        DecimalFormat format = new DecimalFormat("0000");
        return format.format(year);
    }

    private Calendar parseString(String string) {
        Matcher matcher = Pattern.compile(PATTERN).matcher(string);
        if (matcher.matches()) {
            String year = matcher.group(1);
            String month = matcher.group(2);
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            calendar.clear();
            calendar.set(1, this.convertToInt(year));
            if (month != null && !FORMAT_MONTH.equals(month)) {
                calendar.set(2, this.convertToInt(month) - 1);
            }
            return calendar;
        }
        throw new RuntimeException("the string is in an invalid imprecise date format");
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public String getString() {
        return this.string;
    }
}

