/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.DeploymentMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.model.ee.Deployment;
import gov.va.med.esr.common.model.lookup.MHDataSource;
import gov.va.med.esr.common.model.lookup.MsdsCountry;
import gov.va.med.esr.common.model.lookup.SpecialOperation;
import gov.va.med.esr.common.model.lookup.TerminationReason;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class DeploymentBuilder
extends EntityBuilder {
    private static final long serialVersionUID = -4209467969311775385L;
    private Builder countryBuilder;
    private Builder mhDataSourceBuilder;
    private Builder specialOperationBuilder;
    private Builder terminationReasonBuilder;

    public Deployment build(DeploymentMetaData metaData) throws BuilderException {
        Deployment input = metaData.getEntity();
        Deployment output = input == null ? new Deployment() : input;
        this.transfer(output, metaData);
        return this.shouldKeep((Object)output) ? output : null;
    }

    private void transfer(Deployment input, DeploymentMetaData metaData) throws BuilderException {
        input.setCountry((MsdsCountry)super.build(this.countryBuilder, (AbstractLookup)input.getCountry(), metaData.getCountry()));
        input.setDataSource((MHDataSource)super.build(this.mhDataSourceBuilder, (AbstractLookup)input.getDataSource(), metaData.getDataSource()));
        input.setSpecialOperation((SpecialOperation)super.build(this.specialOperationBuilder, (AbstractLookup)input.getSpecialOperation(), metaData.getSpecialOperation()));
        input.setDeploymentBeginDate(super.build(input.getDeploymentBeginDate(), metaData.getDeploymentBeginDate()));
        input.setDeploymentEndDate(super.build(input.getDeploymentEndDate(), metaData.getDeploymentEndDate()));
        input.setTerminationReason((TerminationReason)super.build(this.terminationReasonBuilder, (AbstractLookup)input.getTerminationReason(), metaData.getTerminationReason()));
    }

    public Builder getCountryBuilder() {
        return this.countryBuilder;
    }

    public void setCountryBuilder(Builder countryBuilder) {
        this.countryBuilder = countryBuilder;
    }

    public Builder getMhDataSourceBuilder() {
        return this.mhDataSourceBuilder;
    }

    public void setMhDataSourceBuilder(Builder mhDataSourceBuilder) {
        this.mhDataSourceBuilder = mhDataSourceBuilder;
    }

    public Builder getSpecialOperationBuilder() {
        return this.specialOperationBuilder;
    }

    public void setSpecialOperationBuilder(Builder specialOperationBuilder) {
        this.specialOperationBuilder = specialOperationBuilder;
    }

    public Builder getTerminationReasonBuilder() {
        return this.terminationReasonBuilder;
    }

    public void setTerminationReasonBuilder(Builder terminationReasonBuilder) {
        this.terminationReasonBuilder = terminationReasonBuilder;
    }
}

