/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.msds.CombatEpisodeMetaDataInterfaceForMSDS;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.OEFOIFSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.builder.BuilderException;

public class CombatEpisodeBuilderForMSDS
extends EntityBuilder {
    private static final long serialVersionUID = -4397343617673790771L;
    private LookupService lookupService = null;

    public CombatEpisode build(CombatEpisodeMetaDataInterfaceForMSDS metaData) throws BuilderException {
        CombatEpisode input = metaData.getEntity();
        CombatEpisode output = input == null ? new CombatEpisode() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(CombatEpisode obj) {
        return obj.getStartDate() != null && obj.getEndDate() != null && obj.getConflictLocation() != null;
    }

    private ConflictLocation buildConflict(String code) throws BuilderException {
        try {
            return this.getLookupService().getConflictByCode(code);
        }
        catch (ServiceException e) {
            throw new BuilderException("Invalid Conflict Location: " + code, (Throwable)e);
        }
    }

    private void transfer(CombatEpisode input, CombatEpisodeMetaDataInterfaceForMSDS metaData) throws BuilderException {
        input.setEndDate(super.build(input.getEndDate(), metaData.getEndDate()));
        input.setStartDate(super.build(input.getStartDate(), metaData.getStartDate()));
        input.setConflictLocation(this.buildConflict(metaData.getConflictLocation()));
        try {
            input.setOEFOIFSource((OEFOIFSource)this.getLookupService().getByCode(OEFOIFSource.class, metaData.getSource()));
        }
        catch (ServiceException e) {
            throw new BuilderException("Invalid OEFOIFSource: " + (Object)((Object)e));
        }
        String code = metaData.getCombatPayType();
        if (code != null) {
            try {
                if (CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION.getCode().equals(code)) {
                    input.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
                } else if (CombatPayType.CODE_HOSTILE_FIRE_IMMINENT_DANGER.getCode().equals(code)) {
                    input.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_HOSTILE_FIRE_IMMINENT_DANGER));
                }
            }
            catch (ServiceException e) {
                throw new BuilderException("Invalid CombatPayType: " + code, (Throwable)e);
            }
        }
        if (metaData.getFacility() != null) {
            input.setOEFOIFStationNumber((VAFacility)((Object)this.getVaFacilityBuilder().build((Object)metaData.getFacility())));
        }
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
}

