/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.AssetMetaData;
import gov.va.med.esr.common.builder.entity.DebtMetaData;
import gov.va.med.esr.common.builder.entity.ExpenseMetaData;
import gov.va.med.esr.common.builder.entity.FinancialInformationMetaData;
import gov.va.med.esr.common.builder.entity.IncomeMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AssetMetaDataFromZICPosition;
import gov.va.med.esr.common.builder.entity.metaData.DebtMetaDataFromZIC;
import gov.va.med.esr.common.builder.entity.metaData.ExpenseMetaDataFromZICPosition;
import gov.va.med.esr.common.builder.entity.metaData.IncomeMetaDataFromZICPosition;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.fw.hl7.segment.ZIC;
import gov.va.med.fw.hl7.segment.ZMT;

public abstract class FinancialInformationMetaDataFromZIC
extends AbstractMetaData
implements FinancialInformationMetaData {
    private ZIC zic;
    private AssetMetaData[] assets;
    private DebtMetaData debt;
    private ExpenseMetaData[] expenses;
    private IncomeMetaData[] income;

    public FinancialInformationMetaDataFromZIC(ZIC zic, ZMT zmt) {
        this.zic = zic;
        this.assets = zic == null ? null : this.buildAssets(zic);
        this.debt = zic == null ? null : new DebtMetaDataFromZIC(zic);
        this.expenses = zic == null ? null : this.buildExpenses(zic);
        this.income = zic == null ? null : this.buildIncome(zic, zmt);
    }

    private AssetMetaData[] buildAssets(ZIC zic) {
        AssetMetaData[] results = new AssetMetaData[]{new AssetMetaDataFromZICPosition(zic.getCashAmountInBankAccounts(), AssetType.CODE_CASH.getName()), new AssetMetaDataFromZICPosition(zic.getStocksAndBonds(), AssetType.CODE_STOCKS_AND_BONDS.getName()), new AssetMetaDataFromZICPosition(zic.getRealProperty(), AssetType.CODE_REAL_ESTATE.getName()), new AssetMetaDataFromZICPosition(zic.getOtherPropertyAssets(), AssetType.CODE_OTHER.getName())};
        return results;
    }

    protected ExpenseMetaData[] buildExpenses(ZIC zic) {
        ExpenseMetaData[] results = new ExpenseMetaData[]{new ExpenseMetaDataFromZICPosition(zic.getMedicalExpenses(), ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL.getName()), new ExpenseMetaDataFromZICPosition(zic.getFuneralExpenses(), ExpenseType.EXPENSE_TYPE_FUNERAL_AND_BURIAL.getName()), new ExpenseMetaDataFromZICPosition(zic.getEducationalExpenses(), ExpenseType.EXPENSE_TYPE_COLLEGE_AND_VOCATION.getName())};
        return results;
    }

    private IncomeMetaData[] buildIncome(ZIC zic, ZMT zmt) {
        IncomeMetaData[] results = new IncomeMetaData[10];
        if ("0".equals(zmt.getMeansTestVersion())) {
            results[0] = new IncomeMetaDataFromZICPosition(zic.getSocialSecurityOrGrossIncome(), IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName());
            results[9] = new IncomeMetaDataFromZICPosition(zic.getOtherIncome(), IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName());
        } else {
            results[0] = new IncomeMetaDataFromZICPosition(zic.getSocialSecurityOrGrossIncome(), IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName());
            results[9] = new IncomeMetaDataFromZICPosition(zic.getOtherIncome(), IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName());
        }
        results[1] = new IncomeMetaDataFromZICPosition(zic.getCivilService(), IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName());
        results[2] = new IncomeMetaDataFromZICPosition(zic.getRailroadRetirement(), IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getName());
        results[3] = new IncomeMetaDataFromZICPosition(zic.getMilitaryRetirement(), IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getName());
        results[4] = new IncomeMetaDataFromZICPosition(zic.getUnemploymentCompensation(), IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName());
        results[5] = new IncomeMetaDataFromZICPosition(zic.getOtherRetirement(), IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName());
        results[6] = new IncomeMetaDataFromZICPosition(zic.getEmploymentIncome(), IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getName());
        results[7] = new IncomeMetaDataFromZICPosition(zic.getInterestDividendAnnuity(), IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY.getName());
        results[8] = new IncomeMetaDataFromZICPosition(zic.getWorkersCompBlackLung(), IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getName());
        return results;
    }

    @Override
    public AssetMetaData[] getAssets() {
        return this.assets;
    }

    @Override
    public DebtMetaData getDebt() {
        return this.debt;
    }

    @Override
    public ExpenseMetaData[] getExpenses() {
        return this.expenses;
    }

    @Override
    public IncomeMetaData[] getIncome() {
        return this.income;
    }

    @Override
    public String getIncomeYear() {
        return this.zic == null ? null : this.zic.getIncomeYear();
    }
}

