/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.EthnicityMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.person.Ethnicity;

public class EthnicityMetaDataFromCE
extends AbstractMetaData
implements EthnicityMetaData {
    private static final String ETHNICITY_ENCODING_DELIMITER = "-";
    private Ethnicity entity;
    private CE ce;
    private String ethnicityType = null;
    private String collectionMethod = null;

    public EthnicityMetaDataFromCE(CE ce) {
        this.ce = ce;
        this.parseIDField();
    }

    @Override
    public Ethnicity getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(Ethnicity entity) {
        this.entity = entity;
    }

    private void parseIDField() {
        String ID2;
        String string = ID2 = this.ce == null ? null : super.getValue(this.ce.getID());
        if (ID2 != null && ID2.length() > 0) {
            int delimiterIndex = ID2.lastIndexOf(ETHNICITY_ENCODING_DELIMITER);
            if (delimiterIndex != -1) {
                this.setEthnicityType(ID2.substring(0, delimiterIndex));
                this.setCollectionMethod(ID2.substring(delimiterIndex + 1));
            } else {
                this.setEthnicityType(ID2);
            }
        }
    }

    @Override
    public String getEthnicityType() {
        return this.ethnicityType;
    }

    private void setEthnicityType(String ethnicityType) {
        this.ethnicityType = ethnicityType;
    }

    @Override
    public String getCollectionMethod() {
        return this.collectionMethod;
    }

    private void setCollectionMethod(String collectionMethod) {
        this.collectionMethod = collectionMethod;
    }
}

