/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.DependentFinancialsMetaData;
import gov.va.med.esr.common.builder.entity.DependentMetaData;
import gov.va.med.esr.common.builder.entity.ExpenseMetaData;
import gov.va.med.esr.common.builder.entity.PersonMetaData;
import gov.va.med.esr.common.builder.entity.metaData.DependentMetaDataFromZDP;
import gov.va.med.esr.common.builder.entity.metaData.ExpenseMetaDataFromZICPosition;
import gov.va.med.esr.common.builder.entity.metaData.FinancialInformationMetaDataFromZIC;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.fw.hl7.segment.ZDP;
import gov.va.med.fw.hl7.segment.ZIC;
import gov.va.med.fw.hl7.segment.ZIR;
import gov.va.med.fw.hl7.segment.ZMT;

public class DependentFinancialsMetaDataFromZDP
extends FinancialInformationMetaDataFromZIC
implements DependentFinancialsMetaData {
    private DependentFinancials entity;
    private ZIR zir;
    private PersonMetaData reportedOn;
    private DependentMetaData reportedOnDependent;

    public DependentFinancialsMetaDataFromZDP(ZDP zdp, ZIC zic, ZIR zir, ZMT zmt) {
        super(zic, zmt);
        this.zir = zir;
        this.reportedOnDependent = zdp == null ? null : new DependentMetaDataFromZDP(zdp);
    }

    @Override
    protected ExpenseMetaData[] buildExpenses(ZIC zic) {
        ExpenseMetaData[] results = new ExpenseMetaData[]{new ExpenseMetaDataFromZICPosition(zic.getMedicalExpenses(), ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL.getName()), new ExpenseMetaDataFromZICPosition(zic.getFuneralExpenses(), ExpenseType.EXPENSE_TYPE_FUNERAL_AND_BURIAL.getName()), new ExpenseMetaDataFromZICPosition(zic.getEducationalExpenses(), ExpenseType.EXPENSE_TYPE_EDUCATIONAL_EXPENSES_BY_DEPENDENT.getName())};
        return results;
    }

    @Override
    public DependentFinancials getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(DependentFinancials entity) {
        this.entity = entity;
    }

    @Override
    public String getAttendedSchool() {
        return this.zir == null ? null : this.zir.getDependentChildSchoolIndicator();
    }

    @Override
    public String getContributedToSupport() {
        return this.zir == null ? null : this.zir.getContributedToSupport();
    }

    @Override
    public String getAmountContributedToSupport() {
        return this.zir == null ? null : this.zir.getAmountContributedToSpouseDep();
    }

    @Override
    public String getHasIncome() {
        return this.zir == null ? null : this.zir.getChildHadIncome();
    }

    @Override
    public String getIncapableOfSelfSupport() {
        return this.zir == null ? null : this.zir.getIncapableOfSelfSupport();
    }

    @Override
    public String getIncomeAvailableToPatient() {
        return this.zir == null ? null : this.zir.getIncomeAvailableToYou();
    }

    @Override
    public String getLivedWithPatient() {
        return this.zir == null ? null : this.zir.getLivedWithPatient();
    }

    @Override
    public PersonMetaData getReportedOn() {
        return this.reportedOn;
    }

    @Override
    public DependentMetaData getReportedOnDependent() {
        return this.reportedOnDependent;
    }
}

