/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.CDConditionMetaData;
import gov.va.med.esr.common.builder.entity.CDDescriptorMetaData;
import gov.va.med.esr.common.builder.entity.CDDiagnosisMetaData;
import gov.va.med.esr.common.builder.entity.CDProcedureMetaData;
import gov.va.med.esr.common.builder.entity.CatastrophicDisabilityMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.entity.metaData.CDConditionMetaDataFromZCD;
import gov.va.med.esr.common.builder.entity.metaData.CDDescriptorMetaDataFromCE;
import gov.va.med.esr.common.builder.entity.metaData.CDDiagnosisMetaDataFromZCD;
import gov.va.med.esr.common.builder.entity.metaData.CDProcedureMetaDataFromZCD;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.fw.hl7.segment.ZCD;
import java.util.HashSet;
import java.util.List;

public class CatastrophicDisabilityMetaDataFromZCD
extends AbstractMetaData
implements CatastrophicDisabilityMetaData {
    private CatastrophicDisability entity;
    private ZCD zcd;
    private CE ce;
    private CDConditionMetaData[] conditions;
    private CDDiagnosisMetaData[] diagnoses;
    private CDProcedureMetaData[] procedures;
    private CDDescriptorMetaData[] descriptors;

    public CatastrophicDisabilityMetaDataFromZCD(List zcds) {
        this.zcd = zcds == null || zcds.isEmpty() ? null : (ZCD)zcds.get(0);
        this.ce = this.zcd == null ? null : CE.create(this.zcd.getDeterminationMethod(), this.zcd.getComponentDelimiter());
        this.processZCDs(zcds);
    }

    private void processZCDs(List zcds) {
        int size = zcds == null ? 0 : zcds.size();
        HashSet<CDConditionMetaDataFromZCD> conditionSet = new HashSet<CDConditionMetaDataFromZCD>(size);
        HashSet<CDDiagnosisMetaDataFromZCD> diagnosisSet = new HashSet<CDDiagnosisMetaDataFromZCD>(size);
        HashSet<CDProcedureMetaDataFromZCD> procedureSet = new HashSet<CDProcedureMetaDataFromZCD>(size);
        HashSet<CDDescriptorMetaDataFromCE> descriptorSet = new HashSet<CDDescriptorMetaDataFromCE>(size);
        for (int index = 0; index < size; ++index) {
            ZCD zcdSeg = (ZCD)zcds.get(index);
            if (this.isDescriptor(zcdSeg)) {
                CE[] data = CE.create(zcdSeg.getDescriptor(), zcdSeg.getRepeatDelimiter(), zcdSeg.getComponentDelimiter());
                if (data == null || data.length <= 0) continue;
                int dataSize = data.length;
                for (int dataIndex = 0; dataIndex < dataSize; ++dataIndex) {
                    descriptorSet.add(new CDDescriptorMetaDataFromCE(data[dataIndex]));
                }
                continue;
            }
            if (!this.getCatastrophicallyDisabled().equalsIgnoreCase("Y")) continue;
            if (this.isCondition(zcdSeg)) {
                conditionSet.add(new CDConditionMetaDataFromZCD(zcdSeg));
            }
            if (this.isDiagnosis(zcdSeg)) {
                diagnosisSet.add(new CDDiagnosisMetaDataFromZCD(zcdSeg));
            }
            if (!this.isProcedure(zcdSeg)) continue;
            procedureSet.add(new CDProcedureMetaDataFromZCD(zcdSeg));
        }
        this.conditions = new CDConditionMetaData[conditionSet.size()];
        this.diagnoses = new CDDiagnosisMetaData[diagnosisSet.size()];
        this.procedures = new CDProcedureMetaData[procedureSet.size()];
        this.descriptors = new CDDescriptorMetaData[descriptorSet.size()];
        this.conditions = conditionSet.toArray(this.conditions);
        this.diagnoses = diagnosisSet.toArray(this.diagnoses);
        this.procedures = procedureSet.toArray(this.procedures);
        this.descriptors = descriptorSet.toArray(this.descriptors);
    }

    private boolean isCondition(ZCD zcdSeg) {
        return super.hasData(zcdSeg.getCondition());
    }

    private boolean isDiagnosis(ZCD zcdSeg) {
        return super.hasData(zcdSeg.getDiagnosis());
    }

    private boolean isProcedure(ZCD zcdSeg) {
        return super.hasData(zcdSeg.getProcedure());
    }

    private boolean isDescriptor(ZCD zcdSeg) {
        return super.hasData(zcdSeg.getDescriptor());
    }

    @Override
    public CatastrophicDisability getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(CatastrophicDisability entity) {
        this.entity = entity;
    }

    @Override
    public String getCatastrophicallyDisabled() {
        return this.zcd == null ? null : this.zcd.getCatastrophicallyDisabled();
    }

    @Override
    public CDConditionMetaData[] getConditions() {
        return this.conditions;
    }

    @Override
    public String getDeterminationMethod() {
        return this.ce == null ? null : super.getValue(this.ce.getID());
    }

    @Override
    public String getDeterminedBy() {
        return this.zcd == null ? null : this.zcd.getDecidedBy();
    }

    @Override
    public CDDiagnosisMetaData[] getDiagnoses() {
        return this.diagnoses;
    }

    @Override
    public CDProcedureMetaData[] getProcedures() {
        return this.procedures;
    }

    @Override
    public CDDescriptorMetaData[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public String getReviewDate() {
        return this.zcd == null ? null : this.zcd.getReviewDate();
    }

    @Override
    public String getDeterminationDate() {
        return this.zcd == null ? null : this.zcd.getDecisionDate();
    }

    @Override
    public String getDeterminationFacility() {
        return this.zcd == null ? null : this.zcd.getDeterminationFacility();
    }

    @Override
    public String getVeteranRequestedCDReviewDate() {
        return this.zcd == null ? null : this.zcd.getVeteranRequestedCDReviewDate();
    }

    @Override
    public String getFacilityInitiatedCDReviewDate() {
        return this.zcd == null ? null : this.zcd.getFacilityInitiatedCDReviewDate();
    }

    @Override
    public String getVeteranWasNotifiedCDDate() {
        return this.zcd == null ? null : this.zcd.getVeteranWasNotifiedCDDate();
    }
}

