/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.RatedDisabilityMetaData;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.lookup.DiagnosticExtremity;
import gov.va.med.esr.common.model.lookup.Disability;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class RatedDisabilityBuilder
extends EntityBuilder {
    private static final long serialVersionUID = 1492120114974389699L;
    private Builder disabilityBuilder;
    private Builder diagnosticExtremityBuilder;

    public Builder getDisabilityBuilder() {
        return this.disabilityBuilder;
    }

    public void setDisabilityBuilder(Builder disabilityBuilder) {
        this.disabilityBuilder = disabilityBuilder;
    }

    public Builder getDiagnosticExtremityBuilder() {
        return this.diagnosticExtremityBuilder;
    }

    public void setDiagnosticExtremityBuilder(Builder diagnosticExtremityBuilder) {
        this.diagnosticExtremityBuilder = diagnosticExtremityBuilder;
    }

    public RatedDisability build(RatedDisabilityMetaData metaData) throws BuilderException {
        RatedDisability input = metaData.getEntity();
        Boolean shouldAdd = super.build((Boolean)null, metaData.getServiceConnected());
        if (Boolean.TRUE.equals(shouldAdd)) {
            RatedDisability output = input == null ? new RatedDisability() : input;
            this.transfer(output, metaData);
            return this.shouldKeep(output) ? output : null;
        }
        return null;
    }

    private Disability buildDisability(Disability input, String code) throws BuilderException {
        return super.shouldDelete(code) ? null : (Disability)super.build(this.disabilityBuilder, (AbstractLookup)input, code);
    }

    private DiagnosticExtremity buildDiagnosticExtremity(DiagnosticExtremity input, String code) throws BuilderException {
        return super.shouldDelete(code) ? null : (DiagnosticExtremity)super.build(this.diagnosticExtremityBuilder, (AbstractLookup)input, code);
    }

    private boolean shouldKeep(RatedDisability obj) {
        return obj.getDisability() != null && obj.getPercentage() != null;
    }

    private void transfer(RatedDisability input, RatedDisabilityMetaData metaData) throws BuilderException {
        input.setDisability(this.buildDisability(input.getDisability(), metaData.getDisability()));
        input.setPercentage(super.build(input.getPercentage(), metaData.getPercentage()));
        input.setDiagnosticExtremity(this.buildDiagnosticExtremity(input.getDiagnosticExtremity(), metaData.getDiagnosticExtremity()));
        input.setOriginalEffectiveRatingDate(super.build(input.getOriginalEffectiveRatingDate(), metaData.getRatedDisabilityOrigEffectiveDate()));
        input.setRatingDate(super.build(input.getRatingDate(), metaData.getRatedDisabilityCurrentEffectiveDate()));
    }
}

