/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.IneligibilityFactorMetaData;
import gov.va.med.esr.common.builder.entity.metaData.IneligibilityFactorMetaDataFromZIE;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.hl7.HL7Message;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.util.builder.BuilderException;

public class IneligibilityFactorBuilder
extends EntityBuilder {
    private static final long serialVersionUID = -8507938170328001418L;

    public IneligibilityFactor build(Person person, HL7Message message) throws BuilderException, InvalidMessageException {
        IneligibilityFactor factor = person.getIneligibilityFactor();
        IneligibilityFactorMetaDataFromZIE metaData = new IneligibilityFactorMetaDataFromZIE(message.getZIESegment(), message.getMSHSegment());
        metaData.setEntity(factor);
        return this.build(metaData);
    }

    public IneligibilityFactor build(IneligibilityFactorMetaData metaData) throws BuilderException {
        IneligibilityFactor input = metaData.getEntity();
        IneligibilityFactor output = input == null ? new IneligibilityFactor() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(IneligibilityFactor obj) {
        return obj.getIneligibleDate() != null;
    }

    private void transfer(IneligibilityFactor input, IneligibilityFactorMetaData metaData) throws BuilderException {
        input.setFacilityReceived(super.build(input.getFacilityReceived(), metaData.getFacilityReceived()));
        input.setIneligibleDate(super.build(input.getIneligibleDate(), metaData.getIneligibleDate()));
        input.setReason(super.build(input.getReason(), metaData.getReason()));
        input.setVaroDecision(super.build(input.getVaroDecision(), metaData.getVARODecision()));
    }
}

