/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.EmailMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.model.lookup.EmailSourceOfChange;
import gov.va.med.esr.common.model.lookup.EmailType;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class EmailBuilder
extends EntityBuilder {
    private static final long serialVersionUID = -4764005178073222016L;
    private Builder changeSourceBuilder;
    private Builder typeBuilder;

    public Builder getTypeBuilder() {
        return this.typeBuilder;
    }

    public void setTypeBuilder(Builder typeBuilder) {
        this.typeBuilder = typeBuilder;
    }

    public Builder getChangeSourceBuilder() {
        return this.changeSourceBuilder;
    }

    public void setChangeSourceBuilder(Builder changeSourceBuilder) {
        this.changeSourceBuilder = changeSourceBuilder;
    }

    public Email build(EmailMetaData metaData) throws BuilderException {
        Email input = metaData.getEntity();
        Email output = input == null ? new Email() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private EmailType buildType(EmailType input, String code) throws BuilderException {
        return (EmailType)super.build(this.typeBuilder, (AbstractLookup)input, code);
    }

    private boolean shouldKeep(Email obj) {
        return obj.getAddress() != null;
    }

    private void transfer(Email input, EmailMetaData metaData) throws BuilderException {
        input.setAddress(super.build(input.getAddress(), metaData.getEmailAddress()));
        input.setChangeDate(super.build(input.getChangeDate(), metaData.getChangeDate()));
        input.setSiteOfChange(super.build(input.getSiteOfChange(), metaData.getChangeSite()));
        input.setSourceOfChange((EmailSourceOfChange)super.build(this.changeSourceBuilder, (AbstractLookup)input.getSourceOfChange(), metaData.getChangeSource()));
        input.setType(this.buildType(input.getType(), EmailType.CODE_PRIVATE.getName()));
    }
}

