/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.ImpreciseDateBuilder;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.builder.BuilderException;

public class CustomImpreciseDateBuilder
extends ImpreciseDateBuilder {
    private static final long serialVersionUID = -7086549178305149467L;
    public static final String DEFAULT_DATE_FORMAT = "yyyyMMDD";
    public static final int DATE_LENGTH = 8;
    private String dateFormat = "yyyyMMDD";
    private static final String LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT = "yyyy";
    private static final String UPPER_CASE_FOUR_DIGIT_YEAR_FORMAT = "YYYY";
    private static final String LOWER_CASE_MONTH_FORMAT = "mm";
    private static final String UPPER_CASE_MONTH_FORMAT = "MM";
    private static final String LOWER_CASE_DAY_FORMAT = "dd";
    private static final String UPPER_CASE_DAY_FORMAT = "DD";

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public ImpreciseDate build(String value) throws BuilderException {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        if (this.dateFormat != null && this.dateFormat.length() < 8) {
            throw new BuilderException("The Date format " + this.dateFormat + " is in an invalid imprecise date format");
        }
        StringBuffer dateStrBuf = new StringBuffer();
        int yearIndex = StringUtils.indexOf((String)this.dateFormat, (String)LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT) != -1 ? StringUtils.indexOf((String)this.dateFormat, (String)LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT) : StringUtils.indexOf((String)this.dateFormat, (String)UPPER_CASE_FOUR_DIGIT_YEAR_FORMAT);
        int monthIndex = StringUtils.indexOf((String)this.dateFormat, (String)LOWER_CASE_MONTH_FORMAT) != -1 ? StringUtils.indexOf((String)this.dateFormat, (String)LOWER_CASE_MONTH_FORMAT) : StringUtils.indexOf((String)this.dateFormat, (String)UPPER_CASE_MONTH_FORMAT);
        int dayIndex = StringUtils.indexOf((String)this.dateFormat, (String)LOWER_CASE_DAY_FORMAT) != -1 ? StringUtils.indexOf((String)this.dateFormat, (String)LOWER_CASE_DAY_FORMAT) : StringUtils.indexOf((String)this.dateFormat, (String)UPPER_CASE_DAY_FORMAT);
        String yearString = yearIndex != -1 && value.length() >= 4 ? StringUtils.substring((String)value, (int)yearIndex, (int)(yearIndex + LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT.length())) : "";
        String monthString = monthIndex != -1 && value.length() >= 6 ? StringUtils.substring((String)value, (int)monthIndex, (int)(monthIndex + LOWER_CASE_MONTH_FORMAT.length())) : "";
        String dayString = dayIndex != -1 && value.length() >= 8 ? StringUtils.substring((String)value, (int)dayIndex, (int)(dayIndex + LOWER_CASE_DAY_FORMAT.length())) : "";
        dateStrBuf.append(yearString);
        dateStrBuf.append(monthString);
        dateStrBuf.append(dayString);
        return dateStrBuf.toString().trim().length() > 0 ? super.parseString(dateStrBuf.toString().trim()) : null;
    }
}

