/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.AssociationMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.metaData.AssociationMetaDataFromZCT;
import gov.va.med.esr.common.builder.entity.metaData.AssociationMetaDataFromZGD;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.SimpleAddress;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class AssociationBuilder
extends EntityBuilder {
    public static final String VA_GUARDIAN = "1";
    public static final String VA_CIVIL = "2";
    public static final String PRIMARY_NEXT_OF_KIN = "1";
    public static final String OTHER_NEXT_OF_KIN = "2";
    public static final String EMERGENCY_CONTACT = "3";
    public static final String OTHER_EMERGENCY_CONTACT = "4";
    public static final String DESIGNEE = "5";
    private static final long serialVersionUID = 2534437700958487077L;
    private Builder addressBuilder;
    private Builder nameBuilder;
    private Builder phoneBuilder;
    private Builder relationshipBuilder;
    private Builder typeBuilder;

    public Builder getAddressBuilder() {
        return this.addressBuilder;
    }

    public void setAddressBuilder(Builder addressBuilder) {
        this.addressBuilder = addressBuilder;
    }

    public Builder getNameBuilder() {
        return this.nameBuilder;
    }

    public void setNameBuilder(Builder nameBuilder) {
        this.nameBuilder = nameBuilder;
    }

    public Builder getPhoneBuilder() {
        return this.phoneBuilder;
    }

    public void setPhoneBuilder(Builder phoneBuilder) {
        this.phoneBuilder = phoneBuilder;
    }

    public Builder getRelationshipBuilder() {
        return this.relationshipBuilder;
    }

    public void setRelationshipBuilder(Builder relationshipBuilder) {
        this.relationshipBuilder = relationshipBuilder;
    }

    public Builder getTypeBuilder() {
        return this.typeBuilder;
    }

    public void setTypeBuilder(Builder typeBuilder) {
        this.typeBuilder = typeBuilder;
    }

    public Association build(AssociationMetaData metaData) throws BuilderException {
        Association input = metaData.getEntity();
        Association output = input == null ? new Association() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private void transfer(Association input, AssociationMetaData metaData) throws BuilderException {
        input.setAddress(this.buildAddress(input.getAddress(), metaData.getAddress()));
        input.setPrimaryPhone(super.build(input.getPrimaryPhone(), metaData.getPrimaryPhone() == null ? null : metaData.getPrimaryPhone().getPhoneNumber()));
        input.setRelationship(super.build(input.getRelationship(), metaData.getRelationship()));
        input.setType(this.buildType(input.getType(), metaData));
        if (input.getType() != null && (AssociationType.CODE_GUARDIAN_VA.getCode().equals(input.getType().getCode()) || AssociationType.CODE_GUARDIAN_CIVIL.getCode().equals(input.getType().getCode()))) {
            input.setOrganizationName(metaData.getGuardianName());
        } else {
            Name name = metaData.getContactName() == null ? null : (Name)this.nameBuilder.build((Object)metaData.getContactName());
            input.setRepresentativeName(name);
        }
        input.setAlternatePhone(super.build(input.getAlternatePhone(), metaData.getAlternatePhone() == null ? null : metaData.getAlternatePhone().getPhoneNumber()));
        input.setLastUpdateDate(super.build(input.getLastUpdateDate(), metaData.getLastUpdateDate()));
    }

    private Address buildAddress(SimpleAddress input, AddressMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity((Address)input);
        return (Address)this.addressBuilder.build((Object)metaData);
    }

    private AssociationType buildType(AssociationType input, AssociationMetaData metaData) throws BuilderException {
        AssociationType type = null;
        if (metaData instanceof AssociationMetaDataFromZCT) {
            if ("1".equals(metaData.getType())) {
                type = (AssociationType)super.build(this.typeBuilder, (AbstractLookup)input, AssociationType.CODE_PRIMARY_NEXT_OF_KIN.getName());
            } else if ("2".equals(metaData.getType())) {
                type = (AssociationType)super.build(this.typeBuilder, (AbstractLookup)input, AssociationType.CODE_OTHER_NEXT_OF_KIN.getName());
            } else if (EMERGENCY_CONTACT.equals(metaData.getType())) {
                type = (AssociationType)super.build(this.typeBuilder, (AbstractLookup)input, AssociationType.CODE_EMERGENCY_CONTACT.getName());
            } else if (OTHER_EMERGENCY_CONTACT.equals(metaData.getType())) {
                type = (AssociationType)super.build(this.typeBuilder, (AbstractLookup)input, AssociationType.CODE_OTHER_EMERGENCY_CONTACT.getName());
            } else if (DESIGNEE.equals(metaData.getType())) {
                type = (AssociationType)super.build(this.typeBuilder, (AbstractLookup)input, AssociationType.CODE_DESIGNEE.getName());
            }
        } else if (metaData instanceof AssociationMetaDataFromZGD) {
            if ("1".equals(metaData.getType())) {
                type = (AssociationType)super.build(this.typeBuilder, (AbstractLookup)input, AssociationType.CODE_GUARDIAN_VA.getName());
            } else if ("2".equals(metaData.getType())) {
                type = (AssociationType)super.build(this.typeBuilder, (AbstractLookup)input, AssociationType.CODE_GUARDIAN_CIVIL.getName());
            }
        }
        return type;
    }

    private boolean shouldKeep(Association obj) {
        return obj.getType() != null && (obj.getRelationship() != null || obj.getRepresentativeName() != null || obj.getOrganizationName() != null && !this.shouldDelete(obj.getOrganizationName()));
    }

    private Name buildContactName(Association input, AssociationMetaData metaData) throws BuilderException {
        return metaData.getContactName() == null ? null : (Name)this.nameBuilder.build((Object)metaData.getContactName());
    }
}

