/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.datatype.metadata;

import gov.va.med.esr.common.builder.datatype.metadata.AbstractDataTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.ComplexTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.ID;
import gov.va.med.esr.common.builder.datatype.metadata.IS;
import gov.va.med.esr.common.builder.datatype.metadata.ST;

public class XPN
extends ComplexTypeMetaData {
    private static final int POSITION_FAMILY_NAME = 0;
    private static final int POSITION_GIVEN_NAME = 1;
    private static final int POSITION_MIDDLE_NAME = 2;
    private static final int POSITION_SUFFIX = 3;
    private static final int POSITION_PREFIX = 4;
    private static final int POSITION_DEGREE = 5;
    private static final int POSITION_TYPE_CODE = 6;
    private static final int POSITION_REPRESENTATION_CODE = 7;
    private static final int DATA_SIZE = 8;

    public static XPN[] create(String value, String repeatDelimiter, String delimiter) {
        if (value == null) {
            return null;
        }
        String[] components = AbstractDataTypeMetaData.splitData(value, repeatDelimiter);
        int size = components == null ? 0 : components.length;
        XPN[] elements = new XPN[size];
        for (int index = 0; index < size; ++index) {
            elements[index] = XPN.create(components[index], delimiter);
        }
        return elements;
    }

    public static XPN create() {
        return new XPN(new AbstractDataTypeMetaData[8]);
    }

    public static XPN create(String value, String delimiter) {
        if (AbstractDataTypeMetaData.shouldDelete(value)) {
            return null;
        }
        AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[8];
        String[] components = AbstractDataTypeMetaData.splitData(value, delimiter);
        int size = components == null ? 0 : components.length;
        data[0] = size > 0 ? ST.create(components[0]) : null;
        data[1] = size > 1 ? ST.create(components[1]) : null;
        data[2] = size > 2 ? ST.create(components[2]) : null;
        data[3] = size > 3 ? ST.create(components[3]) : null;
        data[4] = size > 4 ? ST.create(components[4]) : null;
        data[5] = size > 5 ? IS.create(components[5]) : null;
        data[6] = size > 6 ? ID.create(components[6]) : null;
        data[7] = size > 7 ? ID.create(components[7]) : null;
        return new XPN(data);
    }

    public static String getDataString(XPN[] data, String repeatDelimiter, String delimiter) {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter, delimiter, null);
    }

    XPN(AbstractDataTypeMetaData[] data) {
        super(data);
    }

    public ST getFamilyName() {
        return (ST)super.getData(0);
    }

    public void setFamilyName(ST familyName) {
        super.setData(0, familyName);
    }

    public ST getGivenName() {
        return (ST)super.getData(1);
    }

    public void setGivenName(ST givenName) {
        super.setData(1, givenName);
    }

    public ST getMiddleName() {
        return (ST)super.getData(2);
    }

    public void setMiddleName(ST middleName) {
        super.setData(2, middleName);
    }

    public ST getSuffix() {
        return (ST)super.getData(3);
    }

    public void setSuffix(ST suffix) {
        super.setData(3, suffix);
    }

    public ST getPrefix() {
        return (ST)super.getData(4);
    }

    public void setPrefix(ST prefix) {
        super.setData(4, prefix);
    }

    public IS getDegree() {
        return (IS)super.getData(5);
    }

    public void setDegree(IS degree) {
        super.setData(5, degree);
    }

    public ID getTypeCode() {
        return (ID)super.getData(6);
    }

    public void setTypeCode(ID typeCode) {
        super.setData(6, typeCode);
    }

    public ID getRepresentationCode() {
        return (ID)super.getData(7);
    }

    public void setRepresentationCode(ID representationCode) {
        super.setData(7, representationCode);
    }

    public final String getDataString(String delimiter) {
        return super.getDataString(delimiter, null);
    }
}

