/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.datatype.metadata;

import gov.va.med.esr.common.builder.datatype.metadata.AbstractDataTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.ComplexTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.HD;
import gov.va.med.esr.common.builder.datatype.metadata.ID;
import gov.va.med.esr.common.builder.datatype.metadata.IS;
import gov.va.med.esr.common.builder.datatype.metadata.ST;

public class XCN
extends ComplexTypeMetaData {
    private static final int POSITION_ID = 0;
    private static final int POSITION_FAMILY_NAME = 1;
    private static final int POSITION_GIVEN_NAME = 2;
    private static final int POSITION_MIDDLE_NAME = 3;
    private static final int POSITION_SUFFIX = 4;
    private static final int POSITION_PREFIX = 5;
    private static final int POSITION_DEGREE = 6;
    private static final int POSITION_SOURCE_TABLE = 7;
    private static final int POSITION_ASSIGNING_AUTHORITY = 8;
    private static final int POSITION_TYPE_CODE = 9;
    private static final int POSITION_ID_CHECK_DIGIT = 10;
    private static final int POSITION_ID_CHECK_DIGIT_SCHEME_CODE = 11;
    private static final int POSITION_ID_TYPE_CODE = 12;
    private static final int POSITION_ASSIGNING_FACILITY = 13;
    private static final int POSITION_REPRESENTATION_CODE = 14;
    private static final int DATA_SIZE = 15;

    public static XCN[] create(String value, String repeatDelimiter, String delimiter, String subDelimiter) {
        if (value == null) {
            return null;
        }
        String[] components = AbstractDataTypeMetaData.splitData(value, repeatDelimiter);
        int size = components == null ? 0 : components.length;
        XCN[] elements = new XCN[size];
        for (int index = 0; index < size; ++index) {
            elements[index] = XCN.create(components[index], delimiter, subDelimiter);
        }
        return elements;
    }

    public static XCN create() {
        return new XCN(new AbstractDataTypeMetaData[15]);
    }

    public static XCN create(String value, String delimiter, String subDelimiter) {
        if (AbstractDataTypeMetaData.shouldDelete(value)) {
            return null;
        }
        AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[15];
        String[] components = AbstractDataTypeMetaData.splitData(value, delimiter);
        int size = components == null ? 0 : components.length;
        data[0] = size > 0 ? ST.create(components[0]) : null;
        data[1] = size > 1 ? ST.create(components[1]) : null;
        data[2] = size > 2 ? ST.create(components[2]) : null;
        data[3] = size > 3 ? ST.create(components[3]) : null;
        data[4] = size > 4 ? ST.create(components[4]) : null;
        data[5] = size > 5 ? ST.create(components[5]) : null;
        data[6] = size > 6 ? IS.create(components[6]) : null;
        data[7] = size > 7 ? IS.create(components[7]) : null;
        data[8] = size > 8 ? HD.create(components[8], subDelimiter) : null;
        data[9] = size > 9 ? ID.create(components[9]) : null;
        data[10] = size > 10 ? ST.create(components[10]) : null;
        data[11] = size > 11 ? ID.create(components[11]) : null;
        data[12] = size > 12 ? IS.create(components[12]) : null;
        data[13] = size > 13 ? HD.create(components[13], subDelimiter) : null;
        data[14] = size > 14 ? ID.create(components[14]) : null;
        return new XCN(data);
    }

    public static String getDataString(XCN[] data, String repeatDelimiter, String delimiter) {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter, delimiter, null);
    }

    XCN(AbstractDataTypeMetaData[] data) {
        super(data);
    }

    public ST getID() {
        return (ST)super.getData(0);
    }

    public void setID(ST id) {
        super.setData(0, id);
    }

    public ST getFamilyName() {
        return (ST)super.getData(1);
    }

    public void setFamilyName(ST familyName) {
        super.setData(1, familyName);
    }

    public ST getGivenName() {
        return (ST)super.getData(2);
    }

    public void setGivenName(ST givenName) {
        super.setData(2, givenName);
    }

    public ST getMiddleName() {
        return (ST)super.getData(3);
    }

    public void setMiddleName(ST middleName) {
        super.setData(3, middleName);
    }

    public ST getSuffix() {
        return (ST)super.getData(4);
    }

    public void setSuffix(ST suffix) {
        super.setData(4, suffix);
    }

    public ST getPrefix() {
        return (ST)super.getData(5);
    }

    public void setPrefix(ST prefix) {
        super.setData(5, prefix);
    }

    public IS getDegree() {
        return (IS)super.getData(6);
    }

    public void setDegree(IS degree) {
        super.setData(6, degree);
    }

    public IS getSourceTable() {
        return (IS)super.getData(7);
    }

    public void setSourceTable(IS sourceTable) {
        super.setData(7, sourceTable);
    }

    public HD getAssigningAuthority() {
        return (HD)super.getData(8);
    }

    public void setAssigningAuthority(HD assigningAuthority) {
        super.setData(8, assigningAuthority);
    }

    public ID getTypeCode() {
        return (ID)super.getData(9);
    }

    public void setTypeCode(ID typeCode) {
        super.setData(9, typeCode);
    }

    public ST getIDCheckDigit() {
        return (ST)super.getData(10);
    }

    public void setIDCheckDigit(ST idCheckDigit) {
        super.setData(10, idCheckDigit);
    }

    public ID getIDCheckDigitSchemeCode() {
        return (ID)super.getData(11);
    }

    public void setIDCheckDigitSchemeCode(ID idCheckDigitSchemeCode) {
        super.setData(11, idCheckDigitSchemeCode);
    }

    public IS getIDTypeCode() {
        return (IS)super.getData(12);
    }

    public void setIDTypeCode(IS idTypeCode) {
        super.setData(12, idTypeCode);
    }

    public HD getAssigningFacility() {
        return (HD)super.getData(13);
    }

    public void setAssigningFacility(HD assigningFacility) {
        super.setData(13, assigningFacility);
    }

    public ID getRepresentationCode() {
        return (ID)super.getData(14);
    }

    public void setRepresentationCode(ID representationCode) {
        super.setData(14, representationCode);
    }
}

