/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.datatype.metadata;

import gov.va.med.esr.common.builder.datatype.metadata.AbstractDataTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.ComplexTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.ID;
import gov.va.med.esr.common.builder.datatype.metadata.ST;

public class AD
extends ComplexTypeMetaData {
    private static final int POSITION_STREET_ADDRESS = 0;
    private static final int POSITION_OTHER_DESIGNATION = 1;
    private static final int POSITION_CITY = 2;
    private static final int POSITION_STATE = 3;
    private static final int POSITION_ZIP_CODE = 4;
    private static final int POSITION_COUNTRY_CODE = 5;
    private static final int POSITION_TYPE_CODE = 6;
    private static final int POSITION_OTHER_GEOGRAPHIC_DESIGNATION = 7;
    private static final int DATA_SIZE = 8;

    public static AD[] create(String value, String repeatDelimiter, String delimiter) {
        if (value == null) {
            return null;
        }
        String[] components = AbstractDataTypeMetaData.splitData(value, repeatDelimiter);
        int size = components == null ? 0 : components.length;
        AD[] elements = new AD[size];
        for (int index = 0; index < size; ++index) {
            elements[index] = AD.create(components[index], delimiter);
        }
        return elements;
    }

    public static AD create() {
        return new AD(new AbstractDataTypeMetaData[8]);
    }

    public static AD create(String value, String delimiter) {
        if (AbstractDataTypeMetaData.shouldDelete(value)) {
            return null;
        }
        AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[8];
        String[] components = AbstractDataTypeMetaData.splitData(value, delimiter);
        int size = components == null ? 0 : components.length;
        data[0] = size > 0 ? ST.create(components[0]) : null;
        data[1] = size > 1 ? ST.create(components[1]) : null;
        data[2] = size > 2 ? ST.create(components[2]) : null;
        data[3] = size > 3 ? ST.create(components[3]) : null;
        data[4] = size > 4 ? ST.create(components[4]) : null;
        data[5] = size > 5 ? ID.create(components[5]) : null;
        data[6] = size > 6 ? ID.create(components[6]) : null;
        data[7] = size > 7 ? ST.create(components[7]) : null;
        return new AD(data);
    }

    public static String getDataString(AD[] data, String repeatDelimiter, String delimiter) {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter, delimiter, null);
    }

    AD(AbstractDataTypeMetaData[] data) {
        super(data);
    }

    public ST getStreetAddress() {
        return (ST)super.getData(0);
    }

    public void setStreetAddress(ST streetAddress) {
        super.setData(0, streetAddress);
    }

    public ST getOtherDesignation() {
        return (ST)super.getData(1);
    }

    public void setOtherDesignation(ST otherDesignation) {
        super.setData(1, otherDesignation);
    }

    public ST getCity() {
        return (ST)super.getData(2);
    }

    public void setCity(ST city) {
        super.setData(2, city);
    }

    public ST getState() {
        return (ST)super.getData(3);
    }

    public void setState(ST state) {
        super.setData(3, state);
    }

    public ST getZipCode() {
        return (ST)super.getData(4);
    }

    public void setZipCode(ST zipCode) {
        super.setData(4, zipCode);
    }

    public ID getCountryCode() {
        return (ID)super.getData(5);
    }

    public void setCountryCode(ID countryCode) {
        super.setData(5, countryCode);
    }

    public ID getTypeCode() {
        return (ID)super.getData(6);
    }

    public void setTypeCode(ID typeCode) {
        super.setData(6, typeCode);
    }

    public ST getOtherGeographicDesignation() {
        return (ST)super.getData(7);
    }

    public void setOtherGeographicDesignation(ST otherGeographicDesignation) {
        super.setData(7, otherGeographicDesignation);
    }

    public final String getDataString(String delimiter) {
        return super.getDataString(delimiter, null);
    }
}

