/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.comms;

import gov.va.med.esr.common.builder.comms.ITransmission;
import gov.va.med.esr.common.model.comms.MailingStatusLink;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.util.LetterFormatHelper;
import gov.va.med.esr.common.util.MailingAddressHelper;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.fw.service.ServiceException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class GeneralTransmission
implements ITransmission {
    protected static final String EMPTY_STRING = "";
    protected static final String TODAY_DATE_FORMAT_STRING = "MM/dd/yyyy";
    protected static SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
    private boolean isVeteranSet = false;
    private boolean isWorkloadSet = false;
    private boolean isLogSet = false;
    protected boolean historicalCopy = false;
    protected PersonHelperService helperService;
    protected List logs;
    protected Person vet;
    protected Hashtable dataElementTable = null;
    protected String vetVISN = null;
    protected boolean hasPseudoSSNOnly;
    protected Date todayDt = null;
    protected GregorianCalendar cal = null;
    private String caseNumber;
    private String barcodeData;
    private Address localVeteranAddress;
    private String formNumber = "";
    private String incomeYear;
    private String aacVersionNumber;
    private BigDecimal workflowCaseId;
    private static Hashtable addressPriorityTable;
    private List veteranRepresentatives;
    private String currentRepresentative;
    private String currentRepresentativePhone;
    private boolean vetSsnVerified;
    private String vetTitle;
    private String veteranFirstName;
    private String veteranLastName;
    private String veteranMiddleName;
    private String veteranSuffix;
    private AddressType veteranAddressType;
    private String veteranAddressLine1;
    private String veteranAddressLine2;
    private String veteranAddressLine3;
    private String veteranCity;
    private String veteranState;
    private String veteranCountyOrProvince;
    private String veteranZipCodeOrPostalCode;
    private String veteranCountry;
    private String veteranCountryName;
    private String veteranDateOfDeath;
    private String homePhoneNumber;
    private String workPhoneNumber;
    protected String veteranSsn;
    private String stationNumber;
    private String todaysDate;
    private String undelivRetAddress;
    private String veteranGender;
    private String userNumber;
    private String veteranName;
    private String veteranDOB;
    private String workloadStatusCode;
    private String workloadActivityCode;
    private String currentRepPhoneNumber;
    private String mailingAddress;
    private ArrayList missingDataElements = new ArrayList();
    private Address mailingAdress = null;
    private String originationTypeCode;
    private String veteranPersonIdentifier = null;
    protected LookupService lookupService = null;

    public GeneralTransmission() {
    }

    public GeneralTransmission(Person veteran, String incomeYear, BigDecimal workflowCaseId) {
        this.vet = veteran;
        this.incomeYear = incomeYear;
        this.workflowCaseId = workflowCaseId;
        this.cal = new GregorianCalendar();
        this.todayDt = this.cal.getTime();
    }

    protected static String getString(String str) {
        return LetterFormatHelper.getString(str);
    }

    public void setHelperService(PersonHelperService service) {
        this.helperService = service;
    }

    @Override
    public String getIncomeYear() {
        if (this.incomeYear == null || this.incomeYear.length() == 0) {
            this.incomeYear = this.cal.get(1) - 1 + EMPTY_STRING;
        }
        return this.incomeYear;
    }

    @Override
    public void setIncomeYear(String inYearStr) {
        this.incomeYear = inYearStr;
    }

    @Override
    public boolean validate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVeteranRelatedProperties() {
        if (this.isVeteranSet || this.historicalCopy) {
            return;
        }
        if (this.vet != null) {
            Name legalName;
            Date aDate = null;
            if (this.vet.getBirthRecord() != null && this.vet.getBirthRecord().getBirthDate() != null && this.vet.getBirthRecord().getBirthDate().getDate() != null) {
                aDate = this.vet.getBirthRecord().getBirthDate().getDate();
                SimpleDateFormat simpleDateFormat = sdf;
                synchronized (simpleDateFormat) {
                    this.veteranDOB = sdf.format(aDate);
                }
            }
            if ((legalName = Name.getNameOfType(this.vet.getNames(), NameType.LEGAL_NAME.getName())) != null) {
                this.veteranFirstName = legalName.getGivenName();
                this.veteranLastName = legalName.getFamilyName();
                this.veteranSuffix = legalName.getSuffix();
                this.vetTitle = legalName.getPrefix();
            }
            if (this.vet.getGender() != null) {
                this.veteranGender = this.vet.getGender().getCode();
            }
            if (this.vetTitle == null || this.vetTitle.length() == 0) {
                this.vetTitle = this.veteranGender != null && this.veteranGender.length() > 0 ? (this.veteranGender.equals("M") ? "MR." : "MS.") : "MR.";
            }
            if (this.vet.getDeathRecord() != null && this.vet.getDeathRecord().getDeathDate() != null) {
                aDate = this.vet.getDeathRecord().getDeathDate().getDate();
                SimpleDateFormat simpleDateFormat = sdf;
                synchronized (simpleDateFormat) {
                    this.veteranDateOfDeath = sdf.format(aDate);
                }
            }
            if (this.veteranSsn != null) {
                this.vetSsnVerified = true;
            } else {
                SSN ssn = null;
                try {
                    ssn = this.helperService.getSSN(SSNType.CODE_ACTIVE.getName(), this.vet);
                }
                catch (ServiceException sex) {
                    this.veteranSsn = null;
                }
                if (ssn != null) {
                    this.vetSsnVerified = true;
                    this.veteranSsn = ssn.getSsnText();
                }
            }
            Set addrSet = this.vet.getAddresses();
            Set phoneSet = this.vet.getPhones();
            Address addrToUse = MailingAddressHelper.selectAddressForMailing(addrSet);
            if (phoneSet != null && phoneSet.size() > 0) {
                Phone phone = Phone.getPhoneOfType(phoneSet, PhoneType.CODE_HOME.getName());
                if (phone != null) {
                    this.homePhoneNumber = phone.getPhoneNumber();
                }
                if ((phone = Phone.getPhoneOfType(phoneSet, PhoneType.CODE_BUSINESS.getName())) != null) {
                    this.workPhoneNumber = phone.getPhoneNumber();
                }
            }
            this.mailingAdress = addrToUse;
            if (this.mailingAdress != null) {
                this.veteranAddressType = this.mailingAdress.getType();
                this.veteranAddressLine1 = this.mailingAdress.getLine1();
                this.veteranAddressLine2 = this.mailingAdress.getLine2();
                this.veteranAddressLine3 = this.mailingAdress.getLine3();
                this.veteranCity = this.mailingAdress.getCity();
                this.veteranState = LetterFormatHelper.getMailingAddressState(this.mailingAdress);
                this.veteranZipCodeOrPostalCode = LetterFormatHelper.getMailingAddressZipOrPostal(this.mailingAdress);
                this.veteranCountyOrProvince = LetterFormatHelper.getMailingAddressCountyOrProvince(this.mailingAdress);
                this.veteranCountry = this.mailingAdress.getCountry();
                this.veteranCountryName = LetterFormatHelper.getMailingAddressCountry(this.mailingAdress);
            }
            this.veteranPersonIdentifier = this.vet.getVPIDValue();
        }
        this.isVeteranSet = true;
    }

    public Person getVeteran() {
        return this.vet;
    }

    public void setVeteran(Person veteran) {
        this.vet = veteran;
    }

    public String getVeteranTitle() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.vetTitle);
    }

    public void setVeteranTitle(String vetTitle) {
        this.vetTitle = vetTitle;
    }

    public String getVeteranName() {
        this.setVeteranRelatedProperties();
        if (this.veteranName == null) {
            StringBuffer nameString = new StringBuffer();
            nameString.append(this.veteranFirstName);
            nameString.append(" ");
            nameString.append(this.veteranMiddleName);
            nameString.append(" ");
            nameString.append(this.veteranLastName);
            this.veteranName = nameString.toString();
        }
        return GeneralTransmission.getString(this.veteranName);
    }

    public void setVeteranName(String vetName) {
        this.veteranName = vetName;
    }

    public String getVeteranFirstName() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranFirstName);
    }

    public void setVeteranFirstName(String firstName) {
        this.veteranFirstName = firstName;
    }

    public String getVeteranLastName() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranLastName);
    }

    public void setVeteranLastName(String lastName) {
        this.veteranLastName = lastName;
    }

    public String getVeteranMiddleName() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranMiddleName);
    }

    public void setVeteranMiddleName(String middleName) {
        this.veteranMiddleName = middleName;
    }

    public String getVeteranSuffix() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranSuffix);
    }

    public void setVeteranSuffix(String suffix) {
        this.veteranSuffix = suffix;
    }

    public String getVeteranGender() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranGender);
    }

    public void setVeteranGender(String gender) {
        this.veteranGender = gender;
    }

    public AddressType getVeteranAddressType() {
        this.setVeteranRelatedProperties();
        return this.veteranAddressType;
    }

    public void setVeteranAddressType(AddressType veteranAddressType) {
        this.veteranAddressType = veteranAddressType;
    }

    public String getVeteranAddressLine1() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranAddressLine1);
    }

    public void setVeteranAddressLine1(String veteranAddressLine1) {
        this.veteranAddressLine1 = veteranAddressLine1;
    }

    public String getVeteranAddressLine2() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranAddressLine2);
    }

    public void setVeteranAddressLine2(String vetAddrLine2) {
        this.veteranAddressLine2 = vetAddrLine2;
    }

    public String getVeteranAddressLine3() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranAddressLine3);
    }

    public void setVeteranAddressLine3(String veteranAddressLine3) {
        this.veteranAddressLine3 = veteranAddressLine3;
    }

    public String getVeteranCity() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranCity);
    }

    public void setVeteranCity(String veteranCity) {
        this.veteranCity = veteranCity;
    }

    public String getVeteranState() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranState);
    }

    public void setVeteranState(String veteranState) {
        this.veteranState = veteranState;
    }

    public String getVeteranCountry() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranCountry);
    }

    public void setVeteranCountry(String veteranCountry) {
        this.veteranCountry = veteranCountry;
    }

    public String getVeteranDateOfDeath() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranDateOfDeath);
    }

    public void setVeteranDateOfDeath(String veteranDateOfDeath) {
        this.veteranDateOfDeath = veteranDateOfDeath;
    }

    public String getVisn() {
        return GeneralTransmission.getString(this.vetVISN);
    }

    public void setVisn(String visn) {
        this.vetVISN = visn;
    }

    public String getVeteranHomeTelephoneNumber() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.homePhoneNumber);
    }

    public void setVeteranHomeTelephoneNumber(String hmPhNum) {
        this.homePhoneNumber = hmPhNum;
    }

    public String getVeteranWorkTelephoneNumber() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.workPhoneNumber);
    }

    public void setVeteranWorkTelephoneNumber(String workNum) {
        this.workPhoneNumber = workNum;
    }

    public String getVeteranDOB() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranDOB);
    }

    public void setVeteranDOB(String dob) {
        this.veteranDOB = dob;
    }

    public String getVeteranSsn() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranSsn);
    }

    public void setVeteranSsn(String ssn) {
        this.veteranSsn = ssn;
    }

    protected String FormatSSN(String ssn) {
        if (ssn != null && ssn.length() == 9 && ssn.indexOf("-") == -1) {
            StringBuffer hypenSsn = new StringBuffer();
            hypenSsn.append(ssn.substring(0, 3));
            hypenSsn.append("-");
            hypenSsn.append(ssn.substring(3, 5));
            hypenSsn.append("-");
            hypenSsn.append(ssn.substring(5));
            return hypenSsn.toString();
        }
        return ssn;
    }

    protected String GetVeteranOtherSSN() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTodaysDate() {
        if (this.todaysDate == null) {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                this.todaysDate = sdf.format(new Date());
            }
        }
        return this.todaysDate;
    }

    public void setTodaysDate(String today) {
        this.todaysDate = today;
    }

    @Override
    public String getMailingAddress() {
        return GeneralTransmission.getString(this.mailingAddress);
    }

    @Override
    public void setMailingAddress(String mailAddr) {
        this.mailingAddress = mailAddr;
    }

    public String getUndelivRetAddress() {
        return GeneralTransmission.getString(this.undelivRetAddress);
    }

    public void setUndelivRetAddress(String undelAddr) {
        this.undelivRetAddress = undelAddr;
    }

    protected void setWorkloadRelatedProperties() {
        if (this.isWorkloadSet || this.historicalCopy || this.workflowCaseId == null) {
            return;
        }
        List workloadStatusLst = null;
        if (workloadStatusLst == null || workloadStatusLst.size() == 0) {
            this.isWorkloadSet = true;
            return;
        }
        this.isWorkloadSet = true;
    }

    public String getWorkloadActivityCode() {
        this.setWorkloadRelatedProperties();
        return GeneralTransmission.getString(this.workloadActivityCode);
    }

    public void setWorkloadActivityCode(String workloadActivityCode) {
        this.workloadActivityCode = workloadActivityCode;
    }

    public String getWorkloadStatusCode() {
        this.setWorkloadRelatedProperties();
        return GeneralTransmission.getString(this.workloadStatusCode);
    }

    public void setWorkloadStatusCode(String workloadStatusCode) {
        this.workloadStatusCode = workloadStatusCode;
    }

    public String getCurrentRepresentativeTelephone() {
        this.setWorkloadRelatedProperties();
        return GeneralTransmission.getString(this.currentRepPhoneNumber);
    }

    public void setCurrentRepresentativeTelephone(String repNumber) {
        this.currentRepPhoneNumber = repNumber;
    }

    public String getCurrentRepresentative() {
        this.setWorkloadRelatedProperties();
        return GeneralTransmission.getString(this.currentRepresentative);
    }

    public void setCurrentRepresentative(String currRep) {
        this.currentRepresentative = currRep;
    }

    public String getUserNumber() {
        return GeneralTransmission.getString(this.userNumber);
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    public String getAacVersionNumber() {
        return GeneralTransmission.getString(this.aacVersionNumber);
    }

    public void setAacVersionNumber(String aacVersionNumber) {
        this.aacVersionNumber = aacVersionNumber;
    }

    @Override
    public String getBarcodeData() {
        return GeneralTransmission.getString(this.barcodeData);
    }

    @Override
    public void setBarcodeData(String barcodeData) {
        this.barcodeData = barcodeData;
    }

    @Override
    public String getCaseNumber() {
        return GeneralTransmission.getString(this.caseNumber);
    }

    @Override
    public void setCaseNumber(String caseNumber) {
        this.caseNumber = caseNumber;
    }

    @Override
    public String getFormNumber() {
        return GeneralTransmission.getString(this.formNumber);
    }

    @Override
    public void setFormNumber(String formNumber) {
        this.formNumber = formNumber;
    }

    public String getStationNumber() {
        return GeneralTransmission.getString(this.stationNumber);
    }

    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    public BigDecimal getworkflowCaseId() {
        return this.workflowCaseId;
    }

    public void setworkflowCaseId(BigDecimal workflowCaseId) {
        this.workflowCaseId = workflowCaseId;
    }

    public static Object CreateInstanceByXml(String xmlDoc) {
        return null;
    }

    @Override
    public String externalizeAsXml() {
        return null;
    }

    public void SetTemplateDataElements(Hashtable dataElemTable) {
        if (dataElemTable != null) {
            dataElemTable.remove("Attachments");
            dataElemTable.remove("BarcodeData");
        }
        this.dataElementTable = dataElemTable;
    }

    public void setCommsLog(List logs) {
        this.logs = logs;
    }

    protected String getMultiLineAddress(Address personAddress) {
        if (personAddress == null) {
            return null;
        }
        StringBuffer multiLineAddress = new StringBuffer();
        multiLineAddress.append(personAddress.getLine1());
        if (personAddress.getLine2() != null && personAddress.getLine2().length() > 0) {
            multiLineAddress.append("\n").append(personAddress.getLine2());
        }
        if (personAddress.getLine3() != null && personAddress.getLine3().length() > 0) {
            multiLineAddress.append("\n").append(personAddress.getLine3());
        }
        return GeneralTransmission.getString(multiLineAddress.toString());
    }

    protected List getVeteranRepresentatives() {
        return this.veteranRepresentatives;
    }

    public boolean isHistoricalCopy() {
        return this.historicalCopy;
    }

    public void isHistoricalCopy(boolean isHist) {
        this.historicalCopy = isHist;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected boolean isThisAddressDeliverable(Address addr) {
        return addr != null && addr.getLine1() != null && addr.getLine1().length() > 0 && addr.getCity() != null && addr.getCity().length() > 0 && addr.getState() != null && addr.getPostalCode().length() > 0 && addr.getZipCode() != null && addr.getZipCode().length() > 0;
    }

    private boolean isLetterMailedAfterDays(List mailingStatusLinkLst, int days) {
        if (mailingStatusLinkLst == null || mailingStatusLinkLst.size() == 0) {
            return false;
        }
        String statusCd = null;
        MailingStatusLink link = null;
        for (int i = 0; i < mailingStatusLinkLst.size(); ++i) {
            link = (MailingStatusLink)((Object)mailingStatusLinkLst.get(i));
            statusCd = link.getMailingStatus().getCode();
            if ((statusCd == null || !statusCd.equals("0")) && !statusCd.equals("01") && !statusCd.equals("02") && !statusCd.equals("07")) continue;
            if (days == 0) {
                return true;
            }
            return this.todayDt.compareTo(LetterFormatHelper.addDays(this.todayDt, days)) >= 0;
        }
        return false;
    }

    public Address getMailingAdress() {
        this.setVeteranRelatedProperties();
        return this.mailingAdress;
    }

    public void setMailingAdress(Address mailingAdress) {
        this.mailingAdress = mailingAdress;
    }

    public String getVeteranCountyOrProvince() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranCountyOrProvince);
    }

    public void setVeteranCountyOrProvince(String veteranCountyOrProvince) {
        this.veteranCountyOrProvince = veteranCountyOrProvince;
    }

    public String getVeteranZipCodeOrPostalCode() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranZipCodeOrPostalCode);
    }

    public void setVeteranZipCodeOrPostalCode(String veteranZipCodeOrPostalCode) {
        this.veteranZipCodeOrPostalCode = veteranZipCodeOrPostalCode;
    }

    public String getVeteranCountryName() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranCountryName);
    }

    public void setVeteranCountryName(String veteranCountryName) {
        this.veteranCountryName = veteranCountryName;
    }

    @Override
    public List getPOAsWithAddresses() {
        ArrayList<Association> poas = new ArrayList<Association>();
        if (this.vet == null || this.vet.getAssociations() == null || this.vet.getAssociations().size() == 0) {
            return poas;
        }
        Set assocs = this.vet.getAssociations();
        Iterator itr = assocs.iterator();
        Association assoc = null;
        while (itr.hasNext()) {
            assoc = (Association)itr.next();
            if (assoc.getType() == null || !assoc.getType().getCode().equals(AssociationType.CODE_POWER_OF_ATTORNEY.getCode()) || assoc.getAddress() == null) continue;
            poas.add(assoc);
        }
        return poas;
    }

    public Name getPrimaryNextOfKinName() {
        this.setVeteranRelatedProperties();
        Name nokName = null;
        if (this.vet != null) {
            Association primaryNok = Association.getAssociationOfType(this.vet.getAssociations(), AssociationType.CODE_PRIMARY_NEXT_OF_KIN.getCode());
            nokName = primaryNok != null ? primaryNok.getRepresentativeName() : null;
        }
        return nokName;
    }

    public String getVeteranPersonIdentifier() {
        this.setVeteranRelatedProperties();
        return GeneralTransmission.getString(this.veteranPersonIdentifier);
    }

    public void setVeteranPersonIdentifier(String veteranPersonIdentifier) {
        this.veteranPersonIdentifier = veteranPersonIdentifier;
    }
}

