/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.comms;

import gov.va.med.esr.common.builder.comms.AbstractLetterFormatter;
import gov.va.med.esr.common.builder.comms.GeneralTransmission;
import gov.va.med.esr.common.builder.comms.GenerateValues;
import gov.va.med.esr.common.builder.comms.IFormatter;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.LetterFormatHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CmsRemoteFormatter
extends AbstractLetterFormatter {
    private static IFormatter instance = new CmsRemoteFormatter();

    public static IFormatter getInstance() {
        return instance;
    }

    private CmsRemoteFormatter() {
    }

    @Override
    public List format(Person person, GenerateValues inputValues) {
        ArrayList<String> data = new ArrayList<String>();
        data.add(this.buildFormDataElementsForCms(person, inputValues.getOrigTemplate(), (GeneralTransmission)inputValues.getTransmission(), inputValues, null));
        return data;
    }

    protected String buildFormDataElementsForCms(Person person, CommsTemplate template, GeneralTransmission transmission, GenerateValues inputValues, Association poa) {
        StringBuffer dataElements = new StringBuffer();
        this.buildHeader(dataElements, template, inputValues, poa);
        this.buildDataElementsA(dataElements, transmission, inputValues);
        this.buildDataElementsBForIvm(dataElements, transmission, inputValues, poa);
        this.buildDataElementsC(dataElements, transmission, inputValues);
        this.buildDataElementsD(dataElements, transmission, inputValues);
        return dataElements.toString();
    }

    private void buildHeader(StringBuffer dataElements, CommsTemplate template, GenerateValues inputValues, Association poa) {
        String formNumber = template.getCommsTemplateFormNumber();
        String formName = template.getCommsTemplateName();
        dataElements.append("*LETTER=").append(LetterFormatHelper.toAACFormNumber(formNumber)).append("^\n").append("*NAME=").append(formName).append("^\n").append("*VER=").append(LetterFormatHelper.toAACVerNumber("00001")).append("^\n");
        if (this.isCompassionLetter(formNumber)) {
            dataElements.append("*BID=").append(this.getBarcode(inputValues)).append("^\n");
        }
    }

    @Override
    protected void buildDataElementsA(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues) {
        String form = transmission.getFormNumber();
        if (form != null) {
            CommsLogEntry entry = inputValues.getCommsLog();
            String ivmCaseClosureDate = LetterFormatHelper.toAACDate(entry.getIvmCaseClosureDate());
            String ivmCaseNumber = LetterFormatHelper.getString(entry.getIvmCaseNumber());
            if (this.isIVMFinalLetter(form)) {
                dataElements.append("* A01=").append(ivmCaseNumber).append("^\n").append("* A02=").append(ivmCaseClosureDate).append("^\n");
            } else if (this.isCompassionLetter(form)) {
                dataElements.append("* A01=").append(transmission.getVeteranPersonIdentifier()).append("^\n").append("* A02=").append(ivmCaseClosureDate).append("^\n");
            }
        }
    }

    protected void buildDataElementsBForIvm(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues, Association poa) {
        String form = transmission.getFormNumber();
        if (form != null && (this.isIVMFinalLetter(form) || this.isCompassionLetter(form))) {
            CommsLogEntry entry = inputValues.getCommsLog();
            String date = LetterFormatHelper.toAACDate(new Date());
            String commId = entry.getCommsLogIdString();
            dataElements.append("* B01=").append(date).append("^\n").append("* B02=").append(LetterFormatHelper.getString(commId)).append("^\n");
        }
    }

    private String truncateCountryName(String countryName) {
        if (countryName == null) {
            return "";
        }
        if (countryName.length() > 50) {
            countryName = countryName.substring(0, 50);
        }
        return countryName;
    }

    @Override
    protected void buildDataElementsC(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues) {
        String form = transmission.getFormNumber();
        if (form != null) {
            if (this.isIVMFinalLetter(form)) {
                Name legalName = transmission.getVeteran().getLegalName();
                String middleName = legalName != null ? legalName.getMiddleName() : null;
                dataElements.append("* C01=").append(transmission.getVeteranTitle()).append("^\n").append("* C02=").append(transmission.getVeteranFirstName()).append("^\n").append("* C03=").append(LetterFormatHelper.getString(middleName)).append("^\n").append("* C04=").append(transmission.getVeteranLastName()).append("^\n").append("* C05=").append(transmission.getVeteranSuffix()).append("^\n");
            } else if (this.isCompassionLetter(form)) {
                Name nokName = transmission.getPrimaryNextOfKinName();
                String nokPrefix = nokName != null ? nokName.getPrefix() : null;
                String nokFirstName = nokName != null ? nokName.getGivenName() : null;
                String nokMiddleName = nokName != null ? nokName.getMiddleName() : null;
                String nokLastName = nokName != null ? nokName.getFamilyName() : null;
                String nokSuffix = nokName != null ? nokName.getSuffix() : null;
                dataElements.append("* C01=").append(LetterFormatHelper.getString(nokPrefix)).append("^\n").append("* C02=").append(LetterFormatHelper.getString(nokFirstName)).append("^\n").append("* C03=").append(LetterFormatHelper.getString(nokMiddleName)).append("^\n").append("* C04=").append(LetterFormatHelper.getString(nokLastName)).append("^\n").append("* C05=").append(LetterFormatHelper.getString(nokSuffix)).append("^\n");
            }
        }
    }

    @Override
    protected void buildDataElementsD(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues) {
        Address address = transmission.getMailingAdress();
        String addressLine1 = transmission.getVeteranAddressLine1();
        String combinedAddressLine2 = this.getMailingAddressLine2(address);
        String combinedAddressLine3 = this.getMailingAddressLine3(address);
        String city = transmission.getVeteranCity();
        String state = transmission.getVeteranState();
        String zip = this.getMailingAddressZip(address);
        String postal = this.getMailingAddressPostal(address);
        String province = this.getMailingAddressProvince(address);
        String county = this.getMailingAddressCounty(address);
        String country = transmission.getVeteranCountryName();
        dataElements.append("* D01=").append(LetterFormatHelper.getString(addressLine1).toUpperCase()).append("^\n").append("* D02=").append(LetterFormatHelper.getString(combinedAddressLine2).toUpperCase()).append("^\n").append("* D03=").append(LetterFormatHelper.getString(combinedAddressLine3).toUpperCase()).append("^\n").append("* D04=").append(LetterFormatHelper.getString(city).toUpperCase()).append("^\n").append("* D05=").append(LetterFormatHelper.getString(state).toUpperCase()).append("^\n").append("* D06=").append(LetterFormatHelper.getString(zip).toUpperCase()).append("^\n").append("* D07=").append(LetterFormatHelper.getString(postal).toUpperCase()).append("^\n").append("* D08=").append(LetterFormatHelper.getString(province).toUpperCase()).append("^\n").append("* D09=").append(LetterFormatHelper.getString(county).toUpperCase()).append("^\n").append("* D10=").append(this.truncateCountryName(LetterFormatHelper.getString(country).toUpperCase())).append("^\n");
    }

    private String getMailingAddressZip(Address address) {
        String val = null;
        if (address.isUSAddress() && StringUtils.isNotBlank((String)address.getZipCode())) {
            val = StringUtils.isNotBlank((String)address.getZipPlus4()) ? address.getZipCode() + "-" + address.getZipPlus4() : address.getZipCode();
        }
        return val;
    }

    private String getMailingAddressPostal(Address address) {
        return !address.isUSAddress() ? address.getPostalCode() : null;
    }

    private String getMailingAddressLine2(Address address) {
        return this.getString(address.getLine2());
    }

    private String getMailingAddressLine3(Address address) {
        return this.getString(address.getLine3());
    }

    private String getMailingAddressCounty(Address address) {
        return address.isUSAddress() ? address.getCounty() : null;
    }

    private String getMailingAddressProvince(Address address) {
        return !address.isUSAddress() ? address.getProvince() : null;
    }

    @Override
    protected String getBarcode(GenerateValues inputValues) {
        return LetterFormatHelper.formatBarcode(inputValues.getCommsLog().getBarcode());
    }

    @Override
    protected void buildDataElementsH(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues) {
    }

    @Override
    protected void buildDataElementsH20(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues, Person person) {
    }

    private boolean isIVMFinalLetter(String form) {
        return form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_400.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_450.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_451.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_452.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_453.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_454.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_455.getCode());
    }

    private boolean isCompassionLetter(String form) {
        return form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_683A.getCode());
    }
}

