/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.scheduling.AbstractScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import java.util.Hashtable;
import java.util.Set;

public class PersonLoaderProcess
extends AbstractScheduledProcess {
    Hashtable persons;
    Hashtable personSites = new Hashtable();
    Set personKeys;
    int processId;
    private PersonService personService;
    private PSDelegateService psDelegateService;
    private boolean isComplete = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeProcess(ScheduledProcessInvocationContext context) throws Exception {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("executeProcess With processId:" + this.processId + " And personIds :" + this.personKeys));
            }
            if (this.personKeys != null && this.personKeys.size() > 0) {
                for (String personId : this.personKeys) {
                    try {
                        PersonIdEntityKey personEntityKey = CommonEntityKeyFactory.createPersonIdEntityKey(personId);
                        Person person = this.personService.getPerson(personEntityKey);
                        Set currpersonsites = this.psDelegateService.getSites(person.getVPIDEntityKey());
                        this.persons.put(personId, person);
                        this.personSites.put(person.getVPIDEntityKey(), currpersonsites);
                    }
                    catch (Exception eX) {
                        if (!this.logger.isErrorEnabled()) continue;
                        this.logger.error((Object)("Unable to load person : " + personId), (Throwable)eX);
                    }
                }
            }
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Unable to load persons : " + e));
            }
        }
        finally {
            this.isComplete = true;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Completed PersonLoaderProcess for processId:" + this.processId));
            }
        }
    }

    public Set getPersonKeys() {
        return this.personKeys;
    }

    public void setPersonKeys(Set personKeys) {
        this.personKeys = personKeys;
    }

    public Hashtable getPersons() {
        return this.persons;
    }

    public Hashtable getPersonSites() {
        return this.personSites;
    }

    public void setPersonSites(Hashtable personSites) {
        this.personSites = personSites;
    }

    public PSDelegateService getPsDelegateService() {
        return this.psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public void setPersons(Hashtable persons) {
        this.persons = persons;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }
}

