/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import com.infomata.data.DataRow;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.POWCampLocation;
import gov.va.med.esr.common.model.lookup.POWDataSource;
import gov.va.med.esr.common.model.lookup.PrisonerOfWarLocation;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class HECLegacyPOWFileData
extends AbstractRawFileDataContainer {
    private static final long serialVersionUID = -1113521275439594788L;
    private String nameforIndex;
    private Name legalName = new Name();
    private String SSN;
    private String confirmed;
    private ImpreciseDate captureDate;
    private ImpreciseDate releaseDate;
    private PrisonerOfWarLocation confinementLocation;
    private POWCampLocation casualtyPlace;
    private POWDataSource source;
    private ImpreciseDate entered;
    private String user;
    private Integer daysIncarcirated;
    private Set serviceNumbers = new HashSet();

    public Name getLegalName() {
        return this.legalName;
    }

    public void setLegalName(Name legalName) {
        this.legalName = legalName;
    }

    protected void buildToString(ToStringBuilder builder) {
    }

    public ImpreciseDate getCaptureDate() {
        return this.captureDate;
    }

    public void setCaptureDate(ImpreciseDate captureDate) {
        this.captureDate = captureDate;
    }

    public String getConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(String confirmed) {
        this.confirmed = confirmed;
    }

    public Integer getDaysIncarcirated() {
        return this.daysIncarcirated;
    }

    public void setDaysIncarcirated(Integer daysIncarcirated) {
        this.daysIncarcirated = daysIncarcirated;
    }

    public ImpreciseDate getEntered() {
        return this.entered;
    }

    public void setEntered(ImpreciseDate entered) {
        this.entered = entered;
    }

    public ImpreciseDate getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(ImpreciseDate releaseDate) {
        this.releaseDate = releaseDate;
    }

    public String getSSN() {
        return this.SSN;
    }

    public void setSSN(String ssn) {
        this.SSN = ssn;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
        int i = 1;
        int n = ++i;
        this.legalName.setFamilyName(parsedRow.getString(n));
        int n2 = ++i;
        this.legalName.setGivenName(parsedRow.getString(n2));
        int n3 = ++i;
        this.legalName.setMiddleName(parsedRow.getString(n3));
        int n4 = ++i;
        this.legalName.setSuffix(parsedRow.getString(n4));
        int n5 = ++i;
        this.SSN = parsedRow.getString(n5);
        int n6 = ++i;
        this.confirmed = parsedRow.getString(n6);
        int n7 = ++i;
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"captureDate", (String)parsedRow.getString(n7));
        int n8 = ++i;
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"releaseDate", (String)parsedRow.getString(n8));
        int n9 = ++i;
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"confinementLocation", (String)parsedRow.getString(n9));
        int n10 = ++i;
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"casualtyPlace", (String)parsedRow.getString(n10));
        int n11 = ++i;
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"source", (String)parsedRow.getString(n11));
        int n12 = ++i;
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"entered", (String)parsedRow.getString(n12));
        int n13 = ++i;
        this.user = parsedRow.getString(n13);
        int n14 = ++i;
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"daysIncarcirated", (String)parsedRow.getString(n14));
        int n15 = ++i;
        ++i;
        this.serviceNumbers = new HashSet(RawFileDataContainerUtils.parseMultipleValues((String)parsedRow.getString(n15), (String)"|"));
    }

    public PrisonerOfWarLocation getConfinementLocation() {
        return this.confinementLocation;
    }

    public void setConfinementLocation(PrisonerOfWarLocation confinementLocation) {
        this.confinementLocation = confinementLocation;
    }

    public String getNameforIndex() {
        StringBuffer buf = new StringBuffer();
        if (StringUtils.isNotBlank((String)this.legalName.getFamilyName())) {
            buf.append(this.legalName.getFamilyName());
        }
        if (StringUtils.isNotBlank((String)this.legalName.getSuffix())) {
            buf.append(" ").append(this.legalName.getSuffix());
        }
        if (StringUtils.isNotBlank((String)this.legalName.getGivenName())) {
            buf.append(",").append(this.legalName.getGivenName());
        }
        if (StringUtils.isNotBlank((String)this.legalName.getMiddleName())) {
            buf.append(" ").append(this.legalName.getMiddleName());
        }
        return buf.toString();
    }

    public POWCampLocation getCasualtyPlace() {
        return this.casualtyPlace;
    }

    public void setCasualtyPlace(POWCampLocation casualtyPlace) {
        this.casualtyPlace = casualtyPlace;
    }

    public POWDataSource getSource() {
        return this.source;
    }

    public void setSource(POWDataSource source) {
        this.source = source;
    }

    public Set getServiceNumbers() {
        return this.serviceNumbers;
    }

    public void setServiceNumbers(Set serviceNumbers) {
        this.serviceNumbers = serviceNumbers;
    }

    public void addServiceNumber(String serviceNumber) {
        this.serviceNumbers.add(serviceNumber);
    }

    public OrderedMap getRawFileData() throws Exception {
        ListOrderedMap map = new ListOrderedMap();
        map.put((Object)"header", (Object)"POW");
        map.put((Object)"nameforIndex", (Object)this.getNameforIndex());
        map.put((Object)"lastName", (Object)this.legalName.getFamilyName());
        map.put((Object)"firstName", (Object)this.legalName.getGivenName());
        map.put((Object)"middleName", (Object)this.legalName.getMiddleName());
        map.put((Object)"suffix", (Object)this.legalName.getSuffix());
        map.put((Object)"SSN", (Object)this.SSN);
        map.put((Object)"confirmed", (Object)this.confirmed);
        map.put((Object)"captureDate", (Object)this.captureDate);
        map.put((Object)"releaseDate", (Object)this.releaseDate);
        map.put((Object)"confinementLocation", (Object)this.confinementLocation);
        map.put((Object)"casualtyPlace", (Object)this.casualtyPlace);
        map.put((Object)"source", (Object)this.source);
        map.put((Object)"entered", (Object)this.entered);
        map.put((Object)"user", (Object)this.user);
        map.put((Object)"daysIncarcirated", (Object)this.daysIncarcirated);
        map.put((Object)"serviceNumbers", (Object)RawFileDataContainerUtils.formatMultipleValues((Collection)this.serviceNumbers, (String)"|"));
        return map;
    }

    static {
        RawFileDataContainerUtils.autoRegisterConvertersForClass();
    }
}

