/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import com.infomata.data.DataRow;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class HECLegacyIdentityFileData
extends AbstractRawFileDataContainer {
    private static final long serialVersionUID = 2688025902885572269L;
    private String ICN;
    private String SSN;
    private Name legalName = new Name();
    private String degree;
    private ImpreciseDate dateOfBirth;
    private Gender gender;
    private RegistryType registryType;
    private String commsFlag;

    public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
        List nameData;
        int i = 1;
        this.ICN = parsedRow.getString(i++);
        this.SSN = parsedRow.getString(i++);
        int nameDataIndex = 0;
        if ((nameData = RawFileDataContainerUtils.parseMultipleValues((String)parsedRow.getString(i++), (String)"~")).size() > nameDataIndex) {
            this.legalName.setFamilyName((String)nameData.get(nameDataIndex++));
        }
        if (nameData.size() > nameDataIndex) {
            this.legalName.setGivenName((String)nameData.get(nameDataIndex++));
        }
        if (nameData.size() > nameDataIndex) {
            this.legalName.setMiddleName((String)nameData.get(nameDataIndex++));
        }
        if (nameData.size() > nameDataIndex) {
            this.legalName.setSuffix((String)nameData.get(nameDataIndex++));
        }
        if (nameData.size() > nameDataIndex) {
            this.legalName.setPrefix((String)nameData.get(nameDataIndex++));
        }
        if (nameData.size() > nameDataIndex) {
            this.degree = (String)nameData.get(nameDataIndex++);
        }
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"dateOfBirth", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"gender", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"registryType", (String)parsedRow.getString(i++));
        this.commsFlag = parsedRow.getString(i++);
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append("ICN", (Object)this.ICN).append("legalName", (Object)this.legalName).append("dateOfBirth", (Object)this.dateOfBirth).append("gender", (Object)this.gender).append("registryType", (Object)this.registryType);
    }

    public Name getLegalName() {
        return this.legalName;
    }

    public void setLegalName(Name legalName) {
        this.legalName = legalName;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public String getICN() {
        return this.ICN;
    }

    public void setICN(String icn) {
        this.ICN = icn;
    }

    public boolean isPersonUpdate() {
        return StringUtils.isNotBlank((String)this.ICN);
    }

    public String getSSN() {
        return this.SSN;
    }

    public void setSSN(String ssn) {
        this.SSN = ssn;
    }

    public ImpreciseDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(ImpreciseDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public RegistryType getRegistryType() {
        return this.registryType;
    }

    public void setRegistryType(RegistryType registryType) {
        this.registryType = registryType;
    }

    public OrderedMap getRawFileData() throws Exception {
        ListOrderedMap map = new ListOrderedMap();
        map.put((Object)"header", (Object)"IDT");
        map.put((Object)"ICN", (Object)this.ICN);
        map.put((Object)"SSN", (Object)this.SSN);
        ArrayList<String> nameData = new ArrayList<String>();
        nameData.add(this.legalName != null ? StringUtils.trimToEmpty((String)this.legalName.getFamilyName()) : "");
        nameData.add(this.legalName != null ? StringUtils.trimToEmpty((String)this.legalName.getGivenName()) : "");
        nameData.add(this.legalName != null ? StringUtils.trimToEmpty((String)this.legalName.getMiddleName()) : "");
        nameData.add(this.legalName != null ? StringUtils.trimToEmpty((String)this.legalName.getSuffix()) : "");
        nameData.add(this.legalName != null ? StringUtils.trimToEmpty((String)this.legalName.getPrefix()) : "");
        nameData.add(StringUtils.isNotBlank((String)this.degree) ? this.degree : "");
        map.put((Object)"name", (Object)RawFileDataContainerUtils.formatMultipleValues(nameData, (String)"~"));
        map.put((Object)"dateOfBirth", (Object)this.dateOfBirth);
        map.put((Object)"gender", (Object)this.gender);
        map.put((Object)"registryType", (Object)this.registryType);
        map.put((Object)"commsFlag", (Object)this.commsFlag);
        return map;
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String degree) {
        this.degree = degree;
    }

    public String isCommsFlag() {
        return this.commsFlag;
    }

    public void setCommsFlag(String commsFlag) {
        this.commsFlag = commsFlag;
    }

    public boolean isCommsOnly() {
        return this.commsFlag != null && this.commsFlag.equals("1");
    }

    static {
        RawFileDataContainerUtils.autoRegisterConvertersForClass();
    }
}

