/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.batchprocess.datasync.HECLegacyCombatFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyCommunicationsFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyDemographicsFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyDependentFinancialFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyEligibilityFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyEnrollmentFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyFinancialAmountsFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyFinancialFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyIdentityFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyPOWFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyPurpleHeartFileData;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.Debt;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.RelationFinancials;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.ComMailingTriggerType;
import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.common.model.lookup.County;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EligibilityVerificationSource;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.EmergencyResponseIndicator;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.common.model.registry.RegistryTraitDetail;
import gov.va.med.esr.common.persistent.comms.CommsTemplateDAO;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.service.EGTService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.Reflector;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class HECLegacyDataSynchronizationConsumerMergeBuilder
extends AbstractComponent
implements Builder {
    private static final long serialVersionUID = 9049687444104381827L;
    private static final String SPECIAL_CASE_INCOME_YEAR = HECLegacyDataSynchronizationConsumerMergeBuilder.class.getName() + ".specialCaseIncomeYear";
    private static final String SPECIAL_CASE_ELIGIBILITY = HECLegacyDataSynchronizationConsumerMergeBuilder.class.getName() + ".specialCaseEligibility";
    private static final String SPECIAL_CASE_NEW_COMMS_ENTRIES = HECLegacyDataSynchronizationConsumerMergeBuilder.class.getName() + ".specialCaseNewCommsEntries";
    private static final String SPECIAL_CASE_HEC_ADDRESS = HECLegacyDataSynchronizationConsumerMergeBuilder.class.getName() + ".specialCaseHECAddress";
    private LookupService lookupService;
    private CommsLogService commsLogService;
    private CommsTemplateDAO commsTemplateDAO;
    private EGTService egtService;

    public Object build(Object input) throws BuilderException {
        Object[] args = (Object[])input;
        AbstractKeyedEntity onFileItem = (AbstractKeyedEntity)args[0];
        List acquiredData = (List)args[1];
        Boolean isCommsOnly = (Boolean)args[2];
        Iterator itr = acquiredData.iterator();
        HashMap specialCaseBookeeping = new HashMap();
        specialCaseBookeeping.put(SPECIAL_CASE_NEW_COMMS_ENTRIES, new ArrayList());
        try {
            while (itr.hasNext()) {
                Reflector.invoke((Object)((Object)this), (String)"overlayFileData", (Object[])new Object[]{onFileItem, itr.next(), specialCaseBookeeping});
            }
            if (onFileItem instanceof Person) {
                if (isCommsOnly == null || !isCommsOnly.booleanValue()) {
                    this.setEligibilitiesOnEnrollmentDetermination((Person)onFileItem, specialCaseBookeeping);
                }
                this.createNewCommsLogEntriesWithDemographicAddress((Person)onFileItem, specialCaseBookeeping, isCommsOnly);
            }
            return onFileItem;
        }
        catch (Exception e) {
            throw new BuilderException("Unable to overlay file data onto on-file Person", (Throwable)e);
        }
    }

    private void createNewCommsLogEntriesWithDemographicAddress(Person person, Map specialCaseBookeeping, Boolean isCommsOnly) throws Exception {
        Address address = null;
        List newCommsEntries = (List)specialCaseBookeeping.get(SPECIAL_CASE_NEW_COMMS_ENTRIES);
        if (newCommsEntries != null && !newCommsEntries.isEmpty()) {
            if (isCommsOnly != null && isCommsOnly.booleanValue()) {
                address = person.getPermanentAddress();
            } else {
                address = (Address)specialCaseBookeeping.get(SPECIAL_CASE_HEC_ADDRESS);
                if (address == null) {
                    return;
                }
            }
            Iterator itr = newCommsEntries.iterator();
            CommsLogEntry cle = null;
            while (itr.hasNext()) {
                cle = (CommsLogEntry)((Object)itr.next());
                cle.setAddress(address);
                this.commsLogService.insert(cle);
            }
        }
    }

    private void setEligibilitiesOnEnrollmentDetermination(Person person, Map specialCaseBookeeping) {
        EnrollmentDetermination ed = person.getEnrollmentDetermination();
        if (ed != null) {
            Eligibility elig2 = ed.getPrimaryEligibility();
            if (elig2 != null) {
                elig2.setEnrollmentDetermination(null);
            }
            ed.setPrimaryEligiblity(null);
            HashSet removeMe = new HashSet();
            Iterator itr = ed.getSecondaryEligibilities().iterator();
            while (itr.hasNext()) {
                removeMe.add(itr.next());
            }
            for (Eligibility elig2 : removeMe) {
                ed.removeSecondaryEligibility(elig2);
            }
            removeMe.clear();
            itr = ed.getOtherEligibilities().iterator();
            while (itr.hasNext()) {
                removeMe.add(itr.next());
            }
            itr = removeMe.iterator();
            while (itr.hasNext()) {
                elig2 = (Eligibility)itr.next();
                ed.removeOtherEligibility(elig2);
            }
            HECLegacyEligibilityFileData fileData = (HECLegacyEligibilityFileData)((Object)specialCaseBookeeping.get(SPECIAL_CASE_ELIGIBILITY));
            if (fileData != null) {
                Set eligs;
                EligibilityType type = fileData.getEligibilityCode();
                if (type != null) {
                    elig2 = new Eligibility();
                    elig2.setPrimary();
                    elig2.setType(type);
                    ed.setPrimaryEligiblity(elig2);
                }
                Iterator iterator = itr = (eligs = fileData.getOtherEligibilityCodes()) != null ? eligs.iterator() : null;
                while (itr != null && itr.hasNext()) {
                    type = (EligibilityType)((Object)itr.next());
                    elig2 = new Eligibility();
                    elig2.setSecondary();
                    elig2.setType(type);
                    ed.addSecondaryEligibility(elig2);
                }
            }
        }
    }

    public void overlayFileData(Registry registry, HECLegacyIdentityFileData fileData, Map specialCaseBookeeping) throws Exception {
    }

    public void overlayFileData(PrisonerOfWar registry, HECLegacyPOWFileData fileData, Map specialCaseBookeeping) throws Exception {
        RegistryTrait traits = registry.getRegistryTrait();
        if (traits == null) {
            traits = new RegistryTrait();
            registry.setRegistryTrait(traits);
        }
        traits.setFirstName(fileData.getLegalName().getGivenName());
        traits.setLastName(fileData.getLegalName().getFamilyName());
        traits.setMiddleName(fileData.getLegalName().getMiddleName());
        traits.setSuffix(fileData.getLegalName().getSuffix());
        traits.setSsn(fileData.getSSN());
        registry.removeAllEpisodes();
        Set episodes = registry.getEpisodes();
        Iterator itr = episodes != null ? episodes.iterator() : null;
        POWEpisode ep = null;
        boolean found = false;
        while (itr != null && itr.hasNext()) {
            ep = (POWEpisode)((Object)itr.next());
            if (!ep.getCaptureDate().equals((Object)fileData.getCaptureDate()) || !ep.getReleaseDate().equals((Object)fileData.getReleaseDate()) || !ep.getConfinementLocation().equals((Object)fileData.getConfinementLocation())) continue;
            found = true;
            ep.setCampLocation(fileData.getCasualtyPlace());
            ep.setDataSource(fileData.getSource());
            ep.setDateEntered(fileData.getEntered() != null ? fileData.getEntered().getDate() : null);
            ep.setNumberOfDaysInCaptivity(fileData.getDaysIncarcirated());
            break;
        }
        if (!found) {
            ep = new POWEpisode();
            ep.setCaptureDate(fileData.getCaptureDate());
            ep.setReleaseDate(fileData.getReleaseDate());
            ep.setConfinementLocation(fileData.getConfinementLocation());
            ep.setCampLocation(fileData.getCasualtyPlace());
            ep.setDataSource(fileData.getSource());
            ep.setDateEntered(fileData.getEntered() != null ? fileData.getEntered().getDate() : null);
            ep.setNumberOfDaysInCaptivity(fileData.getDaysIncarcirated());
            registry.addEpisode(ep);
        }
        registry.setUser(fileData.getUser());
        if (this.isTrue(fileData.getConfirmed())) {
            registry.setPowIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
        } else if (this.isFalse(fileData.getConfirmed())) {
            registry.setPowIndicator(this.getLookupService().getIndicatorByCode(Indicator.NO));
        }
        traits.removeAllRegistryTraitDetails();
        itr = fileData.getServiceNumbers().iterator();
        RegistryTraitDetail detail = null;
        while (itr.hasNext()) {
            detail = new RegistryTraitDetail();
            detail.setMilitaryServiceNumber((String)itr.next());
            traits.addRegistryTraitDetail(detail);
        }
    }

    public void overlayFileData(PurpleHeart registry, HECLegacyPurpleHeartFileData fileData, Map specialCaseBookeeping) throws Exception {
        RegistryTrait traits = registry.getRegistryTrait();
        if (traits == null) {
            traits = new RegistryTrait();
            registry.setRegistryTrait(traits);
        }
        traits.setFirstName(fileData.getLegalName().getGivenName());
        traits.setLastName(fileData.getLegalName().getFamilyName());
        traits.setMiddleName(fileData.getLegalName().getMiddleName());
        traits.setSuffix(fileData.getLegalName().getSuffix());
        traits.setPrefix(fileData.getLegalName().getPrefix());
        traits.setSsn(fileData.getSSN());
        traits.setEducationalDegree(fileData.getDegree());
        registry.setStatus(fileData.getStatus());
        registry.setStatusLastEditDate(fileData.getStatusUpdateDate() != null ? fileData.getStatusUpdateDate().getDate() : null);
        registry.setRejectionRemark(fileData.getRejectedRemarks());
        registry.setStatusLastUpdateUser(fileData.getUpdateUser());
        registry.setFacility(fileData.getSite());
        if (this.isTrue(fileData.getIndicator())) {
            registry.setPhIndicator(Boolean.TRUE);
        } else if (this.isFalse(fileData.getIndicator())) {
            registry.setPhIndicator(Boolean.FALSE);
        }
        registry.setAssignedContactUser(fileData.getContactRepAssigned());
        PurpleHeartDocument doc = new PurpleHeartDocument();
        doc.setDocumentType(fileData.getDocumentType());
        doc.setDataSource(fileData.getDataSource());
        doc.setReceivedDate(fileData.getDocReceivedDate() != null ? fileData.getDocReceivedDate().getDate() : null);
        doc.setLoginDate(fileData.getDocLoggedInDate() != null ? fileData.getDocLoggedInDate().getDate() : null);
        if (this.isTrue(fileData.getDocumentAcceptable())) {
            doc.setAcceptable(Boolean.TRUE);
        } else if (this.isFalse(fileData.getDocumentAcceptable())) {
            doc.setAcceptable(Boolean.FALSE);
        }
        doc.setUnacceptableRemarks(fileData.getUnacceptableRemarks());
        registry.addDocument(doc);
    }

    public void overlayFileData(Person person, HECLegacyIdentityFileData fileData, Map specialCaseBookeeping) throws Exception {
        person.setDegree(fileData.getDegree());
    }

    public void overlayFileData(Person person, HECLegacyCommunicationsFileData fileData, Map specialCaseBookeeping) throws Exception {
        block7: {
            List commsLogEntries;
            if (!fileData.getLetterForm().startsWith("742-")) {
                fileData.setLetterForm("742-" + fileData.getLetterForm());
            }
            Iterator itr = (commsLogEntries = this.commsLogService.findLogEntriesByPersonId(person.getEntityKey().getKeyValueAsString())) != null ? commsLogEntries.iterator() : null;
            CommsLogEntry logEntry = null;
            boolean found = false;
            CommsLogEntry latestOnFileForTheForm = null;
            while (itr != null && itr.hasNext()) {
                logEntry = (CommsLogEntry)((Object)itr.next());
                if (!logEntry.getFormNumber().equals(fileData.getLetterForm())) continue;
                found = true;
                String extractId = logEntry.getAacExtractNumber();
                if (commsLogEntries.size() == 1 || StringUtils.isNotBlank((String)extractId) && extractId.equals(fileData.getFileName())) {
                    this.updateCommsLogEntry(logEntry, fileData);
                    latestOnFileForTheForm = null;
                    break;
                }
                if (latestOnFileForTheForm != null && !logEntry.getModifiedOn().after(latestOnFileForTheForm.getModifiedOn())) continue;
                latestOnFileForTheForm = logEntry;
            }
            if (latestOnFileForTheForm != null) {
                this.updateCommsLogEntry(latestOnFileForTheForm, fileData);
            }
            if (!found) {
                try {
                    this.createNewCommsLogEntry(person, fileData, specialCaseBookeeping);
                }
                catch (Exception e) {
                    if (!this.logger.isWarnEnabled()) break block7;
                    this.logger.warn((Object)("Unable to create a new CommsLogEntry for letter form " + fileData.getLetterForm() + " - ignoring this entry"), (Throwable)e);
                }
            }
        }
    }

    private void updateCommsLogEntry(CommsLogEntry logEntry, HECLegacyCommunicationsFileData fileData) throws Exception {
        logEntry.addMailingStatus(this.lookupService.getComMailingStatusTypeByCode(fileData.getStatus()));
        logEntry.addActionComment(fileData.getActionMessage());
        if (StringUtils.isBlank((String)fileData.getRemail())) {
            logEntry.setRemailIndicator(null);
        } else if ("REMAILED".equals(fileData.getRemail())) {
            logEntry.setRemailIndicator("REMAILED");
        } else if ("RESEND".equals(fileData.getRemail())) {
            logEntry.setRemailIndicator("RESEND");
        }
        this.commsLogService.update(logEntry);
    }

    private CommsLogEntry createNewCommsLogEntry(Person person, HECLegacyCommunicationsFileData fileData, Map specialCaseBookeeping) throws Exception {
        CommsLogEntry cle = new CommsLogEntry();
        cle.setPersonId(new BigDecimal(person.getPersonEntityKey().getKeyValueAsString()));
        cle.setActionComment(fileData.getActionMessage());
        cle.setAacExtractNumber(fileData.getFileName());
        ComLetterTemplateType formNumber = this.lookupService.getComLetterTemplateTypeByCode(fileData.getLetterForm());
        cle.applyTemplate((CommsTemplate)this.commsTemplateDAO.findTemplateListByFormNumber(formNumber.getCode()).get(0));
        cle.setName(person.getLegalName());
        cle.setComMailingTriggerType(this.lookupService.getComMailingTriggerTypeByCode(ComMailingTriggerType.COM_MAILING_TRIGGER_AUTOMATIC.getCode()));
        if ("REMAILED".equals(fileData.getRemail())) {
            cle.setRemailIndicator("REMAILED");
        } else if ("RESEND".equals(fileData.getRemail())) {
            cle.setRemailIndicator("RESEND");
        }
        cle.addMailingStatus(this.lookupService.getComMailingStatusTypeByCode(fileData.getStatus()));
        List list = (List)specialCaseBookeeping.get(SPECIAL_CASE_NEW_COMMS_ENTRIES);
        list.add(cle);
        return cle;
    }

    public void overlayFileData(Person person, HECLegacyDemographicsFileData fileData, Map specialCaseBookeeping) throws Exception {
        Phone phone;
        person.setClaimFolderNumber(fileData.getClaimFolderNumber());
        person.setClaimFolderLocation(fileData.getClaimFolderLocation());
        DeathRecord dod = new DeathRecord();
        dod.setDeathDate(fileData.getDateOfDeath());
        dod.setFacilityReceived(fileData.getSiteReportingDeath());
        dod.setDataSource(fileData.getSourceOfDeathNotification());
        dod.setDeathReportDate(fileData.getDateOfDeathLastUpdated() != null ? fileData.getDateOfDeathLastUpdated().getDate() : null);
        person.setDeathRecord(dod);
        specialCaseBookeeping.put(SPECIAL_CASE_HEC_ADDRESS, fileData.getAddress());
        Address address = person.getPermanentAddress();
        if (address == null) {
            address = new Address();
            address.setType(this.lookupService.getAddressTypeByCode(AddressType.CODE_PERMANENT_ADDRESS.getCode()));
            person.addAddress(address);
        }
        address.setLine1(fileData.getAddress().getLine1());
        address.setLine2(fileData.getAddress().getLine2());
        address.setCity(fileData.getAddress().getCity());
        address.setState(fileData.getAddress().getState());
        address.setZipCode(fileData.getAddress().getZipCode());
        address.setZipPlus4(fileData.getAddress().getZipPlus4());
        this.setCountyName(fileData.getAddress(), address);
        address.setChangeDate(fileData.getAddress().getChangeDate());
        address.setChangeSource(fileData.getAddress().getChangeSource());
        address.setChangeSite(fileData.getAddress().getChangeSite());
        if (StringUtils.isNotBlank((String)fileData.getResidencePhone())) {
            phone = person.getHomePhone();
            if (phone == null) {
                phone = new Phone();
                phone.setType(this.lookupService.getPhoneTypeByCode(PhoneType.CODE_HOME.getCode()));
                person.addPhone(phone);
            }
            phone.setPhoneNumber(fileData.getResidencePhone());
        }
        if (StringUtils.isNotBlank((String)fileData.getWorkPhone())) {
            phone = person.getBusinessPhone();
            if (phone == null) {
                phone = new Phone();
                phone.setType(this.lookupService.getPhoneTypeByCode(PhoneType.CODE_BUSINESS.getCode()));
                person.addPhone(phone);
            }
            phone.setPhoneNumber(fileData.getWorkPhone());
        }
        if (this.isTrue(fileData.getSensitivityLevel())) {
            person.setSensitiveRecord(Boolean.TRUE);
        } else if (this.isFalse(fileData.getSensitivityLevel())) {
            person.setSensitiveRecord(Boolean.FALSE);
        }
    }

    private void setCountyName(Address incoming) {
        this.setCountyName(incoming, incoming);
    }

    private void setCountyName(Address incoming, Address address) {
        if (StringUtils.isNotBlank((String)incoming.getCounty()) && StringUtils.isNotBlank((String)incoming.getState())) {
            String combinedCode = incoming.getCounty() + incoming.getState();
            try {
                County county = this.lookupService.getCountyByCode(combinedCode);
                address.setCounty(county.getName());
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Unable to determine the county name from countyCode+stateCode combo [" + combinedCode + "], setting County to blank"), (Throwable)e);
                }
                address.setCounty("");
            }
        }
    }

    private boolean isTrue(String val) {
        return "1".equalsIgnoreCase(val) || "y".equalsIgnoreCase(val) || "true".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val);
    }

    private boolean isFalse(String val) {
        return "0".equalsIgnoreCase(val) || "n".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val) || "no".equalsIgnoreCase(val);
    }

    public void overlayFileData(Person person, HECLegacyCombatFileData fileData, Map specialCaseBookeeping) throws Exception {
        if (fileData.getConflictLocation() == null || fileData.getCombatFromDate() == null || fileData.getCombatToDate() == null) {
            return;
        }
        Set combats = person.getMilitaryService() != null ? person.getMilitaryService().getCombatEpisodes() : Collections.EMPTY_SET;
        Iterator itr = combats.iterator();
        CombatEpisode onFile = null;
        boolean found = false;
        while (itr.hasNext()) {
            onFile = (CombatEpisode)((Object)itr.next());
            if (!fileData.getConflictLocation().equals((Object)onFile.getConflictLocation()) || !fileData.getCombatFromDate().equals((Object)onFile.getStartDate()) || !fileData.getCombatToDate().equals((Object)onFile.getEndDate())) continue;
            found = true;
            if (this.isTrue(fileData.getHostileFireImminentDangerIndicator())) {
                onFile.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_HOSTILE_FIRE_IMMINENT_DANGER));
            } else if (this.isTrue(fileData.getCtzeIndicator())) {
                onFile.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
            }
            onFile.setOEFOIFSource(fileData.getDataSource());
            onFile.setOEFOIFStationNumber(fileData.getFacility());
            break;
        }
        if (!found) {
            CombatEpisode ep = new CombatEpisode();
            ep.setConflictLocation(fileData.getConflictLocation());
            ep.setStartDate(fileData.getCombatFromDate());
            ep.setEndDate(fileData.getCombatToDate());
            if (this.isTrue(fileData.getHostileFireImminentDangerIndicator())) {
                ep.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_HOSTILE_FIRE_IMMINENT_DANGER));
            } else if (this.isTrue(fileData.getCtzeIndicator())) {
                ep.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
            }
            ep.setOEFOIFSource(fileData.getDataSource());
            ep.setOEFOIFStationNumber(fileData.getFacility());
            if (person.getMilitaryService() != null) {
                person.getMilitaryService().addCombatEpisode(ep);
            } else {
                MilitaryService ms = new MilitaryService();
                person.setMilitaryService(ms);
                ms.addCombatEpisode(ep);
            }
        }
    }

    public void overlayFileData(Person person, HECLegacyEligibilityFileData fileData, Map specialCaseBookeeping) throws Exception {
        IncompetenceRuling ir;
        PrisonerOfWar pow;
        MedicaidFactor mf;
        EligibilityVerification eligVerif;
        if (fileData != null) {
            specialCaseBookeeping.put(SPECIAL_CASE_ELIGIBILITY, fileData);
        }
        if ((eligVerif = person.getEligibilityVerification()) == null) {
            eligVerif = new EligibilityVerification();
            person.setEligibilityVerification(eligVerif);
        }
        eligVerif.setEligibilityStatus(fileData.getEligibilityStatus());
        if (EligibilityStatus.CODE_VERIFIED.getCode().equals(fileData.getEligibilityStatus() != null ? fileData.getEligibilityStatus().getCode() : null)) {
            eligVerif.setVerificationSource(this.lookupService.getEligibilityVerificationSourceByCode(EligibilityVerificationSource.CODE_CEV.getCode()));
        }
        eligVerif.setEligibilityStatusDate(fileData.getEligibilityStatusDate());
        eligVerif.setVerificationMethod(fileData.getEligibilityVerificationMethod());
        Iterator itr = null;
        ServiceConnectionAward sc = null;
        if (this.isTrue(fileData.getServiceConnected())) {
            sc = new ServiceConnectionAward();
            sc.setServiceConnectedIndicator(Boolean.TRUE);
            person.setServiceConnectionAward(sc);
        } else if (this.isFalse(fileData.getServiceConnected())) {
            sc = new ServiceConnectionAward();
            sc.setServiceConnectedIndicator(Boolean.FALSE);
            person.setServiceConnectionAward(sc);
        }
        if (sc != null) {
            sc.setServiceConnectedPercentage(fileData.getServiceConnectedPercentage() != null ? new Integer(fileData.getServiceConnectedPercentage()) : null);
            if (this.isTrue(fileData.getUnemployable())) {
                sc.setUnemployable(Boolean.TRUE);
            } else if (this.isFalse(fileData.getUnemployable())) {
                sc.setUnemployable(Boolean.FALSE);
            }
            if (this.isTrue(fileData.getPAndT())) {
                sc.setPermanentAndTotal(Boolean.TRUE);
            } else if (this.isFalse(fileData.getPAndT())) {
                sc.setPermanentAndTotal(Boolean.FALSE);
            }
            sc.setPermanentAndTotalEffectiveDate(fileData.getPAndTEffectiveDate() != null ? fileData.getPAndTEffectiveDate().getDate() : null);
            sc.removeAllRatedDisability();
            itr = fileData.getRatedDisabilities().iterator();
            while (itr.hasNext()) {
                sc.addRatedDisability((RatedDisability)((Object)itr.next()));
            }
            sc.setCombinedServiceConnectedPercentageEffectiveDate(fileData.getCombinedSCPercentEffectiveDate());
        }
        MonetaryBenefitAward mba = new MonetaryBenefitAward();
        mba.setCheckAmount(fileData.getTotalAnnualVACheckAmount());
        person.setMonetaryBenefitAward(mba);
        MonetaryBenefit mb = null;
        if (this.isTrue(fileData.getReceivingVAPension())) {
            mb = new MonetaryBenefit();
            mb.setType(this.lookupService.getMonetaryBenefitTypeByCode(MonetaryBenefitType.CODE_VA_PENSION.getCode()));
            mb.setMonetaryBenefitIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
            mba.addMonetaryBenefit(mb);
        }
        if (this.isTrue(fileData.getReceivingAABenefits())) {
            mb = new MonetaryBenefit();
            mb.setType(this.lookupService.getMonetaryBenefitTypeByCode(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getCode()));
            mb.setMonetaryBenefitIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
            mba.addMonetaryBenefit(mb);
        }
        if (this.isTrue(fileData.getReceivingHouseholdBenefits())) {
            mb = new MonetaryBenefit();
            mb.setType(this.lookupService.getMonetaryBenefitTypeByCode(MonetaryBenefitType.CODE_HOUSEBOUND.getCode()));
            mb.setMonetaryBenefitIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
            mba.addMonetaryBenefit(mb);
        }
        if (this.isTrue(fileData.getReceivingVADisability())) {
            mb = new MonetaryBenefit();
            mb.setType(this.lookupService.getMonetaryBenefitTypeByCode(MonetaryBenefitType.CODE_DISABILITY_COMPENSATION.getCode()));
            mb.setMonetaryBenefitIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
            mba.addMonetaryBenefit(mb);
        }
        if (this.isTrue(fileData.getEligibleForMedicaid())) {
            mf = new MedicaidFactor();
            mf.setEligibleForMedicaid(Boolean.TRUE);
            person.setMedicaidFactor(mf);
        } else if (this.isFalse(fileData.getEligibleForMedicaid())) {
            mf = new MedicaidFactor();
            mf.setEligibleForMedicaid(Boolean.FALSE);
            person.setMedicaidFactor(mf);
        }
        MilitaryService ms = person.getMilitaryService();
        if (ms == null) {
            ms = new MilitaryService();
            person.setMilitaryService(ms);
        }
        if (this.isTrue(fileData.getDischargeDueToDisability())) {
            ms.setDischargeDueToDisability(Boolean.TRUE);
        } else if (this.isFalse(fileData.getDischargeDueToDisability())) {
            ms.setDischargeDueToDisability(Boolean.FALSE);
        }
        if (this.isTrue(fileData.getMilitaryDisabilityRetirement())) {
            ms.setDisabilityRetirementIndicator(Boolean.TRUE);
        } else if (this.isFalse(fileData.getMilitaryDisabilityRetirement())) {
            ms.setDisabilityRetirementIndicator(Boolean.FALSE);
        }
        if (this.isTrue(fileData.getPowStatusIndicated())) {
            pow = new PrisonerOfWar();
            pow.setPowIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
            person.setPrisonerOfWar(pow);
        } else if (this.isFalse(fileData.getPowStatusIndicated())) {
            pow = new PrisonerOfWar();
            pow.setPowIndicator(this.getLookupService().getIndicatorByCode(Indicator.NO));
            person.setPrisonerOfWar(pow);
        }
        if (this.isTrue(fileData.getRatedIncompetent())) {
            ir = new IncompetenceRuling();
            ir.setIncompetent(Boolean.TRUE);
            person.setIncompetenceRuling(ir);
        } else if (this.isFalse(fileData.getRatedIncompetent())) {
            ir = new IncompetenceRuling();
            ir.setIncompetent(Boolean.FALSE);
            person.setIncompetenceRuling(ir);
        }
        IneligibilityFactor ifact = new IneligibilityFactor();
        ifact.setIneligibleDate(fileData.getIneligibleDate() != null ? fileData.getIneligibleDate().getDate() : null);
        ifact.setReason(fileData.getIneligibleReason());
        ifact.setVaroDecision(fileData.getIneligibleVaroDecision());
        person.setIneligibilityFactor(ifact);
        AgentOrangeExposure factor1 = person.getAgentOrangeExposure();
        if (this.isTrue(fileData.getExposedToAgentOrange())) {
            if (factor1 == null) {
                factor1 = new AgentOrangeExposure();
                person.addSpecialFactor(factor1);
            }
            factor1.setSpecialFactorIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
            factor1.setLocation(fileData.getAgentOrangeExposureLocation());
        } else if (factor1 != null) {
            person.removeSpecialFactor(factor1);
        }
        RadiationExposure factor2 = person.getRadiationExposure();
        if (this.isTrue(fileData.getRadiationExposureIndicator())) {
            if (factor2 == null) {
                factor2 = new RadiationExposure();
                person.addSpecialFactor(factor2);
            }
            factor2.setSpecialFactorIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
            factor2.setExposureMethod(fileData.getRadiationExposureMethod());
        } else if (factor2 != null) {
            person.removeSpecialFactor(factor2);
        }
        EnvironmentalContaminationExposure factor3 = new EnvironmentalContaminationExposure();
        if (this.isTrue(fileData.getEnvironmentalContaminants()) && person.getEnvironmentalContaminationExposure() == null) {
            factor3.setSpecialFactorIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
            person.addSpecialFactor(factor3);
        } else if (factor3 != null) {
            person.removeSpecialFactor(factor3);
        }
        Set onFiles = person.getEmergencyResponseIndicators();
        itr = onFiles != null ? onFiles.iterator() : null;
        EmergencyResponseIndicator emer = null;
        if (fileData.getEmergencyResponse() == null) {
            while (itr != null && itr.hasNext()) {
                emer = (EmergencyResponseIndicator)((Object)itr.next());
                person.removeEmergencyResponseIndicator(emer);
            }
        }
        if (fileData.getEmergencyResponse() != null) {
            boolean found = false;
            while (itr != null && itr.hasNext()) {
                emer = (EmergencyResponseIndicator)((Object)itr.next());
                if (!emer.getEmergencyResponse().equals((Object)fileData.getEmergencyResponse())) continue;
                found = true;
                break;
            }
            if (!found) {
                emer = new EmergencyResponseIndicator();
                emer.setEmergencyResponse(fileData.getEmergencyResponse());
                person.addEmergencyResponseIndicator(emer);
            }
        }
        if (this.isTrue(fileData.getVeteranIndicator())) {
            person.setVeteran(Boolean.TRUE);
        } else if (this.isFalse(fileData.getVeteranIndicator())) {
            person.setVeteran(Boolean.FALSE);
        }
    }

    public void overlayFileData(Person person, HECLegacyEnrollmentFileData fileData, Map specialCaseBookeeping) throws Exception {
        EnrollmentOverride eo;
        EGTSetting egt;
        EnrollmentDetermination ed = person.getEnrollmentDetermination();
        if (ed == null) {
            ed = new EnrollmentDetermination();
            person.setEnrollmentDetermination(ed);
        }
        Date effDateOfChange = fileData.getEffectiveDateOfChange() != null ? fileData.getEffectiveDateOfChange().getDate() : null;
        ed.setEffectiveDate(effDateOfChange);
        ed.setCalculationSource(fileData.getEnrollmentSource());
        if (fileData.getEnrollmentStatus() != null) {
            ed.setEnrollmentStatus(fileData.getEnrollmentStatus());
            ed.getEnrollmentStatus().setEnrollmentCategory(fileData.getEnrollmentCategory());
        }
        ed.setPriorityGroup(fileData.getEnrollmentPriorityGroup());
        ed.setPrioritySubGroup(fileData.getEnrollmentPrioritySubgroup());
        ed.setEnrollmentDate(fileData.getEnrollmentDate() != null ? fileData.getEnrollmentDate().getDate() : null);
        ed.setEndDate(fileData.getEnrollmentEndDate() != null ? fileData.getEnrollmentEndDate().getDate() : null);
        person.setMostRecentPreferredFacility(fileData.getPreferredFacility());
        if (fileData.getEgtSetting().getEffectiveDate() != null) {
            egt = this.egtService.getActiveEGTSetting(fileData.getEgtSetting().getEffectiveDate());
            if (egt == null) {
                throw new IllegalStateException("ESR is unable to find an EGT Setting that was valid for date: " + fileData.getEgtSetting().getEffectiveDate());
            }
        } else {
            throw new IllegalStateException("ESR can not create an EnrollmentDetermination because the file does not contain an EGTSetting effectiveDate");
        }
        ed.setEgtSetting(egt);
        Application app = new Application();
        app.setApplicationDate(fileData.getApplicationDate() != null ? fileData.getApplicationDate().getDate() : null);
        person.setApplication(app);
        if (this.isTrue(fileData.getEnrollmentStatusOverride())) {
            eo = new EnrollmentOverride();
            eo.setOverride(Boolean.TRUE);
            person.setEnrollmentOverride(eo);
        } else if (this.isFalse(fileData.getEnrollmentStatusOverride())) {
            eo = new EnrollmentOverride();
            eo.setOverride(Boolean.FALSE);
            person.setEnrollmentOverride(eo);
        }
        CancelDecline cd = new CancelDecline();
        cd.setReason(fileData.getCancelDeclineReason());
        cd.setRemarks(fileData.getCancelDeclineRemarks());
        cd.setEffectiveDate(effDateOfChange);
        if (fileData.getCancelDeclineReason() != null && EnrollmentStatus.CODE_CANCELLED_DECLINED.getCode().equals(fileData.getEnrollmentStatus() != null ? fileData.getEnrollmentStatus().getCode() : null)) {
            cd.setCancelDeclineIndicator(Boolean.TRUE);
        } else {
            cd.setCancelDeclineIndicator(Boolean.FALSE);
        }
        person.setCancelDecline(cd);
    }

    public void overlayFileData(Person person, HECLegacyDependentFinancialFileData fileData, Map specialCaseBookeeping) throws Exception {
        boolean incomingDependentSSNIsPseudo;
        Integer incomeYear = (Integer)specialCaseBookeeping.get(SPECIAL_CASE_INCOME_YEAR);
        if (incomeYear == null) {
            throw new IllegalStateException("Unable to determine IncomeYear for DependentFinancial data");
        }
        FinancialStatement primary = person.getFinancialStatement(incomeYear);
        Relation human = null;
        RelationFinancials relationFin = null;
        if (Relationship.CODE_SPOUSE.getCode().equals(fileData.getRelationship() != null ? fileData.getRelationship().getCode() : null)) {
            SpouseFinancials spouse = new SpouseFinancials();
            relationFin = spouse;
            primary.addSpouseFinancials(spouse);
            Spouse humanSpouse = new Spouse();
            human = humanSpouse;
            spouse.setReportedOn(humanSpouse);
            humanSpouse.setMaidenName(fileData.getMaidenName());
            if (fileData.getAmountContributedToSpouse() != null) {
                primary.setContributionToSpouse(fileData.getAmountContributedToSpouse());
            }
        } else {
            DependentFinancials dep = new DependentFinancials();
            relationFin = dep;
            primary.addDependentFinancials(dep);
            Dependent humanDep = new Dependent();
            human = humanDep;
            dep.setReportedOn(humanDep);
            if (this.isTrue(fileData.getIncapableOfSelfSupport())) {
                dep.setIncapableOfSelfSupport(Boolean.TRUE);
            } else if (this.isFalse(fileData.getIncapableOfSelfSupport())) {
                dep.setIncapableOfSelfSupport(Boolean.FALSE);
            }
            if (this.isTrue(fileData.getContributedToSupport())) {
                dep.setContributedToSupport(Boolean.TRUE);
            } else if (this.isFalse(fileData.getContributedToSupport())) {
                dep.setContributedToSupport(Boolean.FALSE);
            }
            if (this.isTrue(fileData.getChildHadIncome())) {
                dep.setHasIncome(Boolean.TRUE);
            } else if (this.isFalse(fileData.getChildHadIncome())) {
                dep.setHasIncome(Boolean.FALSE);
            }
            if (this.isTrue(fileData.getIncomeAvailable())) {
                dep.setIncomeAvailableToPatient(Boolean.TRUE);
            } else if (this.isFalse(fileData.getIncomeAvailable())) {
                dep.setIncomeAvailableToPatient(Boolean.FALSE);
            }
        }
        human.setName(fileData.getName());
        human.setGender(fileData.getGender());
        human.setDob(fileData.getDateOfBirth());
        boolean bl = incomingDependentSSNIsPseudo = fileData.getPseudoSSNReason() != null;
        if (StringUtils.isNotBlank((String)fileData.getSSN())) {
            SSN ssn = new SSN();
            ssn.setSsnText(fileData.getSSN());
            if (!incomingDependentSSNIsPseudo) {
                ssn.setType(this.getLookupService().getSSNTypeByCode(SSNType.CODE_ACTIVE.getCode()));
            } else {
                ssn.setType(this.getLookupService().getSSNTypeByCode(SSNType.CODE_PSEUDO.getCode()));
                ssn.setPseudoSSNReason(fileData.getPseudoSSNReason());
            }
            ssn.setSsaVerificationStatus(this.getLookupService().getSSAVerificationStatusByCode(SSAVerificationStatus.NEW_RECORD.getCode()));
            human.addSsn(ssn);
        }
        human.setRelationship(fileData.getRelationship());
        human.setStartDate(fileData.getEffectiveDate());
        if (this.isTrue(fileData.getLivedWithPatient())) {
            relationFin.setLivedWithPatient(Boolean.TRUE);
        } else if (this.isFalse(fileData.getLivedWithPatient())) {
            relationFin.setLivedWithPatient(Boolean.FALSE);
        }
        this.updateFinancialAmounts(relationFin, fileData.getFinancialAmounts());
    }

    private void updateFinancialAmounts(FinancialInformation fin, HECLegacyFinancialAmountsFileData amounts) throws Exception {
        Income income = null;
        if (amounts.getSocialSecurityNotSSIAmount() != null) {
            income = new Income();
            income.setAmount(amounts.getSocialSecurityNotSSIAmount());
            fin.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getCode()), income);
        }
        if (amounts.getUSCivilService() != null) {
            income = new Income();
            income.setAmount(amounts.getUSCivilService());
            fin.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_CIVIL_SERVICE.getCode()), income);
        }
        if (amounts.getUSRailroadRetirement() != null) {
            income = new Income();
            income.setAmount(amounts.getUSRailroadRetirement());
            fin.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getCode()), income);
        }
        if (amounts.getMilitaryRetirement() != null) {
            income = new Income();
            income.setAmount(amounts.getMilitaryRetirement());
            fin.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getCode()), income);
        }
        if (amounts.getUnemploymentCompensation() != null) {
            income = new Income();
            income.setAmount(amounts.getUnemploymentCompensation());
            fin.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getCode()), income);
        }
        if (amounts.getOtherRetirement() != null) {
            income = new Income();
            income.setAmount(amounts.getOtherRetirement());
            fin.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getCode()), income);
        }
        if (amounts.getTotalIncomeFromEmployment() != null) {
            income = new Income();
            income.setAmount(amounts.getTotalIncomeFromEmployment());
            fin.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getCode()), income);
        }
        if (amounts.getInterestDividendAnnuity() != null) {
            income = new Income();
            income.setAmount(amounts.getInterestDividendAnnuity());
            fin.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY.getCode()), income);
        }
        if (amounts.getWorkersCompBlackLung() != null) {
            income = new Income();
            income.setAmount(amounts.getWorkersCompBlackLung());
            fin.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getCode()), income);
        }
        if (amounts.getAllOtherIncome() != null) {
            income = new Income();
            income.setAmount(amounts.getAllOtherIncome());
            fin.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getCode()), income);
        }
        Expense expense = null;
        if (amounts.getMedicalExpenses() != null) {
            expense = new Expense();
            expense.setAmount(amounts.getMedicalExpenses());
            fin.setExpense(this.lookupService.getExpenseTypeByCode(ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL.getCode()), expense);
        }
        if (amounts.getFuneralAndBurialExpenses() != null) {
            expense = new Expense();
            expense.setAmount(amounts.getFuneralAndBurialExpenses());
            fin.setExpense(this.lookupService.getExpenseTypeByCode(ExpenseType.EXPENSE_TYPE_FUNERAL_AND_BURIAL.getCode()), expense);
        }
        if (amounts.getEducationExpenses() != null) {
            expense = new Expense();
            expense.setAmount(amounts.getEducationExpenses());
            String educationCode = ExpenseType.EXPENSE_TYPE_COLLEGE_AND_VOCATION.getCode();
            if (fin instanceof RelationFinancials) {
                educationCode = ExpenseType.EXPENSE_TYPE_EDUCATIONAL_EXPENSES_BY_DEPENDENT.getCode();
            }
            fin.setExpense(this.lookupService.getExpenseTypeByCode(educationCode), expense);
        }
        Asset asset = null;
        if (amounts.getCashInBank() != null) {
            asset = new Asset();
            asset.setAmount(amounts.getCashInBank());
            fin.setAsset(this.lookupService.getAssetTypeByCode(AssetType.CODE_CASH.getCode()), asset);
        }
        if (amounts.getStocksAndBonds() != null) {
            asset = new Asset();
            asset.setAmount(amounts.getStocksAndBonds());
            fin.setAsset(this.lookupService.getAssetTypeByCode(AssetType.CODE_STOCKS_AND_BONDS.getCode()), asset);
        }
        if (amounts.getRealProperty() != null) {
            asset = new Asset();
            asset.setAmount(amounts.getRealProperty());
            fin.setAsset(this.lookupService.getAssetTypeByCode(AssetType.CODE_REAL_ESTATE.getCode()), asset);
        }
        if (amounts.getOtherPropertyAndAssets() != null) {
            asset = new Asset();
            asset.setAmount(amounts.getOtherPropertyAndAssets());
            fin.setAsset(this.lookupService.getAssetTypeByCode(AssetType.CODE_OTHER.getCode()), asset);
        }
        Debt debt = null;
        if (amounts.getDebts() != null) {
            debt = new Debt();
            debt.setAmount(amounts.getDebts());
            fin.setDebt(debt);
        }
    }

    public void overlayFileData(Person person, HECLegacyFinancialFileData fileData, Map specialCaseBookeeping) throws Exception {
        specialCaseBookeeping.put(SPECIAL_CASE_INCOME_YEAR, fileData.getIncomeYear());
        FinancialStatement fin = new FinancialStatement();
        fin.setIsPost2005Format(Boolean.FALSE);
        fin.setIncomeYear(fileData.getIncomeYear());
        person.setFinancialStatement(fileData.getIncomeYear(), fin);
        this.updateFinancialAmounts(fin, fileData.getFinancialAmounts());
        if (this.isTrue(fileData.getRanchFarmOwner())) {
            Income income = new Income();
            fin.setIncome(this.lookupService.getIncomeTypeByCode(IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getCode()), income);
        }
        fin.setContributionToSpouse(fileData.getAmountContributedToSpouse());
        if (this.isTrue(fileData.getMarriedLastCalendarYear())) {
            fin.setMarriedLastCalendarYear(Boolean.TRUE);
        } else if (this.isFalse(fileData.getMarriedLastCalendarYear())) {
            fin.setMarriedLastCalendarYear(Boolean.FALSE);
        }
        fin.setNumberOfDependentChildren(fileData.getNumberOfDependentChildren());
        IncomeTest meansTest = null;
        IncomeTest copayTest = null;
        if (fileData.getMeansTestDate() != null || fileData.getMeansTestStatus() != null || fileData.getMeansTestDeterminedStatus() != null || fileData.getMeansTestAdjudicationDate() != null || fileData.getMeansTestCompletedDate() != null || fileData.getSiteConductingMeansTest() != null) {
            meansTest = new IncomeTest();
            meansTest.setType(this.lookupService.getIncomeTestTypeByCode(IncomeTestType.CODE_MEANS_TEST.getCode()));
            meansTest.setEffectiveDate(fileData.getMeansTestDate() != null ? fileData.getMeansTestDate().getDate() : null);
            meansTest.setAdjudicationDate(fileData.getMeansTestAdjudicationDate() != null ? fileData.getMeansTestAdjudicationDate().getDate() : null);
            meansTest.setSiteConductingTest(fileData.getSiteConductingMeansTest());
            meansTest.setIncomeTestStatus(this.lookupService.getIncomeTestTypeByCode(IncomeTestType.CODE_MEANS_TEST.getCode()), fileData.getMeansTestStatus(), fileData.getMeansTestDeterminedStatus());
            meansTest.setCompletedDate(fileData.getMeansTestCompletedDate() != null ? fileData.getMeansTestCompletedDate().getDate() : null);
            meansTest.setSource(fileData.getSourceOfPrimaryIncomeTest());
            meansTest.setLastEditedDate(fileData.getTestLastEditedDate() != null ? fileData.getTestLastEditedDate().getDate() : null);
        }
        if (fileData.getCopayTestDate() != null || fileData.getCopayTestStatus() != null || fileData.getCopayTestDeterminedStatus() != null || fileData.getCopayTestAdjudicationDate() != null || fileData.getCopayTestCompletedDate() != null) {
            copayTest = new IncomeTest();
            copayTest.setType(this.lookupService.getIncomeTestTypeByCode(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()));
            copayTest.setEffectiveDate(fileData.getCopayTestDate() != null ? fileData.getCopayTestDate().getDate() : null);
            copayTest.setAdjudicationDate(fileData.getCopayTestAdjudicationDate() != null ? fileData.getCopayTestAdjudicationDate().getDate() : null);
            copayTest.setSiteConductingTest(fileData.getSiteConductingMeansTest());
            copayTest.setIncomeTestStatus(this.lookupService.getIncomeTestTypeByCode(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()), fileData.getCopayTestStatus(), fileData.getCopayTestDeterminedStatus());
            copayTest.setCompletedDate(fileData.getCopayTestCompletedDate() != null ? fileData.getCopayTestCompletedDate().getDate() : null);
            copayTest.setSource(fileData.getSourceOfPrimaryIncomeTest());
            copayTest.setLastEditedDate(fileData.getTestLastEditedDate() != null ? fileData.getTestLastEditedDate().getDate() : null);
            if (meansTest != null) {
                IncomeTestStatus its = copayTest.getIncomeTestStatus();
                its.setIncomeTest(null);
                meansTest.addIncomeTestStatus(its);
            }
        }
        if (meansTest != null) {
            this.populateIncomeTest(meansTest, person, fileData);
        } else {
            this.populateIncomeTest(copayTest, person, fileData);
        }
        if (meansTest != null) {
            meansTest.setPrimaryIncomeTest(Boolean.TRUE);
        } else if (copayTest != null) {
            copayTest.setPrimaryIncomeTest(Boolean.TRUE);
        }
        if (fileData.getGuardianType() != null) {
            Association assoc = Association.getAssociationOfType(person.getAssociations(), fileData.getGuardianType().getCode());
            if (assoc == null) {
                assoc = new Association();
                assoc.setType(fileData.getGuardianType());
                person.addAssociation(assoc);
            }
            assoc.setRepresentativeName(fileData.getGuardianName());
            assoc.setOrganizationName(fileData.getGuardianInstitution());
            this.setCountyName(fileData.getGuardianAddress());
            assoc.setAddress(fileData.getGuardianAddress());
            assoc.setPrimaryPhone(fileData.getGuardianPhone());
            assoc.setRelationship(fileData.getGuardianRelationship());
        }
        if (fileData.getIncompetentCivilRulingDate() != null || fileData.getIncompetentVARulingDate() != null) {
            IncompetenceRuling ruling = new IncompetenceRuling();
            ruling.setCivilRulingDate(fileData.getIncompetentCivilRulingDate());
            ruling.setVaRulingDate(fileData.getIncompetentVARulingDate());
            person.setIncompetenceRuling(ruling);
        }
    }

    private void populateIncomeTest(IncomeTest test, Person person, HECLegacyFinancialFileData fileData) {
        if (test != null) {
            test.setNetWorth(fileData.getNetWorth());
            test.setTotalIncome(fileData.getTotalIncome());
            test.setThresholdA(fileData.getThresholdA());
            test.setTotalNumberOfDependents(fileData.getTotalDependents());
            if (this.isTrue(fileData.getAgreedToPayDeductible())) {
                test.setAgreesToPayDeductible(Boolean.TRUE);
            } else if (this.isFalse(fileData.getAgreedToPayDeductible())) {
                test.setAgreesToPayDeductible(Boolean.FALSE);
            }
            if (this.isTrue(fileData.getDeclinesToGiveIncomeInfo())) {
                test.setDiscloseFinancialInformation(Boolean.TRUE);
            } else if (this.isFalse(fileData.getDeclinesToGiveIncomeInfo())) {
                test.setDiscloseFinancialInformation(Boolean.FALSE);
            }
            test.setGmtThresholdAmount(fileData.getGMTThreshold());
            this.setCountyName(fileData.getGMTAddress());
            test.setGmtAddress(fileData.getGMTAddress());
            test.setIncomeYear(fileData.getIncomeYear());
            person.setIncomeTest(fileData.getIncomeYear(), test);
        }
    }

    public void overlayFileData(Person person, HECLegacyPOWFileData fileData, Map specialCaseBookeeping) throws Exception {
        PrisonerOfWar pow = person.getPrisonerOfWar();
        if (pow == null) {
            pow = new PrisonerOfWar();
            person.setPrisonerOfWar(pow);
        }
        this.overlayFileData(pow, fileData, specialCaseBookeeping);
    }

    public void overlayFileData(Person person, HECLegacyPurpleHeartFileData fileData, Map specialCaseBookeeping) throws Exception {
        PurpleHeart ph = person.getPurpleHeart();
        if (ph == null) {
            ph = new PurpleHeart();
            person.addDecoration(ph);
        }
        this.overlayFileData(ph, fileData, specialCaseBookeeping);
    }

    public void afterPropertiesSet() {
        Validate.notNull((Object)this.lookupService);
        Validate.notNull((Object)this.commsLogService);
        Validate.notNull((Object)this.egtService);
        Validate.notNull((Object)this.commsTemplateDAO);
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public CommsLogService getCommsLogService() {
        return this.commsLogService;
    }

    public void setCommsLogService(CommsLogService commsLogService) {
        this.commsLogService = commsLogService;
    }

    public EGTService getEgtService() {
        return this.egtService;
    }

    public void setEgtService(EGTService egtService) {
        this.egtService = egtService;
    }

    public CommsTemplateDAO getCommsTemplateDAO() {
        return this.commsTemplateDAO;
    }

    public void setCommsTemplateDAO(CommsTemplateDAO commsTemplateDAO) {
        this.commsTemplateDAO = commsTemplateDAO;
    }
}

