/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.VPIDFileData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import java.util.List;

public class SendingZ11MessagesProcess
extends AbstractDataFileIncrementalProcess {
    private TriggerRouter triggerRouter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataRecords(DataFileProcessExecutionContext context, List beans) {
        if (this.logger.isDebugEnabled()) {
            int listSize = 0;
            if (beans != null) {
                listSize = beans.size();
            }
            this.logger.error((Object)("Processing VPID  " + listSize));
        }
        for (int i = 0; beans != null && i < beans.size(); ++i) {
            VPIDFileData dataRecord = (VPIDFileData)((Object)beans.get(i));
            try {
                VPIDEntityKey vpidEntityKey = CommonEntityKeyFactory.createVPIDEntityKey(dataRecord.getVpid());
                if (this.logger.isDebugEnabled()) {
                    this.logger.error((Object)("Processing VPID  " + dataRecord.getVpid()));
                }
                this.getTriggerRouter().processTriggerEvent(this.getTriggerEvent(vpidEntityKey));
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                continue;
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Error adding PSIM Correlation for VPID " + dataRecord.getVpid()), (Throwable)e);
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
            finally {
                if (this.shouldUpdateJobResult(context)) {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
                if (this.isInterrupted(context)) break;
            }
        }
    }

    private TriggerEvent getTriggerEvent(PersonEntityKey key) {
        PersonTriggerEvent triggerEvent = new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.ELIGIBILITY);
        triggerEvent.setPersonId(key);
        return triggerEvent;
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }
}

