/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.service.trigger.EGTTriggerEvent;
import gov.va.med.fw.batchprocess.AbstractDataQueryProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import java.util.List;
import org.apache.commons.lang.Validate;

public class SendMfnZegProcess
extends AbstractDataQueryProcess {
    private TriggerRouter triggerRouter = null;

    protected void processData(DataProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Send MFN~ZEG batch process: Query result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null || acquiredData.size() == 0) {
            return;
        }
        EGTSetting egt = (EGTSetting)((Object)acquiredData.get(0));
        EGTTriggerEvent egtTriggerEvent = new EGTTriggerEvent(egt);
        try {
            this.triggerRouter.processTriggerEvent((TriggerEvent)egtTriggerEvent);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Send MFN~ZEG batch process: MFN message triggered.");
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error triggering MFN message. Reason: " + ex);
        }
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.triggerRouter, (String)"A TriggerRouter is needed");
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }
}

