/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.service.IRSTransmissionService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import java.util.List;

public class RequestIRSAcknowledgmentsProcess
extends AbstractDataQueryIncrementalProcess {
    private static final int DEFAULT_JOB_RESULT_UPDATE_INTERVAL = 100;
    private SystemParameterService systemParameterService = null;
    private static final String IRS_ACK_PERIOD = "IRS Ack Period";
    private String ackPeriod;
    private IRSTransmissionService irsTransmissionService = null;

    protected void executeProcess(DataProcessExecutionContext context) throws Exception {
        this.ackPeriod = this.getSystemParameterService().getByName(IRS_ACK_PERIOD).getValue();
        int hours = Integer.valueOf(this.ackPeriod);
        this.setParamNames(new String[]{"ackHours"});
        this.setParamValues(new Integer[]{hours});
        super.executeProcess(context);
    }

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (acquiredData == null) {
            return;
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            String receiptId;
            if (acquiredData.get(i) == null || acquiredData.get(i).toString().isEmpty() || (receiptId = acquiredData.get(i).toString()) == null || receiptId.length() <= 0) continue;
            try {
                this.getIrsTransmissionService().requestAcknowledgment(receiptId);
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                continue;
            }
            catch (ServiceException e) {
                this.logger.error((Object)("Error in IRS acknowledgmeent process:" + (Object)((Object)e)));
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
        }
    }

    protected boolean shouldUpdateJobResult(DataQueryProcessExecutionContext context) {
        return context.getProcessStatistics().isTotalNumberMod(100);
    }

    public SystemParameterService getSystemParameterService() {
        return this.systemParameterService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }

    public IRSTransmissionService getIrsTransmissionService() {
        return this.irsTransmissionService;
    }

    public void setIrsTransmissionService(IRSTransmissionService irsTransmissionService) {
        this.irsTransmissionService = irsTransmissionService;
    }
}

