/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.SignatureFileData;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.FinancialsService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class ReceiveSignatureInformationFileProcess
extends AbstractDataFileSingleRowIncrementProcess {
    private static String DELIMITER = "^";
    private PersonService personService;
    private FinancialsService financialsService;

    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        boolean success;
        block4: {
            SignatureFileData dataRecord = (SignatureFileData)bean;
            success = true;
            try {
                Person person = this.matchPerson(dataRecord);
                if (person != null) {
                    person.addSignatureImage(dataRecord.getSignatureImage());
                    this.financialsService.processPersonSignature(person);
                } else {
                    success = false;
                }
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error((Object)"There was an exception trying to apply/persist the Signature information.  It is logged here for triage but, per requirements, this will not go into the exception file.", (Throwable)e);
            }
        }
        return success;
    }

    protected Object createExceptionObject(String rawData) {
        return StringUtils.substringBeforeLast((String)rawData, (String)DELIMITER);
    }

    private Person matchPerson(SignatureFileData data) {
        Person person;
        block3: {
            PersonIdentityTraits traits = new PersonIdentityTraits();
            traits.setSsn(data.getSSNWrapper());
            person = null;
            try {
                person = this.personService.find(traits);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error((Object)"Unable to find (exact match) Person for SignatureImage ssn: ", (Throwable)e);
            }
        }
        if (person != null && this.logger.isInfoEnabled()) {
            this.logger.info((Object)("VPID [" + person.getVPIDEntityKey().getVPID() + "] found"));
        }
        return person;
    }

    public FinancialsService getFinancialsService() {
        return this.financialsService;
    }

    public void setFinancialsService(FinancialsService financialsService) {
        this.financialsService = financialsService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personService, (String)"A PersonService is needed");
        Validate.notNull((Object)this.financialsService, (String)"A FinancialsService is needed");
    }
}

