/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.transaction.TransactionTimestampManager;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Query;
import org.hibernate.Session;

public class ProcessClosedMSDSWorkListItems
extends AbstractDataQueryIncrementalProcess {
    private static final String PARAM_CASEID = "caseId";
    private static final String DELETE_WORKCASEASSIGNMENT = "processClosedMSDSWorkListItems.deleteWorkcaseAssignment";
    private static final String DELETE_WORKCASECOMMENTS = "processClosedMSDSWorkListItems.deleteWorkcaseComments";
    private static final String DELETE_WORKCASESTATUS = "processClosedMSDSWorkListItems.deleteWorkcaseStatusDetails";
    private static final String DELETE_WORKCASEMESSAGING = "processClosedMSDSWorkListItems.deleteWorkcaseMessaging";
    private static final String DELETE_WORKCASE = "processClosedMSDSWorkListItems.deleteWorkcase";
    public static final String[] msds_exception_rules = new String[]{"An update of military service information was received and processed, for a guard/reservists, however, the activation termination reason could not be determined. Investigation is required.", "Character of Discharge is Unknown per VADIR", "Character of Discharge is Unknown per WebHINQ", "A Military Service Message was received, Person Not Found in VADIR and BIRLS", "A Military Service Message was received No Military Service Information Found in  VADIR or BIRLS", "A Military Service Message was received Success from One Data Source but Not Found in Other", "A Military Service Message was received and processed but does not pass data validation checks", "An update of military service information was received and processed, for a guard/reservists, however, the activation termination reason could not be determined. Investigation is required.", "An update of military service information was received and processed; however, the Character of Discharge could not be determined. Investigation is required.", "An update of military service information was received and processed; however, the Character of Discharge could\tnot be determined. Investigation is required."};
    private static Set<String> exceptionSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    LookupService lookupService;
    TransactionTimestampManager timestampManager;

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Process Closed MSDS Worklist Items: Query increment result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        WkfCaseStatusType closedStatusType = null;
        try {
            closedStatusType = this.getLookupService().getWkfCaseStatusTypeByCode(WkfCaseStatusType.CLOSED.getName());
        }
        catch (ServiceException ex) {
            String errMsg = "Error in lookup workcase status type CLOSED!";
            context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
            }
            return;
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            block16: {
                Object[] row = (Object[])acquiredData.get(i);
                BigDecimal wkfCaseId = (BigDecimal)row[0];
                BigDecimal wkfStatusId = (BigDecimal)row[1];
                String errorText = (String)row[2];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing Closed Workflow Case # " + (i + 1) + " with id = " + wkfCaseId));
                }
                try {
                    if (this.isWorkItemMeetsOneofMSDSExceptionRules(errorText)) {
                        HashMap<String, BigDecimal> contextData = new HashMap<String, BigDecimal>();
                        contextData.put(PARAM_CASEID, wkfCaseId);
                        AbstractDAOAction callback1 = new AbstractDAOAction(contextData){

                            public Object execute(Session session) {
                                Query query = session.getNamedQuery(ProcessClosedMSDSWorkListItems.DELETE_WORKCASEASSIGNMENT);
                                query.setParameter(ProcessClosedMSDSWorkListItems.PARAM_CASEID, (Object)((BigDecimal)this.getContextData().get(ProcessClosedMSDSWorkListItems.PARAM_CASEID)));
                                return new Integer(query.executeUpdate());
                            }
                        };
                        Integer updateCount1 = (Integer)this.getDao().execute(callback1);
                        if (updateCount1 < 1 && this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)(this.getProcessName() + ": Workcase assignment cannot be deleted for caseId=" + wkfCaseId));
                        }
                        AbstractDAOAction callback2 = new AbstractDAOAction(contextData){

                            public Object execute(Session session) {
                                Query query = session.getNamedQuery(ProcessClosedMSDSWorkListItems.DELETE_WORKCASECOMMENTS);
                                query.setParameter(ProcessClosedMSDSWorkListItems.PARAM_CASEID, (Object)((BigDecimal)this.getContextData().get(ProcessClosedMSDSWorkListItems.PARAM_CASEID)));
                                return new Integer(query.executeUpdate());
                            }
                        };
                        Integer updateCount2 = (Integer)this.getDao().execute(callback2);
                        if (updateCount2 < 1 && this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)(this.getProcessName() + ": Workcase comments cannot be deleted for caseId=" + wkfCaseId));
                        }
                        AbstractDAOAction callback3 = new AbstractDAOAction(contextData){

                            public Object execute(Session session) {
                                Query query = session.getNamedQuery(ProcessClosedMSDSWorkListItems.DELETE_WORKCASESTATUS);
                                query.setParameter(ProcessClosedMSDSWorkListItems.PARAM_CASEID, (Object)((BigDecimal)this.getContextData().get(ProcessClosedMSDSWorkListItems.PARAM_CASEID)));
                                return new Integer(query.executeUpdate());
                            }
                        };
                        Integer updateCount3 = (Integer)this.getDao().execute(callback3);
                        if (updateCount3 < 1 && this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)(this.getProcessName() + ": Workcase status details cannot be deleted for caseId=" + wkfCaseId));
                        }
                        AbstractDAOAction callback4 = new AbstractDAOAction(contextData){

                            public Object execute(Session session) {
                                Query query = session.getNamedQuery(ProcessClosedMSDSWorkListItems.DELETE_WORKCASEMESSAGING);
                                query.setParameter(ProcessClosedMSDSWorkListItems.PARAM_CASEID, (Object)((BigDecimal)this.getContextData().get(ProcessClosedMSDSWorkListItems.PARAM_CASEID)));
                                return new Integer(query.executeUpdate());
                            }
                        };
                        Integer updateCount4 = (Integer)this.getDao().execute(callback4);
                        if (updateCount4 < 1 && this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)(this.getProcessName() + ": Workcase messaging cannot be deleted for caseId=" + wkfCaseId));
                        }
                        AbstractDAOAction callback = new AbstractDAOAction(contextData){

                            public Object execute(Session session) {
                                Query query = session.getNamedQuery(ProcessClosedMSDSWorkListItems.DELETE_WORKCASE);
                                query.setParameter(ProcessClosedMSDSWorkListItems.PARAM_CASEID, (Object)((BigDecimal)this.getContextData().get(ProcessClosedMSDSWorkListItems.PARAM_CASEID)));
                                return new Integer(query.executeUpdate());
                            }
                        };
                        Integer updateCount = (Integer)this.getDao().execute(callback);
                        if (updateCount < 1 && this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)(this.getProcessName() + ": Workflow case cannot be deleted for caseId=" + wkfCaseId));
                        }
                        context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                    }
                }
                catch (Exception ex) {
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                    String errMsg = "Error while executing Process Closed MSDS Work List Item for Workflow Case " + wkfCaseId;
                    context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                    if (!this.logger.isWarnEnabled()) break block16;
                    this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                }
            }
            if (!context.getProcessStatistics().isTotalNumberMod(5)) continue;
            this.updateJobResult((DataProcessExecutionContext)context);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Process Closed MSDS Broker Work Items: Processing of current batch complete.");
            this.logger.debug((Object)("Process Closed MSDS Broker Work Items: Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("Process Closed MSDS Broker Work Items: Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public TransactionTimestampManager getTimestampManager() {
        return this.timestampManager;
    }

    public void setTimestampManager(TransactionTimestampManager timestampManager) {
        this.timestampManager = timestampManager;
    }

    private boolean isWorkItemMeetsOneofMSDSExceptionRules(String errStr) {
        boolean ruleFlag = false;
        if (this.contains(msds_exception_rules, errStr)) {
            ruleFlag = true;
        }
        return ruleFlag;
    }

    private boolean contains(String[] strings, String string) {
        if (string == null || StringUtils.isBlank((String)string)) {
            return false;
        }
        return exceptionSet.contains(string.trim());
    }

    static {
        exceptionSet.addAll(Arrays.asList(msds_exception_rules));
    }
}

