/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.SourceDesignation;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.trigger.LetterTrigger;
import gov.va.med.esr.service.trigger.LetterTriggerIdentity;
import gov.va.med.fw.batchprocess.AbstractDataQueryProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PreferredFacilityCleanupProcess
extends AbstractDataQueryProcess {
    private PSDelegateService psDelegateService = null;
    private PersonService personService = null;
    private LookupService lookupService = null;
    private HandBookService handBookService = null;
    private static final int INCREMENT_SIZE = 25;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processData(DataProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("PF Cleanup Process : Query result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        for (int i = 0; i < acquiredData.size(); ++i) {
            BigDecimal personId = (BigDecimal)acquiredData.get(i);
            PersonIdEntityKeyImpl key = new PersonIdEntityKeyImpl(personId);
            try {
                Person person = this.getPersonService().getPerson(key);
                if (person.getPreferredFacilities() == null || person.getPreferredFacilities().isEmpty()) {
                    Set sites = this.getPsDelegateService().getSites(person.getVPIDEntityKey());
                    ArrayList<SiteIdentity> medFacilities = new ArrayList<SiteIdentity>();
                    if (sites != null && !sites.isEmpty()) {
                        for (SiteIdentity siteIdentity : sites) {
                            if (!siteIdentity.getVaFacility().getType().getIsMedicalTreating()) continue;
                            medFacilities.add(siteIdentity);
                        }
                    }
                    if (medFacilities.size() == 1) {
                        this.savePreferredFacility(person, ((SiteIdentity)((Object)medFacilities.get(0))).getVaFacility(), context);
                        continue;
                    }
                    Map pvs = person.getPatientVisitSummaries();
                    if (pvs != null && !pvs.isEmpty()) {
                        List<PatientVisitSummary> sortedPatientVisitSummaries = this.sortLastVisitDateRecentToOld(pvs.values());
                        VAFacility recent = this.getPreferredFacilityRecentVisit(sortedPatientVisitSummaries);
                        this.savePreferredFacility(person, recent, context);
                        continue;
                    }
                    if (medFacilities.size() > 1) {
                        VAFacility closest = this.findNearestLogicalZip(person, medFacilities);
                        if (closest != null) {
                            this.savePreferredFacility(person, closest, context);
                            continue;
                        }
                        throw new Exception("Nearest facility cannot be determined");
                    }
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                    this.logger.error((Object)("Error in PF cleanup Process, cannot assign PF to Person " + personId));
                    continue;
                }
                this.logger.info((Object)("PF already assigned. Skipping acquired data for person: " + personId));
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                continue;
            }
            catch (Exception ex) {
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                String errMsg = "UNK Error while executing PF cleanup process for person " + personId;
                context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                this.logger.error((Object)(errMsg + " Reason: "), (Throwable)ex);
                continue;
            }
            finally {
                if (context.getProcessStatistics().isTotalNumberMod(25)) {
                    this.updateJobResult(context);
                }
            }
        }
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public PSDelegateService getPsDelegateService() {
        return this.psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public HandBookService getHandBookService() {
        return this.handBookService;
    }

    public void setHandBookService(HandBookService handBookService) {
        this.handBookService = handBookService;
    }

    private VAFacility findNearestLogicalZip(Person person, List medFacilities) {
        if (person == null || person.getPermanentAddress() == null) {
            return null;
        }
        String zip = person.getPermanentAddress().getZipCode();
        if (zip == null) {
            return null;
        }
        ArrayList<VAFacility> facilities = new ArrayList<VAFacility>();
        for (SiteIdentity siteIdentity : medFacilities) {
            facilities.add(siteIdentity.getVaFacility());
        }
        boolean match = false;
        int level = 5;
        VAFacility nearest = null;
        for (int i = 0; i < 5 && !match; ++i) {
            zip = zip.substring(0, level);
            Iterator itr = facilities.iterator();
            while (itr != null && itr.hasNext()) {
                String vaZip;
                VAFacility vamc = (VAFacility)((Object)itr.next());
                if (vamc == null || vamc.getEndDate() != null || vamc.getStreetAddress() == null || vamc.getStreetAddress().getZipCode() == null || !zip.equals(vaZip = vamc.getStreetAddress().getZipCode().substring(0, level))) continue;
                match = true;
                nearest = vamc;
                break;
            }
            --level;
        }
        if (nearest == null) {
            nearest = (VAFacility)((Object)facilities.get(0));
        }
        return nearest;
    }

    private void savePreferredFacility(Person person, VAFacility facility, DataProcessExecutionContext context) {
        try {
            PreferredFacility pf = new PreferredFacility();
            List conditions = null;
            ComLetterTemplateType type = this.getLookupService().getComLetterTemplateTypeByCode(ComLetterTemplateType.FORM_NUMBER_400H.getCode());
            pf.setAssignmentDate(new Date());
            pf.setFacility(facility);
            pf.setSourceDesignation(this.getLookupService().getSourceDesignationByCode(SourceDesignation.CODE_ESR.getCode()));
            person.addPreferredFacility(pf);
            this.getPersonService().save(person);
            context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
            conditions = this.getHandBookService().requestHandBook(person.getEntityKey().getKeyValueAsString(), new LetterTriggerIdentity(type, LetterTrigger.CategoryType.VETERAN_LETTER));
        }
        catch (Exception ex) {
            context.getProcessStatistics().incrementNumberOfErrorRecords();
            this.logger.error((Object)("Error saving preferred facility during PF cleanup job for person:" + person.getEntityKey().getKeyValueAsString() + " " + ex));
        }
    }

    private List<PatientVisitSummary> sortLastVisitDateRecentToOld(Collection<PatientVisitSummary> patientVisitSummaries) {
        ArrayList<PatientVisitSummary> sortedPatientVisitSummaries = new ArrayList<PatientVisitSummary>();
        if (patientVisitSummaries != null && !patientVisitSummaries.isEmpty()) {
            for (PatientVisitSummary summary : patientVisitSummaries) {
                if (summary.getLastVisitDate() == null) continue;
                sortedPatientVisitSummaries.add(summary);
            }
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    Date date1 = pObject1 instanceof PatientVisitSummary ? ((PatientVisitSummary)((Object)pObject1)).getLastVisitDate() : null;
                    Date date2 = pObject2 instanceof PatientVisitSummary ? ((PatientVisitSummary)((Object)pObject2)).getLastVisitDate() : null;
                    return date1 != null && date2 != null ? -date1.compareTo(date2) : 0;
                }
            };
            Collections.sort(sortedPatientVisitSummaries, comparator);
        }
        return sortedPatientVisitSummaries;
    }

    private VAFacility getPreferredFacilityRecentVisit(Collection<PatientVisitSummary> sortedPatientVisitSummaries) {
        PatientVisitSummary PVS = null;
        if (sortedPatientVisitSummaries != null && !sortedPatientVisitSummaries.isEmpty()) {
            PVS = sortedPatientVisitSummaries.iterator().next();
        }
        return PVS != null ? PVS.getFacilityVisited() : null;
    }
}

