/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.Correspondence;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.CorrespondenceStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.person.MECPeriodDAO;
import gov.va.med.esr.service.CorrespondenceService;
import gov.va.med.esr.service.PersonMergeService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryDetail;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class PopulateACAMailQueue
extends AbstractDataQueryIncrementalProcess {
    private static final int DEFAULT_JOB_RESULT_UPDATE_INTERVAL = 100;
    private int fetchSize = 500;
    private String calendarYear = null;
    private String startDay = "-01-01";
    private String startDate = null;
    private PersonService personService;
    private PersonMergeService personMergeService;
    private CorrespondenceService correspondenceService;
    private MECPeriodDAO mecPeriodDAO = null;
    private int numRecs = 0;
    private ArrayList<BigDecimal> batch = null;
    private static final String ERR_DEPRECATED = "Deprecated Person or Pending Merge";
    public static final String ERR_RETRIEVE = "Failed to Retrieve Record";

    protected void executeProcess(DataProcessExecutionContext context) throws Exception {
        String args = (String)context.getExecutionArguments();
        if (!StringUtils.isEmpty((String)args)) {
            this.calendarYear = args.trim();
        }
        if (this.calendarYear == null) {
            Calendar thisYear = Calendar.getInstance();
            this.calendarYear = Integer.toString(thisYear.get(1));
        }
        this.startDate = this.calendarYear + this.startDay;
        this.batch = new ArrayList();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = formatter.parse(this.startDate);
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.add(6, -1);
        String dateParam = formatter.format(cal.getTime());
        this.setParamNames(new String[]{"startDate"});
        this.setParamValues(new String[]{dateParam});
        super.executeProcess(context);
    }

    protected List doAcquireData(DataQueryProcessExecutionContext context) throws Exception {
        List acquiredData = null;
        acquiredData = this.executeQuery(context);
        return acquiredData;
    }

    protected List executeQuery(DataQueryProcessExecutionContext context) throws Exception {
        if (context.isInterrupted()) {
            return null;
        }
        DataQueryDetail currentQuery = context.getCurrentDataQuery();
        List results = this.getDao().find(currentQuery.getQuery().getQuery(), currentQuery.getQuery().getParamNames(), currentQuery.getQuery().getParamValues(), this.numRecs, this.fetchSize, this.fetchSize);
        this.numRecs += this.fetchSize;
        return results;
    }

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (acquiredData == null) {
            return;
        }
        ArrayList<BigDecimal> fetchedList = new ArrayList();
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            if (acquiredData.get(i) instanceof Object[]) {
                Object[] row = (Object[])acquiredData.get(i);
                BigDecimal val = (BigDecimal)row[0];
                this.batch.add(val);
                continue;
            }
            this.batch.add((BigDecimal)acquiredData.get(i));
        }
        fetchedList = new ArrayList<BigDecimal>(this.batch);
        this.batch.clear();
        this.processEntityData(context, fetchedList, this.calendarYear);
    }

    public void processEntityData(DataQueryProcessExecutionContext context, ArrayList<BigDecimal> fetchedList, String calendarYear) {
        this.processBatch(context, fetchedList, calendarYear);
    }

    public void processBatch(DataQueryProcessExecutionContext context, ArrayList<BigDecimal> submitBatch, String calendarYear) {
        BigDecimal personId = null;
        try {
            for (int i = 0; i < submitBatch.size(); ++i) {
                block8: {
                    if (this.isInterrupted((DataProcessExecutionContext)context)) {
                        return;
                    }
                    Correspondence c = null;
                    Person onFile = null;
                    if (this.shouldUpdateJobResult(context)) {
                        this.updateJobResult((DataProcessExecutionContext)context);
                    }
                    try {
                        personId = submitBatch.get(i);
                        PersonIdEntityKey personKey = CommonEntityKeyFactory.createPersonIdEntityKey(personId);
                        VPIDEntityKey vpid = this.getPersonService().getVPIDByPersonId(personKey);
                        onFile = this.getPersonService().getPersonWithoutIdentityTraits(vpid);
                        if (onFile == null) {
                            this.setRejectAndError(null, personId.toString(), ERR_RETRIEVE, (DataProcessExecutionContext)context);
                            continue;
                        }
                        c = new Correspondence(onFile);
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                        Date date = formatter.parse(this.startDate);
                        c.setEffectiveDate(date);
                        this.getCorrespondenceService().triggerNewCMSCorrespondence(c, ComLetterTemplateType.FORM_NUMBER_800);
                        if (!this.getPersonMergeService().hasDeprecatedRecord(personKey)) break block8;
                        this.setRejectAndError(c, personId.toString(), ERR_DEPRECATED, (DataProcessExecutionContext)context);
                    }
                    catch (Exception ex) {
                        this.setRejectAndError(c, onFile.getPersonEntityKey().getKeyValueAsString(), ex.getMessage(), (DataProcessExecutionContext)context);
                        continue;
                    }
                }
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unknown Exception in Populate ACA Mail Queue: " + ex.getMessage()));
            context.getProcessStatistics().incrementNumberOfErrorRecords();
        }
    }

    private void setRejectAndError(Correspondence form, String personId, String errMsg, DataProcessExecutionContext context) {
        try {
            if (form != null) {
                this.getCorrespondenceService().updateACACorrespondence(form, CorrespondenceStatus.ENROLLMENT_REJECT, errMsg);
            }
            context.getProcessStatistics().incrementNumberOfErrorRecords();
            this.logger.error((Object)("Failed to generate ACA mail queue entry for person: " + personId + ": " + errMsg));
        }
        catch (ServiceException ex) {
            this.logger.error((Object)("Failed to update ACA correspondence for person: " + personId), (Throwable)ex);
        }
    }

    protected boolean shouldUpdateJobResult(DataQueryProcessExecutionContext context) {
        return context.getProcessStatistics().isTotalNumberMod(100);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        context.setExecutionArguments(null);
        this.calendarYear = null;
        super.handleDataProcessCompleted(context);
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public MECPeriodDAO getMecPeriodDAO() {
        return this.mecPeriodDAO;
    }

    public void setMecPeriodDAO(MECPeriodDAO mecPeriodDAO) {
        this.mecPeriodDAO = mecPeriodDAO;
    }

    public PersonMergeService getPersonMergeService() {
        return this.personMergeService;
    }

    public void setPersonMergeService(PersonMergeService personMergeService) {
        this.personMergeService = personMergeService;
    }

    public CorrespondenceService getCorrespondenceService() {
        return this.correspondenceService;
    }

    public void setCorrespondenceService(CorrespondenceService correspondenceService) {
        this.correspondenceService = correspondenceService;
    }
}

