/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.PCMMImportData;
import gov.va.med.esr.common.batchprocess.PCMMImportProcess;
import gov.va.med.esr.service.PreferredFacilityService;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.support.AbstractSpawnedThreadTask;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.springframework.dao.OptimisticLockingFailureException;

public class PCMMImportProcessSpawnedThreadTask
extends AbstractSpawnedThreadTask {
    private static final int DEFAULT_OPTIMSTIC_RETRIES = 5;
    private DataFileProcessExecutionContext context;
    private List dataRecords;
    private PreferredFacilityService preferredFacilityService;
    private int optimisticLockRetries = 5;

    public DataFileProcessExecutionContext getContext() {
        return this.context;
    }

    public void setContext(DataFileProcessExecutionContext context) {
        this.context = context;
    }

    public int getOptimisticLockRetries() {
        return this.optimisticLockRetries;
    }

    public void setOptimisticLockRetries(int optimisticLockRetries) {
        this.optimisticLockRetries = optimisticLockRetries;
    }

    public List getDataRecords() {
        return this.dataRecords;
    }

    public void setDataRecords(List dataRecords) {
        this.dataRecords = dataRecords;
    }

    public PreferredFacilityService getPreferredFacilityService() {
        return this.preferredFacilityService;
    }

    public void setPreferredFacilityService(PreferredFacilityService preferredFacilityService) {
        this.preferredFacilityService = preferredFacilityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void executeTask() throws Throwable {
        Object threadCreator;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"PCMMImportProcessSpawnedThreadTask started");
        }
        for (int i = 0; this.dataRecords != null && i < this.dataRecords.size() && !this.context.isInterrupted(); ++i) {
            try {
                PCMMImportData dataRecord = (PCMMImportData)((Object)this.dataRecords.get(i));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing dataRecord #" + i));
                }
                int numberOfRetries = this.optimisticLockRetries;
                boolean optimisticLockSuccess = false;
                while (numberOfRetries > 0 && !optimisticLockSuccess) {
                    try {
                        this.preferredFacilityService.processPCMMData(dataRecord);
                        optimisticLockSuccess = true;
                        this.context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                    }
                    catch (OptimisticLockingFailureException ole) {
                        --numberOfRetries;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Encountered OptimisticLockingFailureException, # of retries remaining = " + numberOfRetries));
                        }
                        if (numberOfRetries != 0) continue;
                        throw new ServiceException("Exhausted number of retries (" + this.optimisticLockRetries + ") for OptimisticLockingFailureException.");
                    }
                }
                continue;
            }
            catch (Exception e) {
                this.handleFailure(this.context, this.dataRecords.get(i), e);
            }
        }
        PCMMImportProcess.adjustTaskCount((DataProcessExecutionContext)this.context, -1);
        Object object = threadCreator = this.getThreadCreator((DataProcessExecutionContext)this.context);
        // MONITORENTER : object
        threadCreator.notifyAll();
        // MONITOREXIT : object
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"PCMMImportProcessSpawnedThreadTask ended, notified creator");
        }
        this.context = null;
    }

    private Object getThreadCreator(DataProcessExecutionContext context) {
        return context.getContextData().get("threadCreator");
    }

    private void handleFailure(DataFileProcessExecutionContext context, Object dataRecord, Exception e) {
        String exceptionText = null;
        exceptionText = e == null ? "Error: Unable to process PCMM data: " + dataRecord : "Error: Unable to process PCMM data: " + dataRecord + " because of exception: " + e;
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)exceptionText);
        }
        context.getProcessStatistics().incrementNumberOfErrorRecords();
        context.getExceptionData().add(dataRecord);
        context.getExceptionData().add(exceptionText + "\n\n");
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String trackTrace = sw.toString();
            context.getExceptionData().add(trackTrace);
        }
    }
}

