/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.ExceptionWriterProcessCompletedHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class PCMMImportProcessCompletedHandler
extends ExceptionWriterProcessCompletedHandler {
    private String renameInputFileExtension;
    private String renameInputFileRoot;

    public String getRenameInputFileExtension() {
        return this.renameInputFileExtension;
    }

    public void setRenameInputFileExtension(String renameInputFileExtension) {
        this.renameInputFileExtension = renameInputFileExtension;
    }

    public String getRenameInputFileRoot() {
        return this.renameInputFileRoot;
    }

    public void setRenameInputFileRoot(String renameInputFileRoot) {
        this.renameInputFileRoot = renameInputFileRoot;
    }

    protected Object getExceptionFileNameSuffixData(DataProcessExecutionContext context) {
        Date executionStartDate = context.getProcessStatistics().getProcessingStartDate();
        return executionStartDate;
    }

    public void dataProcessingComplete(DataProcessExecutionContext context) {
        File inputFile;
        this.appendExceptionData(context);
        if (!context.isInterrupted() && context instanceof DataFileProcessExecutionContext && !this.renameFile(inputFile = ((DataFileProcessExecutionContext)context).getCurrentFile())) {
            throw new IllegalStateException("Unable to rename input file: " + inputFile.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendExceptionData(DataProcessExecutionContext context) {
        File inputFile = ((DataFileProcessExecutionContext)context).getCurrentFile();
        String inputFileName = inputFile.getPath();
        this.getFileWriter().setFileLocation(inputFileName);
        List exceptionData = context.getExceptionData();
        if (exceptionData != null && !exceptionData.isEmpty()) {
            ArrayList currentExceptionData = new ArrayList(exceptionData);
            List list = exceptionData;
            synchronized (list) {
                exceptionData.clear();
            }
            this.getFileWriter().appendData(currentExceptionData, this.getExceptionFileNameSuffixData(context));
        }
    }

    protected boolean renameFile(File inputFile) {
        String inputFilePath = inputFile.getParent();
        StringBuffer inputFileNameRoot = new StringBuffer("");
        StringTokenizer st = new StringTokenizer(inputFile.getName(), ".");
        int tokenCount = st.countTokens();
        for (int i = 1; i < tokenCount; ++i) {
            inputFileNameRoot.append(st.nextToken());
            if (i == tokenCount - 1) continue;
            inputFileNameRoot.append(".");
        }
        if (tokenCount == 1) {
            inputFileNameRoot.append(inputFile.getName());
        }
        String newFileName = null;
        newFileName = this.renameInputFileRoot != null ? this.renameInputFileRoot + this.renameInputFileExtension : inputFileNameRoot.toString() + this.renameInputFileExtension;
        File newFile = new File(inputFilePath + File.separator + newFileName);
        int i = 1;
        while (newFile.exists()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Can not rename file to " + newFile.getName() + " since it exists already.  Trying one up number extension"));
            }
            newFile = new File(inputFilePath + File.separator + newFileName + i++);
        }
        boolean result = inputFile.renameTo(newFile);
        inputFile.setLastModified(new Date().getTime());
        return result;
    }
}

