/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.AbstractOPPExtractOutputFileProducer;
import gov.va.med.esr.common.batchprocess.OPPExtractExecutionContext;
import gov.va.med.esr.common.batchprocess.OPPExtractProcessStatistics;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.fw.io.RawFileDataList;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.person.idmgmt.VPID;
import java.util.List;

public class OPPExtractCommonOutputFileProducer
extends AbstractOPPExtractOutputFileProducer {
    @Override
    protected RawFileDataList setIdentityTraitsOnOutputData(RawFileDataList rawFileDataRow, PersonIdentityTraits traits) {
        rawFileDataRow.set(0, (Object)VPID.getShortVPID((String)((String)rawFileDataRow.get(1))));
        rawFileDataRow.set(1, (Object)(traits == null || traits.getSsn() == null ? "" : traits.getSsn().getSsnText()));
        return rawFileDataRow;
    }

    @Override
    protected void incrementStatistics(OPPExtractExecutionContext context, List outputFileData) {
        OPPExtractProcessStatistics statistics = (OPPExtractProcessStatistics)context.getProcessStatistics();
        this.setStatistics(statistics, outputFileData);
    }

    private void setStatistics(OPPExtractProcessStatistics statistics, List outputFileData) {
        statistics.incrementNumberOfSuccessfulRecords(outputFileData.size());
        if (StringUtils.equals((String)"OPPExtractProcess-CDCondition", (String)statistics.getProcessName())) {
            statistics.incrementNumberOfCDConditionFileRecords(outputFileData.size());
        }
        if (StringUtils.equals((String)"OPPExtractProcess-CDDiagnosis", (String)statistics.getProcessName())) {
            statistics.incrementNumberOfCDDiagnosisFileRecords(outputFileData.size());
        }
        if (StringUtils.equals((String)"OPPExtractProcess-CDProcedure", (String)statistics.getProcessName())) {
            statistics.incrementNumberOfCDProcedureFileRecords(outputFileData.size());
        }
        if (StringUtils.equals((String)"OPPExtractProcess-CDDescriptor", (String)statistics.getProcessName())) {
            statistics.incrementNumberOfCDDescriptorFileRecords(outputFileData.size());
        }
        if (StringUtils.equals((String)"OPPExtractProcess-Eligibility", (String)statistics.getProcessName())) {
            statistics.incrementNumberOfEligibilityFileRecords(outputFileData.size());
        }
        if (StringUtils.equals((String)"OPPExtractProcess-PeriodOfService", (String)statistics.getProcessName())) {
            statistics.incrementNumberOfPeriodOfServiceFileRecords(outputFileData.size());
        }
        if (StringUtils.equals((String)"OPPExtractProcess-RatedDisability", (String)statistics.getProcessName())) {
            statistics.incrementNumberOfRatedDisabilitiesFileRecords(outputFileData.size());
        }
        if (StringUtils.equals((String)"OPPExtractProcess-CombatEpisode", (String)statistics.getProcessName())) {
            statistics.incrementNumberOfCombatEpisodeFileRecords(outputFileData.size());
        }
        if (StringUtils.equals((String)"OPPExtractProcess-Race", (String)statistics.getProcessName())) {
            statistics.incrementNumberOfRaceFileRecords(outputFileData.size());
        }
    }
}

