/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.MVIAddressExportProcess;
import gov.va.med.esr.common.batchprocess.MVIAddressExportProcessStatistics;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.IdmServiceVO;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.support.AbstractSpawnedThreadTask;
import gov.va.med.fw.util.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import org.hibernate.Query;
import org.hibernate.Session;

public class MVIAddressExportProcessSpawnedThreadTask
extends AbstractSpawnedThreadTask {
    private LookupService lookupService;
    private PersonService personService;
    private Object[] acquiredData;
    private DataQueryProcessExecutionContext context = null;
    private DAOOperations dao;
    private AddressType permAddressType = null;
    private PhoneType homePhoneType = null;
    private static final String ADDRESS_UPDATE_DATE_QUERY = "MVIAddressExportProcess.latestDateQuery";
    private static final String UPDATE_SEEDING_STATUS = "MVIAddressExportProcess.updateSeeding";
    private static final String PARAM_PERSONID = "person_id";
    private static final String PARAM_SEEDING_ID = "seedingId";
    private static final String PARAM_SEEDINGSTATUS_ID = "statusId";
    private static final BigDecimal SEEDING_STATUS_COMPLETE_ID = new BigDecimal("1758848");
    private static final BigDecimal SEEDING_STATUS_ERROR_ID = new BigDecimal("1758849");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() throws Throwable {
        BigDecimal personId = null;
        BigDecimal seedingRecordId = null;
        Date batchEndDate = null;
        try {
            seedingRecordId = (BigDecimal)this.acquiredData[0];
            personId = (BigDecimal)this.acquiredData[1];
            batchEndDate = (Date)this.acquiredData[4];
            if (!this.isAddressPhoneUpdated(personId, batchEndDate)) {
                String vpidValue = (String)this.acquiredData[2];
                VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey(vpidValue);
                PersonIdEntityKey personKey = CommonEntityKeyFactory.createPersonIdEntityKey(personId);
                PersonIdentityTraits traits = this.personService.getESRCorrelation(key);
                Person incoming = this.personService.getPersonWithoutIdentityTraits(personKey);
                IdmServiceVO idmServiceVO = this.convertTraitsToIdmServiceVO(traits);
                idmServiceVO.setDeathRecord(incoming.getDeathRecord());
                idmServiceVO.setDeathEvent(false);
                idmServiceVO.setVpid(key);
                Address address = this.populateAddressData();
                this.overlayAddress(idmServiceVO, address);
                Phone phone = this.populatePhoneData();
                this.overlayPhone(idmServiceVO, phone);
                this.personService.updateProfileForESRCorrelation(idmServiceVO);
                this.context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
            } else {
                ((MVIAddressExportProcessStatistics)this.context.getProcessStatistics()).incrementNumberOfIgnoredRecords();
            }
            this.updateSeedingStatusToComplete(seedingRecordId);
        }
        catch (Exception ex) {
            this.handleFailure((DataProcessExecutionContext)this.context, seedingRecordId, personId, ex);
        }
        finally {
            Object threadCreator;
            MVIAddressExportProcess.adjustTaskCount((DataProcessExecutionContext)this.context, -1);
            Object object = threadCreator = this.getThreadCreator((DataProcessExecutionContext)this.context);
            synchronized (object) {
                threadCreator.notifyAll();
            }
            this.context = null;
        }
    }

    private boolean isAddressPhoneUpdated(BigDecimal personId, Date batchEndDate) throws DAOException {
        HashMap<String, BigDecimal> contextData = new HashMap<String, BigDecimal>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query query = session.getNamedQuery(MVIAddressExportProcessSpawnedThreadTask.ADDRESS_UPDATE_DATE_QUERY);
                query.setParameter(MVIAddressExportProcessSpawnedThreadTask.PARAM_PERSONID, (Object)((BigDecimal)this.getContextData().get("personId")));
                return query.uniqueResult();
            }
        };
        Date addressUpdateDate = (Date)this.getDao().execute(callback);
        return addressUpdateDate != null && addressUpdateDate.after(batchEndDate);
    }

    private IdmServiceVO convertTraitsToIdmServiceVO(PersonIdentityTraits traits) throws ServiceException {
        IdmServiceVO idmServiceVO = new IdmServiceVO();
        idmServiceVO.setNames(traits.getNames());
        SSN ssnOfficial = traits.getSsn();
        if (ssnOfficial != null) {
            idmServiceVO.setSsn(ssnOfficial);
        }
        idmServiceVO.setGender(traits.getGender());
        idmServiceVO.setBirthRecord(traits.getBirthRecord());
        idmServiceVO.setDeathEvent(false);
        idmServiceVO.setVpid(traits.getVpid());
        idmServiceVO.setPatientType(traits.getPatientType());
        idmServiceVO.setVeteran(traits.isVeteran());
        idmServiceVO.setServiceConnected(traits.isServiceConnected());
        idmServiceVO.setPreferredFacilty(traits.getPreferredFacilty());
        idmServiceVO.setMothersMaidenName(traits.getMothersMaidenName());
        return idmServiceVO;
    }

    private Address populateAddressData() throws UnknownLookupTypeException, UnknownLookupCodeException {
        Address address = new Address();
        address.setType(this.getPermAddressType());
        String badAddressReasonCd = (String)this.acquiredData[5];
        if (!StringUtils.isEmpty((String)badAddressReasonCd)) {
            BadAddressReason badAddrReason = this.getLookupService().getBadAddressReasonByCode(badAddressReasonCd);
            address.setBadAddressReason(badAddrReason);
        }
        address.setLine1((String)this.acquiredData[6]);
        address.setLine2((String)this.acquiredData[7]);
        address.setLine3((String)this.acquiredData[8]);
        address.setCity((String)this.acquiredData[9]);
        address.setState((String)this.acquiredData[10]);
        address.setZipCode((String)this.acquiredData[11]);
        address.setZipPlus4((String)this.acquiredData[12]);
        address.setCountry((String)this.acquiredData[13]);
        return address;
    }

    private Phone populatePhoneData() throws UnknownLookupTypeException, UnknownLookupCodeException {
        Phone phone = new Phone();
        phone.setType(this.getHomePhoneType());
        phone.setPhoneNumber((String)this.acquiredData[14]);
        return phone;
    }

    private void overlayAddress(IdmServiceVO idmServiceVO, Address address) {
        idmServiceVO.setAddresses(null);
        idmServiceVO.addAddress(address);
    }

    private void overlayPhone(IdmServiceVO idmServiceVO, Phone phone) {
        idmServiceVO.setPhones(null);
        idmServiceVO.addPhone(phone);
    }

    private Object getThreadCreator(DataProcessExecutionContext context) {
        return context.getContextData().get("threadCreator");
    }

    private void handleFailure(DataProcessExecutionContext context, BigDecimal seedingRecordId, BigDecimal personId, Exception e) {
        block4: {
            try {
                this.updateSeedingStatusToError(seedingRecordId);
            }
            catch (DAOException daoe) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error((Object)("Error: unable to set seeding status to ERROR for seedingRecordId = " + seedingRecordId));
            }
        }
        String exceptionText = null;
        exceptionText = e == null ? "Error: Unable to process person: " + personId : "Error: Unable to process person: " + personId + " because of exception: " + e;
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)exceptionText);
        }
        context.getProcessStatistics().incrementNumberOfErrorRecords();
        context.getExceptionData().add(personId);
        context.getExceptionData().add(exceptionText + "\n\n");
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String trackTrace = sw.toString();
            context.getExceptionData().add(trackTrace);
        }
    }

    private AddressType getPermAddressType() throws UnknownLookupTypeException, UnknownLookupCodeException {
        if (this.permAddressType == null) {
            this.permAddressType = this.getLookupService().getAddressTypeByCode(AddressType.CODE_PERMANENT_ADDRESS.getCode());
        }
        return this.permAddressType;
    }

    private PhoneType getHomePhoneType() throws UnknownLookupTypeException, UnknownLookupCodeException {
        if (this.homePhoneType == null) {
            this.homePhoneType = this.getLookupService().getPhoneTypeByCode(PhoneType.CODE_HOME.getCode());
        }
        return this.homePhoneType;
    }

    private void updateSeedingStatusToComplete(BigDecimal seedingRecordId) throws DAOException {
        this.updateSeedingStatus(seedingRecordId, SEEDING_STATUS_COMPLETE_ID);
    }

    private void updateSeedingStatusToError(BigDecimal seedingRecordId) throws DAOException {
        this.updateSeedingStatus(seedingRecordId, SEEDING_STATUS_ERROR_ID);
    }

    private void updateSeedingStatus(BigDecimal seedingRecordId, BigDecimal seedingStatusId) throws DAOException {
        HashMap<String, BigDecimal> contextData = new HashMap<String, BigDecimal>();
        contextData.put("seedingRecordId", seedingRecordId);
        contextData.put("seedingStatusId", seedingStatusId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) throws DAOException {
                Integer returnCount = null;
                Query query = session.getNamedQuery(MVIAddressExportProcessSpawnedThreadTask.UPDATE_SEEDING_STATUS);
                String prepareStmt = query.getQueryString();
                if (prepareStmt != null && prepareStmt.length() > 0) {
                    try {
                        PreparedStatement ps = session.connection().prepareStatement(prepareStmt);
                        ps.setBigDecimal(1, (BigDecimal)this.getContextData().get("seedingStatusId"));
                        ps.setBigDecimal(2, (BigDecimal)this.getContextData().get("seedingRecordId"));
                        returnCount = new Integer(ps.executeUpdate());
                    }
                    catch (SQLException ex) {
                        throw new DAOException("Failed to execute prepare statement: " + prepareStmt, (Throwable)ex);
                    }
                }
                return returnCount;
            }
        };
        Integer updateCount = (Integer)this.getDao().execute(callback);
        if (updateCount < 1) {
            throw new DAOException("SeedingStatus not updated for esr_addr_phne_batch_id = " + seedingRecordId);
        }
    }

    public Object[] getAcquiredData() {
        return this.acquiredData;
    }

    public void setAcquiredData(Object[] acquiredData) {
        this.acquiredData = acquiredData;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public DAOOperations getDao() {
        return this.dao;
    }

    public void setDao(DAOOperations dao) {
        this.dao = dao;
    }

    public DataQueryProcessExecutionContext getContext() {
        return this.context;
    }

    public void setContext(DataQueryProcessExecutionContext context) {
        this.context = context;
    }
}

