/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.MVIAddressExportProcessSpawnedThreadTask;
import gov.va.med.esr.common.batchprocess.MVIAddressExportProcessStatistics;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ExceptionWriterProcessCompletedHandler;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.ThreadPool;
import java.util.List;

public class MVIAddressExportProcess
extends AbstractDataQueryIncrementalProcess {
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final int DEFAULT_THROTTLE_TASKCOUNT_THREASHOLD = 100;
    private static final int DEFAULT_SPAWN_RETRY_PERIOD = 3000;
    private static final int DEFAULT_EXCEPTION_UPDATE_INTERVAL = 20;
    public static final String CONTEXT_THREAD_CREATOR = "threadCreator";
    public static final String CONTEXT_TASK_COUNT = "taskCount";
    public static final String CONTEXT_THREAD_POOL = "threadPool";
    private int threadPoolSize = 10;
    private int throttleTaskCountThreshold = 100;
    private int spawnRetryPeriod = 3000;
    private String spawnedTaskId;

    protected void executeProcess(DataProcessExecutionContext context) throws Exception {
        String args = (String)context.getExecutionArguments();
        if (!StringUtils.isEmpty((String)args)) {
            this.setThreadPoolSize(args);
        }
        super.executeProcess(context);
    }

    private void setThreadPoolSize(String args) throws Exception {
        block3: {
            try {
                Integer customizedPoolSize = new Integer(args);
                this.setThreadPoolSize(customizedPoolSize);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("MVIAddressExportProcess -- Setting threadpool size to " + customizedPoolSize));
                }
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error((Object)("MVIAddressExportProcess -- Invalid process argument: " + args + "."), (Throwable)e);
            }
        }
    }

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (acquiredData == null) {
            return;
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            Object[] row = (Object[])acquiredData.get(i);
            this.processEntityData(context, row);
        }
    }

    public void processEntityData(DataQueryProcessExecutionContext context, Object[] acquiredData) {
        if (this.isThreaded()) {
            this.spawnThread(context, acquiredData);
        }
    }

    private void spawnThread(DataQueryProcessExecutionContext context, Object[] acquiredData) {
        try {
            while (MVIAddressExportProcess.getTaskCount((DataProcessExecutionContext)context) >= this.throttleTaskCountThreshold) {
                Thread.sleep(this.spawnRetryPeriod);
                if (this.shouldUpdateJobResult(context)) {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
                if (!this.shouldWriteExceptionData(context)) continue;
                ((ExceptionWriterProcessCompletedHandler)this.getDataProcessCompletedHandler()).appendExceptionData((DataProcessExecutionContext)context);
            }
            if (this.shouldUpdateJobResult(context)) {
                this.updateJobResult((DataProcessExecutionContext)context);
            }
            if (this.shouldWriteExceptionData(context)) {
                ((ExceptionWriterProcessCompletedHandler)this.getDataProcessCompletedHandler()).appendExceptionData((DataProcessExecutionContext)context);
            }
            this.initThreadCreatorAndIncrementTaskCount(context);
            ThreadPool threadPool = this.getThreadPool((DataProcessExecutionContext)context);
            MVIAddressExportProcessSpawnedThreadTask task = (MVIAddressExportProcessSpawnedThreadTask)((Object)this.getApplicationContext().getBean(this.spawnedTaskId));
            task.setContext(context);
            task.setAcquiredData(acquiredData);
            task.setAuditInfo(this.getAuditInfo());
            threadPool.invokeLater((Runnable)((Object)task));
        }
        catch (InterruptedException e) {
            this.throwIllegalStateException("MVIAddressExportProcessSpawnedThreadTask was interrupted while it was spawning a thread. ", e);
        }
    }

    private void cleanThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = this.getThreadPool(context);
        threadPool.stop();
        context.getContextData().put(CONTEXT_THREAD_POOL, null);
    }

    protected ProcessStatistics createProcessStatistics() {
        return new MVIAddressExportProcessStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        block10: {
            if (this.isThreaded()) {
                try {
                    if (MVIAddressExportProcess.getTaskCount(context) == 0) break block10;
                    MVIAddressExportProcess mVIAddressExportProcess = this;
                    synchronized (mVIAddressExportProcess) {
                        boolean stillProcessing = true;
                        while (stillProcessing) {
                            ((Object)((Object)this)).wait();
                            if (MVIAddressExportProcess.getTaskCount(context) != 0) continue;
                            stillProcessing = false;
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.throwIllegalStateException("MVIAddressExportProcess was interrupted while it was waiting for its spawned threads to complete", e);
                }
                finally {
                    this.getThreadPool(context).stop();
                    this.cleanThreadPool(context);
                }
            }
        }
        this.updateJobResult(context);
        ((ExceptionWriterProcessCompletedHandler)this.getDataProcessCompletedHandler()).appendExceptionData(context);
        super.handleDataProcessCompleted(context);
    }

    protected boolean shouldUpdateJobResult(DataQueryProcessExecutionContext context) {
        return context.getProcessStatistics().isTotalNumberMod(5);
    }

    private boolean shouldWriteExceptionData(DataQueryProcessExecutionContext context) {
        int exceptionDataSize;
        int n = exceptionDataSize = context.getExceptionData() == null ? 0 : context.getExceptionData().size();
        return exceptionDataSize != 0 ? exceptionDataSize % 20 == 0 : false;
    }

    public int getThrottleTaskCountThreshold() {
        return this.throttleTaskCountThreshold;
    }

    public void setThrottleTaskCountThreshold(int throttleTaskCountThreshold) {
        this.throttleTaskCountThreshold = throttleTaskCountThreshold;
    }

    public int getSpawnRetryPeriod() {
        return this.spawnRetryPeriod;
    }

    public void setSpawnRetryPeriod(int spawnRetryPeriod) {
        this.spawnRetryPeriod = spawnRetryPeriod;
    }

    private ThreadPool getThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = (ThreadPool)context.getContextData().get(CONTEXT_THREAD_POOL);
        if (threadPool == null) {
            threadPool = new ThreadPool("MVIAddressExportProcessSpawnedThreadTask", this.threadPoolSize);
            context.getContextData().put(CONTEXT_THREAD_POOL, threadPool);
        }
        return threadPool;
    }

    private void initThreadCreatorAndIncrementTaskCount(DataQueryProcessExecutionContext context) {
        if (!context.getContextData().containsKey(CONTEXT_THREAD_CREATOR)) {
            context.getContextData().put(CONTEXT_THREAD_CREATOR, this);
        }
        MVIAddressExportProcess.adjustTaskCount((DataProcessExecutionContext)context, 1);
    }

    static int getTaskCount(DataProcessExecutionContext context) {
        Integer count = (Integer)context.getContextData().get(CONTEXT_TASK_COUNT);
        return count != null ? count : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void adjustTaskCount(DataProcessExecutionContext context, int adjustment) {
        DataProcessExecutionContext dataProcessExecutionContext = context;
        synchronized (dataProcessExecutionContext) {
            context.getContextData().put(CONTEXT_TASK_COUNT, new Integer(MVIAddressExportProcess.getTaskCount(context) + adjustment));
        }
    }

    private boolean isThreaded() {
        return StringUtils.isNotBlank((String)this.spawnedTaskId);
    }

    public String getSpawnedTaskId() {
        return this.spawnedTaskId;
    }

    public void setSpawnedTaskId(String spawnedTaskId) {
        this.spawnedTaskId = spawnedTaskId;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }
}

