/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.Correspondence;
import gov.va.med.esr.common.model.comms.CorrespondenceDocument;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.CorrespondenceStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.comms.CommsTemplateDAO;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.service.CorrespondenceService;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataProcess;
import gov.va.med.fw.batchprocess.AcquiredDataProcessor;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.Validate;

public class Import1095BResponsesPDF
extends AbstractDataProcess
implements AcquiredDataProcessor {
    private CorrespondenceService correspondenceService;
    private PersonService personService;
    private LookupService lookupService;
    private DemographicService demographicService;
    private String inputFileLocation;
    private int numberOfTotalRecords = 0;
    ProcessStatistics stats;
    private CommsTemplateDAO templDAO;
    private CommsLogService commsLogService;
    File folder;

    protected List acquireData(DataProcessExecutionContext context) throws Exception {
        this.folder = new File(this.getInputFileLocation());
        List PDF_files = this.listFilesForFolder(this.folder);
        this.processData(context, PDF_files);
        PDF_files.clear();
        return PDF_files;
    }

    private List listFilesForFolder(File folder) {
        ArrayList<String> combined = new ArrayList<String>();
        for (String fileEntry : folder.list()) {
            if (!fileEntry.contains("1095B_") && !fileEntry.contains("LTR_")) continue;
            combined.add(fileEntry);
        }
        return combined;
    }

    public void processData(DataProcessExecutionContext context, List acquiredData) {
        if (acquiredData.isEmpty()) {
            this.logger.info((Object)"Import 1095B PDF Job is missing input PDF files");
            return;
        }
        if (this.stats == null) {
            this.stats = context.getProcessStatistics();
        }
        for (int j = 0; j < acquiredData.size(); ++j) {
            try {
                this.processDataRecord(context, acquiredData.get(j));
                continue;
            }
            catch (RuntimeException e) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error((Object)("RuntimeException in Import 1095B processDataRecords^" + e.getMessage()));
            }
        }
    }

    protected void processDataRecord(DataProcessExecutionContext context, Object acquiredData) {
        File currentPDFFile = new File(acquiredData.toString());
        String fileName = currentPDFFile.getName();
        String[] values = fileName.split("_");
        if (values == null || values.length != 6) {
            this.logger.error((Object)("Invalid pdf file name: " + fileName));
            context.getProcessStatistics().incrementNumberOfErrorRecords();
            return;
        }
        String vpid = values[1];
        String type = values[4];
        String taxYear = values[5];
        taxYear = taxYear.substring(0, 4);
        File processingFile = new File("" + this.folder.getAbsolutePath() + File.separatorChar + currentPDFFile.getName());
        FileInputStream fileInputStream = null;
        byte[] PDFByteArray = new byte[(int)processingFile.length()];
        try {
            fileInputStream = new FileInputStream(processingFile);
            fileInputStream.read(PDFByteArray);
            fileInputStream.close();
        }
        catch (Exception e) {
            this.logger.error((Object)("unable to read pdf file:" + fileName));
            context.getProcessStatistics().incrementNumberOfErrorRecords();
            processingFile.delete();
            return;
        }
        try {
            Person person;
            int i;
            ComLetterTemplateType.Code formType;
            VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey(vpid);
            PersonIdEntityKey personkey = this.getPersonService().getPersonIdByVPID(key);
            if (type.equalsIgnoreCase("1095B")) {
                formType = ComLetterTemplateType.FORM_NUMBER_800;
            } else if (type.equalsIgnoreCase("LTR")) {
                formType = ComLetterTemplateType.FORM_NUMBER_800A;
            } else {
                throw new Exception("Unknown Form Type in Import 1095B Process:" + currentPDFFile.getName());
            }
            ArrayList<ComLetterTemplateType.Code> formNumbers = new ArrayList<ComLetterTemplateType.Code>();
            formNumbers.add(formType);
            ArrayList linkDoc = new ArrayList();
            ArrayList<Correspondence> corrResults = this.getCorrespondenceService().getPersonCorrespondence(new BigDecimal(personkey.getKeyValueAsString()), formNumbers);
            if (corrResults != null) {
                for (i = 0; i < corrResults.size(); ++i) {
                    if (((Correspondence)((Object)corrResults.get(i))).getCorrespondenceDocument() != null) continue;
                    linkDoc.add(corrResults.get(i));
                }
            }
            if (linkDoc == null || linkDoc.isEmpty()) {
                formNumbers.clear();
                formNumbers.add(ComLetterTemplateType.FORM_NUMBER_800D);
                corrResults = this.getCorrespondenceService().getPersonCorrespondence(new BigDecimal(personkey.getKeyValueAsString()), formNumbers);
            }
            if (corrResults != null) {
                for (i = 0; i < corrResults.size(); ++i) {
                    if (((Correspondence)((Object)corrResults.get(i))).getCorrespondenceDocument() != null) continue;
                    linkDoc.add(corrResults.get(i));
                }
            }
            if ((linkDoc == null || linkDoc.isEmpty()) && (person = this.getPersonService().getPersonWithoutIdentityTraits(key)) != null) {
                Correspondence ltr = new Correspondence(person);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                Date date = formatter.parse(taxYear + "-01-01");
                ltr.setEffectiveDate(date);
                this.getCorrespondenceService().triggerNewCMSCorrespondence(ltr, formType);
                CorrespondenceDocument cd = new CorrespondenceDocument();
                cd.setDocumentFile(DatatypeConverter.printHexBinary((byte[])PDFByteArray));
                cd.setFileName(type + ".pdf");
                ltr.setCorrespondenceDocument(cd);
                this.getCorrespondenceService().updateACACorrespondence(ltr, CorrespondenceStatus.MAILED_BY_CMS, null);
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                processingFile.delete();
                cd = null;
                if (context.getProcessStatistics().getNumberOfSuccessfulRecords() % 100 == 0) {
                    this.updateJobResult(context);
                }
                return;
            }
            Correspondence corr = null;
            try {
                if (linkDoc.size() == 1) {
                    corr = (Correspondence)((Object)linkDoc.get(0));
                } else {
                    Collections.sort(linkDoc, new Comparator<Correspondence>(){

                        @Override
                        public int compare(Correspondence o1, Correspondence o2) {
                            return o1.getStatusDate().compareTo(o2.getStatusDate());
                        }
                    });
                    corr = (Correspondence)((Object)linkDoc.get(0));
                }
                CorrespondenceDocument cd = new CorrespondenceDocument();
                cd.setDocumentFile(DatatypeConverter.printHexBinary((byte[])PDFByteArray));
                cd.setFileName(type + ".pdf");
                corr.setCorrespondenceDocument(cd);
                this.getCorrespondenceService().updateACACorrespondence(corr, null, null);
                processingFile.delete();
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                cd = null;
            }
            catch (Exception ex) {
                if (corr != null) {
                    this.getCorrespondenceService().updateACACorrespondence(corr, null, "Unknown Error Importing PDF document");
                }
                throw new Exception("Failed to import PDF file", ex);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Exception in Import 1095B Process " + ex));
            context.getProcessStatistics().incrementNumberOfErrorRecords();
            processingFile.delete();
            return;
        }
        currentPDFFile = null;
        processingFile = null;
        fileName = null;
        values = null;
        PDFByteArray = null;
        fileInputStream = null;
        if (context.getProcessStatistics().getNumberOfSuccessfulRecords() % 100 == 0) {
            this.updateJobResult(context);
        }
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personService, (String)"personService is required");
        Validate.notNull((Object)this.correspondenceService, (String)"correspondenceService is required");
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public CorrespondenceService getCorrespondenceService() {
        return this.correspondenceService;
    }

    public void setCorrespondenceService(CorrespondenceService correspondenceService) {
        this.correspondenceService = correspondenceService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public String getInputFileLocation() {
        return this.inputFileLocation;
    }

    public void setInputFileLocation(String inputFileLocation) {
        this.inputFileLocation = inputFileLocation;
    }

    public int getNumberOfTotalRecords() {
        return this.numberOfTotalRecords;
    }

    public void setNumberOfTotalRecords(int numberOfTotalRecords) {
        this.numberOfTotalRecords = numberOfTotalRecords;
    }

    public void processAcquiredData(DataProcessExecutionContext context, List acquiredData) throws Exception {
    }

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }

    public CommsTemplateDAO getTemplDAO() {
        return this.templDAO;
    }

    public void setTemplDAO(CommsTemplateDAO templDAO) {
        this.templDAO = templDAO;
    }

    public CommsLogService getCommsLogService() {
        return this.commsLogService;
    }

    public void setCommsLogService(CommsLogService commsLogService) {
        this.commsLogService = commsLogService;
    }
}

