/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.HealthBenefitPlanData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.FailedRecordWriterProcessCompletedHandler;
import gov.va.med.fw.batchprocess.HealthBenefitsPlanProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.service.ServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HealthBenefitPlanImportProcess
extends AbstractDataFileSingleRowIncrementProcess {
    private LookupService lookupService;
    private HandBookService handBookService;
    private PersonService personService;
    private int numVersionsToKeep = 3;
    private String pdfFilesLocation;
    private final String[] validProductIds = new String[]{"H400H", "H400B", "H400F"};

    public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
        for (int i = 0; acquiredData != null && i < acquiredData.size(); ++i) {
            HealthBenefitPlanData healthBenefitPlanData = (HealthBenefitPlanData)((Object)acquiredData.get(i));
            String rawData = context.getCurrentRowRawData();
            try {
                List errors = this.validateRequest(healthBenefitPlanData);
                if (errors == null || errors.size() == 0) {
                    this.saveHealthBenefitPlan(healthBenefitPlanData, context);
                    HealthBenefitsPlanProcessStatistics stats = (HealthBenefitsPlanProcessStatistics)context.getProcessStatistics();
                    stats.incrementNumberOfSuccessfulRecords();
                    continue;
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                context.getExceptionData().add(rawData + "^" + this.getErrorString(errors));
                continue;
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Error processing data record: " + rawData), (Throwable)e);
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                context.getExceptionData().add(rawData + "^" + e.getMessage());
                context.getFailedData().add(rawData);
            }
        }
        FailedRecordWriterProcessCompletedHandler dataFileCompletedHandler = (FailedRecordWriterProcessCompletedHandler)this.getDataProcessCompletedHandler();
        dataFileCompletedHandler.writeExceptionData((DataProcessExecutionContext)context);
        dataFileCompletedHandler.writeFailedData((DataProcessExecutionContext)context);
    }

    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        return false;
    }

    private List validateRequest(HealthBenefitPlanData healthBenefitPlanData) throws ServiceException {
        ArrayList<String> errors = new ArrayList<String>();
        if (healthBenefitPlanData.getProductID() == null || healthBenefitPlanData.getProductID().length() <= 0) {
            errors.add("Missing Required field: ProductId");
        } else {
            List<String> list = Arrays.asList(this.validProductIds);
            if (!list.contains(healthBenefitPlanData.getProductID())) {
                errors.add("Invalid ProductId: " + healthBenefitPlanData.getProductID());
            }
        }
        if (healthBenefitPlanData.getHandbookRequestId() == null || healthBenefitPlanData.getHandbookRequestId().length() <= 0) {
            errors.add("Missing Required field: HandbookRequestId");
        }
        if (healthBenefitPlanData.getReleaseControlNumber() == null || healthBenefitPlanData.getReleaseControlNumber().length() <= 0) {
            errors.add("Missing Required field: ReleaseControlId");
        }
        if (healthBenefitPlanData.getIcn() == null || healthBenefitPlanData.getIcn().length() <= 0) {
            errors.add("Missing Required field: Unique Identifier for the Veteran");
        }
        if (healthBenefitPlanData.getHealthBenefitCode() == null || healthBenefitPlanData.getHealthBenefitCode().length() <= 0) {
            errors.add("Missing Required field: Benefit Code");
        }
        if (healthBenefitPlanData.getCategoryCode() == null || healthBenefitPlanData.getCategoryCode().length() <= 0) {
            errors.add("Missing Required field: Benefits Categoty Code");
        }
        if (healthBenefitPlanData.getCoveragePlanCode() == null || healthBenefitPlanData.getCoveragePlanCode().length() <= 0) {
            errors.add("Missing Required field: Coverage Plan Code");
        }
        PersonIdEntityKey personId = null;
        if (healthBenefitPlanData.getIcn() != null) {
            HandBookMailQueue mailQueue;
            personId = this.personService.getPersonIdByVPID(CommonEntityKeyFactory.createVPIDEntityKey(healthBenefitPlanData.getVpid()));
            if (personId == null) {
                errors.add("Invalid ICN :" + healthBenefitPlanData.getIcn());
            }
            if ((mailQueue = this.handBookService.findHandBookByIdentifier(healthBenefitPlanData.getHandbookRequestId())) == null) {
                errors.add("Invalid HandBookRequestId :" + healthBenefitPlanData.getHandbookRequestId());
            } else {
                if (!personId.getKeyValue().equals(mailQueue.getPersonId())) {
                    errors.add("Invalid ICN, ICN does not match the HandBookRequestId :" + healthBenefitPlanData.getIcn());
                }
                if (!mailQueue.getHandBookReleaseControl().getCode().equals(healthBenefitPlanData.getReleaseControlNumber())) {
                    errors.add("Invalid Release Control ID, Does not match the request :" + healthBenefitPlanData.getReleaseControlNumber());
                }
            }
        }
        return errors;
    }

    public void saveHealthBenefitPlan(HealthBenefitPlanData healthBenefitPlanData, DataFileProcessExecutionContext context) throws ServiceException {
        try {
            this.getHandBookService().processHealthBenefitsPlanRecord(healthBenefitPlanData, this.getPdfFilesLocation(), context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getErrorString(List errorsList) {
        StringBuffer errors = new StringBuffer();
        for (int i = 0; errorsList != null && i < errorsList.size(); ++i) {
            if (i > 0) {
                errors = errors.append(":");
            }
            errors.append(errorsList.get(i));
        }
        return errors.toString();
    }

    public HandBookService getHandBookService() {
        return this.handBookService;
    }

    public void setHandBookService(HandBookService handBookService) {
        this.handBookService = handBookService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public int getNumVersionsToKeep() {
        return this.numVersionsToKeep;
    }

    public void setNumVersionsToKeep(int numVersionsToKeep) {
        this.numVersionsToKeep = numVersionsToKeep;
    }

    public String getPdfFilesLocation() {
        return this.pdfFilesLocation;
    }

    public void setPdfFilesLocation(String pdfFilesLocation) {
        this.pdfFilesLocation = pdfFilesLocation;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected ProcessStatistics createProcessStatistics() {
        return new HealthBenefitsPlanProcessStatistics();
    }
}

