/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.HandBookBatchRequestConsumerSpawnedThreadTask;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.RegistryService;
import gov.va.med.fw.batchprocess.AbstractDataFileMREProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.util.ThreadPool;
import gov.va.med.fw.util.builder.Builder;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class HandBookBatchRequestConsumerProcess
extends AbstractDataFileMREProcess {
    private static final int DEFAULT_THREAD_POOL_SIZE = 1;
    private static final int DEFAULT_THROTTLE_TASKCOUNT_THREASHOLD = 500;
    private static final int DEFAULT_SPAWN_RETRY_PERIOD = 3000;
    private static final int DEFAULT_EXCEPTION_UPDATE_INTERVAL = 20;
    public static final String CONTEXT_THREAD_CREATOR = "threadCreator";
    public static final String CONTEXT_TASK_COUNT = "taskCount";
    public static final String CONTEXT_THREAD_POOL = "threadPool";
    public static final String HECLEGACY_DATASYNC_CONSUMER_THREAD_NAME = "HECLEGACYCONSUMERTHREAD";
    private int threadPoolSize = 1;
    private int throttleTaskCountThreshold = 500;
    private int spawnRetryPeriod = 3000;
    private String spawnedTaskId;
    private PersonService personService;
    private RegistryService registryService;
    private Builder mergeBuilder;

    private ThreadPool getThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = (ThreadPool)context.getContextData().get(CONTEXT_THREAD_POOL);
        if (threadPool == null) {
            threadPool = new ThreadPool("HandBookBatchRequestConsumerSpawnedThreadTask", this.threadPoolSize);
            context.getContextData().put(CONTEXT_THREAD_POOL, threadPool);
        }
        return threadPool;
    }

    private void initThreadCreatorAndIncrementTaskCount(DataFileProcessExecutionContext context) {
        if (!context.getContextData().containsKey(CONTEXT_THREAD_CREATOR)) {
            context.getContextData().put(CONTEXT_THREAD_CREATOR, this);
        }
        HandBookBatchRequestConsumerProcess.adjustTaskCount((DataProcessExecutionContext)context, 1);
    }

    static int getTaskCount(DataProcessExecutionContext context) {
        Integer count = (Integer)context.getContextData().get(CONTEXT_TASK_COUNT);
        return count != null ? count : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void adjustTaskCount(DataProcessExecutionContext context, int adjustment) {
        DataProcessExecutionContext dataProcessExecutionContext = context;
        synchronized (dataProcessExecutionContext) {
            context.getContextData().put(CONTEXT_TASK_COUNT, new Integer(HandBookBatchRequestConsumerProcess.getTaskCount(context) + adjustment));
        }
    }

    public void processEntityData(DataFileProcessExecutionContext context, List acquiredData) {
        if (context == null) {
            context = this.createDataFileProcessExecutionContext();
        }
        this.spawnThread(context, acquiredData);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
    }

    public String getSpawnedTaskId() {
        return this.spawnedTaskId;
    }

    public void setSpawnedTaskId(String spawnedTaskId) {
        this.spawnedTaskId = spawnedTaskId;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    private boolean isThreaded() {
        return StringUtils.isNotBlank((String)this.spawnedTaskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        block10: {
            if (this.isThreaded()) {
                try {
                    if (HandBookBatchRequestConsumerProcess.getTaskCount(context) == 0) break block10;
                    HandBookBatchRequestConsumerProcess handBookBatchRequestConsumerProcess = this;
                    synchronized (handBookBatchRequestConsumerProcess) {
                        boolean stillProcessing = true;
                        while (stillProcessing) {
                            ((Object)((Object)this)).wait();
                            if (HandBookBatchRequestConsumerProcess.getTaskCount(context) != 0) continue;
                            stillProcessing = false;
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.throwIllegalStateException("HECLegacyDataSynchronizationConsumerProcess was interrupted while it was waiting for its spawned threads to complete", e);
                }
                finally {
                    this.getThreadPool(context).stop();
                    this.cleanThreadPool(context);
                }
            }
        }
        super.handleDataProcessCompleted(context);
    }

    private void cleanThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = this.getThreadPool(context);
        threadPool.stop();
        context.getContextData().put(CONTEXT_THREAD_POOL, null);
    }

    private void spawnThread(DataFileProcessExecutionContext context, List acquiredData) {
        try {
            while (HandBookBatchRequestConsumerProcess.getTaskCount((DataProcessExecutionContext)context) >= this.throttleTaskCountThreshold) {
                Thread.sleep(this.spawnRetryPeriod);
            }
            this.initThreadCreatorAndIncrementTaskCount(context);
            ThreadPool threadPool = this.getThreadPool((DataProcessExecutionContext)context);
            HandBookBatchRequestConsumerSpawnedThreadTask task = (HandBookBatchRequestConsumerSpawnedThreadTask)((Object)this.getApplicationContext().getBean(this.spawnedTaskId));
            task.setContext(context);
            task.setAuditInfo(this.getAuditInfo());
            task.setAcquiredData(acquiredData);
            threadPool.invokeLater((Runnable)((Object)task));
        }
        catch (InterruptedException e) {
            this.throwIllegalStateException("HandBookBatchRequestConsumerProcess was interrupted while it was spawning a thread. ", e);
        }
    }

    public int getThrottleTaskCountThreshold() {
        return this.throttleTaskCountThreshold;
    }

    public void setThrottleTaskCountThreshold(int throttleTaskCountThreshold) {
        this.throttleTaskCountThreshold = throttleTaskCountThreshold;
    }

    public int getSpawnRetryPeriod() {
        return this.spawnRetryPeriod;
    }

    public void setSpawnRetryPeriod(int spawnRetryPeriod) {
        this.spawnRetryPeriod = spawnRetryPeriod;
    }

    protected boolean isNewEntityRow(String rowRawData) {
        return false;
    }

    protected DataFileProcessExecutionContext createDataFileProcessExecutionContext() {
        DataFileProcessExecutionContext context = new DataFileProcessExecutionContext();
        return context;
    }
}

