/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.PersonIdFileData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import java.util.List;

public class GenerateSsnVerificationProcess
extends AbstractDataFileIncrementalProcess {
    private PersonHelperService personHelperService = null;
    private PersonService personService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
        for (int i = 0; acquiredData != null && i < acquiredData.size(); ++i) {
            PersonIdFileData dataRecord = (PersonIdFileData)((Object)acquiredData.get(i));
            try {
                PersonIdEntityKey personKey = CommonEntityKeyFactory.createPersonIdEntityKey(dataRecord.getPersonId());
                Person incoming = this.getPersonService().getPerson(personKey);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Generate SSN Verification - Processing person ID  " + incoming.getPersonEntityKey().getKeyValueAsString()));
                }
                this.getPersonHelperService().addToSSNVerificationQueue(incoming);
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                continue;
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Error during GenerateSSNVerificationProcess for person ID " + dataRecord.getPersonId()), (Throwable)e);
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
            finally {
                if (this.shouldUpdateJobResult(context)) {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
                if (this.isInterrupted(context)) break;
            }
        }
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

