/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.VPIDFileData;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import java.math.BigDecimal;
import java.util.List;

public class GenerateMsdsQueryProcess
extends AbstractDataFileIncrementalProcess {
    private MessagingService messagingService = null;
    private PersonService personService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
        if (this.logger.isDebugEnabled()) {
            int listSize = 0;
            if (acquiredData != null) {
                listSize = acquiredData.size();
            }
            this.logger.error((Object)("Processing VPID  " + listSize));
        }
        for (int i = 0; acquiredData != null && i < acquiredData.size(); ++i) {
            VPIDFileData dataRecord = (VPIDFileData)((Object)acquiredData.get(i));
            String personIdinString = dataRecord.getVpid();
            try {
                BigDecimal personId = new BigDecimal(personIdinString);
                PersonIdEntityKeyImpl key = new PersonIdEntityKeyImpl(personId);
                if (this.logger.isDebugEnabled()) {
                    this.logger.error((Object)("Processing person ID  " + dataRecord.getVpid()));
                }
                this.getMessagingService().processTriggerBroker(this.getPersonService().getPerson(key));
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                continue;
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Error during continous Enrollment clean up process for person ID " + dataRecord.getVpid()), (Throwable)e);
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
            finally {
                if (this.shouldUpdateJobResult(context)) {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
                if (this.isInterrupted(context)) break;
            }
        }
    }

    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

