/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.ee.EGTProcessStatistic;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.EGTSiteStatistic;
import gov.va.med.esr.common.model.lookup.EGTStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.EGTService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.batchprocess.AbstractDataQueryProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.QueryIncrementTracker;
import gov.va.med.fw.persistent.QueryInfo;
import gov.va.med.fw.persistent.ScrollableCallback;
import gov.va.med.fw.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.Validate;
import org.hibernate.ScrollableResults;

public class EGTSettingProcess
extends AbstractDataQueryProcess
implements ScrollableCallback {
    private static final String KEY_CURSOR_EFFECTED_ENROLLMENT_QUERY = "cursor_queryEffectedEnrollment";
    private String queryMfnAck = "messageLogEntryQuery_checkMfnAck";
    private String queryEffectedEnrollment = "enrollmentDeterminationQuery_egtSettingEffectedPersonIds";
    private String queryGetNotEnrolledCount = "enrollmentDeterminationQuery_getNotEnrolledCount";
    private EGTService egtService = null;
    private LookupService lookupService = null;
    private int enrollmentsFetchSize = 50;
    private static final String[] QUERY_PARAM_NAMES = new String[]{"egtPriorityCode"};
    private static final String PARAM_MFK_INFO = "info";
    private static final String PARAM_EGT_SETTING_ID = "egtSettingId";

    protected void processData(DataProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("EGTSetting batch process: Query result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null || acquiredData.size() == 0) {
            return;
        }
        EGTSetting egt = (EGTSetting)((Object)acquiredData.get(0));
        try {
            if (!this.ackReceived(egt)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"EGTSettingProcess: New EGTSetting exists but no MFK~ZEG ack received yet.");
                }
                return;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"EGTSetting batch process: MFK~ZEG ack exists.");
            }
            egt = this.egtService.saveAsCurrentEGTSetting(egt);
            this.saveProcessStatistics(this.getEgtProcessStatistics(egt), new Date(), null, EGTStatus.CODE_RUNNING);
        }
        catch (Exception ex) {
            context.getExceptionData().add(ex);
            throw new IllegalStateException("Error while executing EGTSetting process. " + ex.getMessage());
        }
        Map siteStats = Collections.synchronizedMap(new HashMap());
        context.getContextData().put("siteStats", siteStats);
        context.getContextData().put("egt", egt);
        Integer totalRecords = null;
        try {
            QueryInfo query = new QueryInfo();
            query.setQuery(this.queryEffectedEnrollment);
            query.setParamValues(new Object[]{egt.getPriorityGroup().getCode()});
            query.setParamNames(QUERY_PARAM_NAMES);
            query.setFetchSize(this.enrollmentsFetchSize);
            totalRecords = this.getDao().scroll((ScrollableCallback)this, query, (QueryIncrementTracker)((DataQueryProcessExecutionContext)context));
        }
        catch (Exception ex) {
            this.logger.error((Object)"Error while executing EGTSetting process.", (Throwable)ex);
            context.getExceptionData().add(ex);
        }
        try {
            EGTProcessStatistic egtProcessStatistics = this.getEgtProcessStatistics(egt);
            boolean isInterruptedState = this.isInterrupted(context);
            if (!isInterruptedState) {
                this.setEgtSiteStatistics(egtProcessStatistics, siteStats);
            }
            EGTStatus.Code status = isInterruptedState ? EGTStatus.CODE_STOPPED_BY_USER : (context.getExceptionData().size() > 0 ? EGTStatus.CODE_ERROR : EGTStatus.CODE_FINISHED);
            egtProcessStatistics.setBeneficiaryProcessedCount(totalRecords);
            egtProcessStatistics.setBeneficiaryNotEnrolledCount(this.getNotEnrolledCount(egt));
            this.saveProcessStatistics(egtProcessStatistics, null, new Date(), status);
        }
        catch (Exception ex) {
            context.getExceptionData().add(ex);
            String err = "Error while saving the EGTProcessStatistics.";
            this.logger.error((Object)err, (Throwable)ex);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"EGTSetting batch process: Processing complete.");
        }
    }

    private void setEgtSiteStatistics(EGTProcessStatistic egtProcessStatistics, Map siteStats) {
        for (VAFacility facility : siteStats.keySet()) {
            EGTSiteStatistic egtSiteStats = egtProcessStatistics.getSiteStatistics(facility);
            if (egtSiteStats == null) {
                egtSiteStats = new EGTSiteStatistic();
                egtProcessStatistics.setEGTSiteStatistic(facility, egtSiteStats);
            }
            egtSiteStats.setBeneficiaryNotEnrolledCount((Integer)siteStats.get((Object)facility));
        }
    }

    private Integer getNotEnrolledCount(EGTSetting egt) throws DAOException {
        List result = this.getDao().findByNamedQueryAndNamedParam(this.queryGetNotEnrolledCount, new String[]{PARAM_EGT_SETTING_ID}, new Object[]{egt.getEntityKey().getKeyValue()});
        return (Integer)result.iterator().next();
    }

    private EGTProcessStatistic getEgtProcessStatistics(EGTSetting egt) {
        EGTProcessStatistic egtStatistics = egt.getProcessStatistic();
        if (egtStatistics == null) {
            egtStatistics = new EGTProcessStatistic();
            egt.setProcessStatistic(egtStatistics);
        }
        return egtStatistics;
    }

    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        super.handleDataProcessCompleted(context);
        ScrollableResults cursor = (ScrollableResults)context.getContextData().get(KEY_CURSOR_EFFECTED_ENROLLMENT_QUERY);
        if (cursor != null) {
            cursor.close();
        }
    }

    private void saveProcessStatistics(EGTProcessStatistic egtStatistics, Date startDate, Date endDate, EGTStatus.Code code) throws Exception {
        if (startDate != null) {
            egtStatistics.setProcessStartDate(startDate);
        }
        if (endDate != null) {
            egtStatistics.setProcessEndDate(endDate);
        }
        egtStatistics.setEgtProcessStatus(this.lookupService.getEGTStatusByCode(code.getCode()));
        this.egtService.saveEGTProcessStatistics(egtStatistics);
    }

    private void processEgtData(DataProcessExecutionContext context, List personIds, EGTSetting egt, Map siteStats) {
        try {
            this.egtService.updateEnrollmentWithNewEGTSetting(personIds, egt, siteStats);
            context.getProcessStatistics().incrementNumberOfSuccessfulRecords(personIds.size());
        }
        catch (Exception ex) {
            this.logger.error((Object)"Error while executing EGTSetting process.", (Throwable)ex);
            context.getExceptionData().add(ex);
            context.getProcessStatistics().incrementNumberOfErrorRecords(personIds.size());
        }
    }

    private boolean ackReceived(EGTSetting egt) throws DAOException {
        List result = this.getDao().findByNamedQueryAndNamedParam(this.queryMfnAck, PARAM_MFK_INFO, (Object)egt.getEntityKey().getKeyValueAsString());
        return (Integer)result.iterator().next() > 0;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.egtService, (String)"A EGTService is needed");
        Validate.notNull((Object)this.lookupService, (String)"A LookupService is needed");
        Validate.notNull((Object)this.queryMfnAck, (String)"A queryMfnAck (a query to check MFK ack) is needed");
        Validate.notNull((Object)this.queryEffectedEnrollment, (String)"A queryEffectedEnrollment (a query to check enrollements effected by EGTSetting) is needed");
        Validate.notNull((Object)this.queryGetNotEnrolledCount, (String)"A queryGetNotEnrolledCount name is needed");
    }

    public EGTService getEgtService() {
        return this.egtService;
    }

    public void setEgtService(EGTService egtService) {
        this.egtService = egtService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public String getQueryEffectedEnrollment() {
        return this.queryEffectedEnrollment;
    }

    public void setQueryEffectedEnrollment(String queryEffectedEnrollment) {
        this.queryEffectedEnrollment = queryEffectedEnrollment;
    }

    public String getQueryMfnAck() {
        return this.queryMfnAck;
    }

    public void setQueryMfnAck(String queryMfnAck) {
        this.queryMfnAck = queryMfnAck;
    }

    public int getEnrollmentsFetchSize() {
        return this.enrollmentsFetchSize;
    }

    public void setEnrollmentsFetchSize(int fetchSize) {
        this.enrollmentsFetchSize = fetchSize;
    }

    public void handleScrolledData(QueryIncrementTracker tracker) {
        DataProcessExecutionContext context = (DataProcessExecutionContext)tracker;
        List data = tracker.getIncrementalData();
        CollectionUtils.transform((Collection)data, (Transformer)new Transformer(){

            public Object transform(Object arg0) {
                return (BigDecimal)((Object[])arg0)[0];
            }
        });
        this.processEgtData(context, data, (EGTSetting)((Object)context.getContextData().get("egt")), (Map)context.getContextData().get("siteStats"));
    }

    public boolean continueScrolling(QueryIncrementTracker tracker) {
        return !this.isInterrupted((DataProcessExecutionContext)tracker);
    }
}

