/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.fw.batchprocess.AbstractDataQueryProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.HL7ProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;

public class DeleteHL7Process
extends AbstractDataQueryProcess {
    protected void processData(DataProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("DeleteHL7Process: Query result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        for (int i = 0; i < acquiredData.size(); ++i) {
            HL7ProcessStatistics hl7stats = (HL7ProcessStatistics)context.getProcessStatistics();
            hl7stats.incrementNumberOfSuccessfulRecords();
            hl7stats.setSpReturnedStatus((String)acquiredData.get(i));
            this.logger.info((Object)("This is the returned result from the stored procedure for item " + i));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"DeleteHL7Process: Processing complete.");
            this.logger.debug((Object)("DeleteHL7Process: Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("DeleteHL7Process: Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    protected List executeQuery(DataQueryProcessExecutionContext context) throws Exception {
        List results = new ArrayList();
        Object args = context.getExecutionArguments();
        int defaultArg = 1;
        int incomingSpArg = args != null ? Integer.parseInt((String)args) : defaultArg;
        if (context.isInterrupted()) {
            incomingSpArg = 0;
        }
        final int spArg = incomingSpArg;
        AbstractDAOAction callback = new AbstractDAOAction(){

            public List execute(Session session) throws DAOException {
                ArrayList<String> results = new ArrayList<String>();
                try {
                    CallableStatement call = session.connection().prepareCall("{? = call ADR.Hl7_Archive_Pkg.Hl7_Delete_Control(?)}");
                    call.registerOutParameter(1, 12);
                    call.setInt(2, spArg);
                    call.execute();
                    String returnedResult = call.getString(1);
                    results.add(returnedResult);
                }
                catch (SQLException ex) {
                    throw new DAOException("Failed to execute prepare statement: ", (Throwable)ex);
                }
                return results;
            }
        };
        results = (List)this.getDao().execute(callback);
        return results;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
    }

    protected ProcessStatistics createProcessStatistics() {
        return new HL7ProcessStatistics();
    }
}

