/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.CmsExportCommand;
import gov.va.med.esr.common.batchprocess.CommsExportStatistics;
import gov.va.med.esr.common.batchprocess.InitiateCMSLetterExportProcess;
import gov.va.med.esr.common.builder.comms.DocumentBuilder;
import gov.va.med.esr.common.builder.comms.EnrollTransmission;
import gov.va.med.esr.common.builder.comms.GeneralTransmission;
import gov.va.med.esr.common.builder.comms.GenerateValues;
import gov.va.med.esr.common.builder.comms.ITransmission;
import gov.va.med.esr.common.builder.comms.InsufficientDataException;
import gov.va.med.esr.common.builder.comms.SsnTransmission;
import gov.va.med.esr.common.model.comms.AacLetterRequest;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.comms.CommsTransByFormNumber;
import gov.va.med.esr.common.model.comms.CommsTransLog;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.ComLetterType;
import gov.va.med.esr.common.model.lookup.ComMailingTriggerType;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.persistent.comms.AacLetterRequestDAO;
import gov.va.med.esr.common.persistent.comms.CommsLogEntryDAO;
import gov.va.med.esr.common.persistent.comms.CommsTemplateDAO;
import gov.va.med.esr.common.persistent.comms.CommsTransLogDAO;
import gov.va.med.esr.common.persistent.comms.ExportFileDAO;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.CommsLetterRequestService;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.FinancialsHelperService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class CmsExportCommandImpl
extends AbstractRuleAwareServiceImpl
implements CmsExportCommand {
    private static final long serialVersionUID = 2230816708946289387L;
    private static int DEFAULT_BATCH_SIZE = 1000;
    private final String BATCH_SIZE_ARG = "-size=";
    private static final String ZERO_SIZE_FILE_NAME = "     N/A     ";
    private static String EXPORT_TRANS_TYPE_CODE = "COMREQ-A";
    private int batchSize = DEFAULT_BATCH_SIZE;
    private static MessageType EXPORT_TRANSMISSION_TYPE = null;
    private ExportFileDAO fileDAO = null;
    private AacLetterRequestDAO requestDAO = null;
    private PersonHelperService personHelperService;
    private CommsLogEntryDAO commsLogDAO = null;
    private CommsTemplateDAO templateDAO;
    private CommsLetterRequestService letterRequestService = null;
    private EligibilityEnrollmentService eligibilityEnrollmentService;
    private CommsTransLogDAO transDAO = null;
    private FormattedFileWriter fileWriter;

    @Override
    public CommsExportStatistics execute(String[] args, DataProcessExecutionContext context, InitiateCMSLetterExportProcess process) throws Exception {
        String option = null;
        if (args == null || args.length == 0) {
            option = "-P";
        } else {
            for (int i = 0; i < args.length; ++i) {
                String currArg = args[i];
                if (currArg.startsWith("-size=")) {
                    try {
                        String reqPerBatchSize = currArg.substring("-size=".length());
                        this.batchSize = new Integer(reqPerBatchSize);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Exception to Parse the Args :" + e));
                    }
                    continue;
                }
                option = args[0].trim().toUpperCase();
            }
        }
        if (option == null || args == null || args.length == 0) {
            option = "-P";
        }
        CommsExportStatistics stats = new CommsExportStatistics();
        stats.setStartTime(new Date());
        StringBuffer totalCmsLetterText = new StringBuffer();
        String aacExtractId = this.fileDAO.getAacExtractId();
        stats.setFileName(this.fileDAO.getAacFileName(aacExtractId));
        stats.setOriginalFileName(this.fileDAO.getOriginalAacFileName(aacExtractId));
        LookupService lookupService = (LookupService)this.getComponent("lookupService");
        EXPORT_TRANSMISSION_TYPE = lookupService.getMessageTypeByCode(EXPORT_TRANS_TYPE_CODE);
        List requests = this.requestDAO.findCmsLetterRequests();
        this.executeBatch(context, process, requests, stats, totalCmsLetterText, aacExtractId);
        if (stats.getNumberSent() <= 0) {
            stats.setFileName(ZERO_SIZE_FILE_NAME);
        }
        try {
            this.fileDAO.changeCmsTmpFilesToLtr();
        }
        catch (IOException e) {
            this.logger.error((Object)"Exception occured while changing the files from .tmp to .ltr ", (Throwable)e);
        }
        stats.setEndTime(new Date());
        this.updateCommsTransLog(stats);
        this.sendEmailNotification(stats);
        return stats;
    }

    @Override
    public void executeSingle(DataProcessExecutionContext context, InitiateCMSLetterExportProcess process, AacLetterRequest request, CommsExportStatistics stats, String aacExtractId) throws Exception {
        int entryCount = 0;
        StringBuffer cmsLetterText = new StringBuffer();
        CommsLogEntry log = request.getCommsLogEntry();
        Person person = this.getPersonService().getPerson(new PersonIdEntityKeyImpl(request.getCommsLogEntry().getPersonId()));
        GenerateValues inputValues = this.getInputValues(person, request);
        inputValues.setAacExtractId(aacExtractId);
        log.setAddress(((GeneralTransmission)inputValues.getTransmission()).getMailingAdress());
        List errorMessageList = this.getLetterRequestService().processLetterRulesForAACExport(person, this.getFormType(log.getFormNumber()), log.getWorkflowCaseId() == null ? null : log.getWorkflowCaseId().toString(), this.getTriggerType(log.getComMailingTriggerType()), log.getOverrideIndicator(), log, inputValues.getCategoryType());
        if (this.containsErrors(errorMessageList)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"has errors update log ");
            }
            stats.updateRejectPerReasonPerformTable(log);
            stats.setNumberRejected(stats.getNumberRejected() + 1);
        } else {
            List cmsLetterTextEntryLst = this.buildLetterRequests(person, inputValues);
            String vetFileData = (String)cmsLetterTextEntryLst.get(0);
            this.updateVeteranCommsLog(log, inputValues, vetFileData);
            cmsLetterText.append(vetFileData);
            ++entryCount;
            if ("RESEND".equalsIgnoreCase(log.getRemailIndicator())) {
                stats.setNumberRemailed(stats.getNumberRemailed() + 1);
            }
            stats.addToCountPerFormTable(request);
        }
        request.setCommsPrintRequestDupeCheck(request.getEntityKey().getKeyValueAsString());
        this.requestDAO.mergeObject(request);
        if (cmsLetterText.length() > 0) {
            String form = request.getCommsTemplateFormNumber();
            this.fileDAO.saveCms(cmsLetterText.toString(), aacExtractId);
        }
        stats.setNumberSent(stats.getNumberSent() + entryCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch(DataProcessExecutionContext context, InitiateCMSLetterExportProcess process, List requests, CommsExportStatistics stats, StringBuffer totalCmsLetterText, String aacExtractId) throws Exception {
        AacLetterRequest request = null;
        for (int i = 0; i < requests.size(); ++i) {
            int entryCount = 0;
            try {
                boolean isValidRequest;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("processing requet: " + i));
                }
                if (!(isValidRequest = this.isValidRequest(request = (AacLetterRequest)((Object)requests.get(i)), stats))) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("requet is not valid: " + i));
                    continue;
                }
                CmsExportCommand cmd = (CmsExportCommand)this.getComponent("cmsExportCommand");
                cmd.executeSingle(context, process, request, stats, aacExtractId);
                continue;
            }
            catch (Exception ex) {
                stats.setNumberWithException(stats.getNumberWithException() + 1);
                if (ex.getCause() != null && ex.getCause() instanceof IOException) {
                    context.setInterrupted(true);
                }
                this.handleException(context, request, ex);
                continue;
            }
            finally {
                stats.setNumberSent(stats.getNumberSent() + entryCount);
                if (process.isInterrupted(context)) break;
                process.updateLiveJobStatistics(context, stats);
            }
        }
    }

    private boolean isValidRequest(AacLetterRequest request, CommsExportStatistics stats) {
        CommsLogEntry entry = request.getCommsLogEntry();
        boolean isValid = false;
        boolean isIVM = ComLetterType.CODE_IVM.getCode().equals(entry.getLetterType().getCode());
        if (entry.isSendToCMS() && isIVM) {
            isValid = true;
        }
        return isValid;
    }

    private void handleException(DataProcessExecutionContext executionContext, AacLetterRequest request, Exception e) {
        String errorMessage = "Error processing record in CMS Letter Export:  Reason: " + e.getMessage();
        if (request != null && request.getCommsLogEntry() != null) {
            errorMessage = errorMessage + " Person ID: " + request.getCommsLogEntry().getPersonId() + " Form Number: " + request.getCommsLogEntry().getFormNumber();
        }
        executionContext.getExceptionData().add(errorMessage);
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)errorMessage, (Throwable)e);
        }
        ArrayList<String> exceptionData = new ArrayList<String>();
        exceptionData.add(errorMessage);
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String trackTrace = sw.toString();
            exceptionData.add(trackTrace);
        }
        try {
            this.getFileWriter().appendData(exceptionData);
        }
        catch (Exception e1) {
            this.logger.error((Object)"Unable to write the exception to .exception file ", (Throwable)e1);
        }
    }

    private boolean isIVMFinalLetter(String form) {
        return form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_400.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_450.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_451.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_452.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_453.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_454.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_455.getCode());
    }

    private boolean isCompassionLetter(String form) {
        return form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_683A.getCode());
    }

    private List buildLetterRequests(Person person, GenerateValues inputValues) throws ServiceException {
        DocumentBuilder builder = new DocumentBuilder();
        List textLst = null;
        try {
            textLst = builder.build(person, inputValues);
        }
        catch (InsufficientDataException idex) {
            this.logger.error((Object)"ERROR: Insufficient Data to build a letter while requesting a CMS letter", (Throwable)idex);
            throw new ServiceException(idex.toString());
        }
        return textLst;
    }

    private void updateVeteranCommsLog(CommsLogEntry log, GenerateValues inputValues, String vetFileData) throws DAOException {
        log.setLogXML(vetFileData);
        log.setAacExtractNumber(inputValues.getAacExtractId());
    }

    private boolean containsErrors(List errors) {
        boolean result = false;
        if (errors != null) {
            boolean bl = errors.size() >= 1 ? !((List)errors.get(0)).isEmpty() : (result = false);
            if (!result) {
                result = errors.size() >= 2 ? !((List)errors.get(1)).isEmpty() : false;
            }
        }
        return result;
    }

    private LetterTriggerEvent.MailType getTriggerType(ComMailingTriggerType triggerType) {
        if (triggerType != null) {
            String triggerTypeCode = triggerType.getCode();
            if (triggerTypeCode.equals("1")) {
                return LetterTriggerEvent.MANUAL_MAIL;
            }
            if (triggerTypeCode.equals("2")) {
                return LetterTriggerEvent.REMAIL_MAIL;
            }
            if (triggerTypeCode.equals("3")) {
                return LetterTriggerEvent.HISTORIC_MAIL;
            }
            if (triggerTypeCode.equals("4")) {
                return LetterTriggerEvent.AUTO_MAIL;
            }
        }
        return null;
    }

    private ComLetterTemplateType getFormType(String formNumber) throws Exception {
        if (formNumber == null) {
            return null;
        }
        return this.getLookupService().getComLetterTemplateTypeByCode(formNumber);
    }

    private GenerateValues getInputValues(Person person, AacLetterRequest request) throws ServiceException {
        CommsLogEntry log = request.getCommsLogEntry();
        CommsTemplate templ = log.getTemplate();
        String formNumber = templ.getCommsTemplateFormNumber();
        ITransmission trans = this.getTransmission(formNumber, person, request.getCommsLogEntry());
        GenerateValues inputValues = new GenerateValues(person, formNumber, null, log.getWorkflowCaseId(), trans);
        inputValues.setPrintLocationCd("03");
        inputValues.setOrigTemplate(templ);
        inputValues.setCommsLog(log);
        if (request.isVeteranLetter()) {
            inputValues.setCategoryType("V");
        } else if (request.isSpouseLetter()) {
            inputValues.setCategoryType("S");
        } else if (request.isDependentLetter()) {
            inputValues.setCategoryType("D");
        }
        return inputValues;
    }

    private ITransmission getTransmission(String formNumber, Person person, CommsLogEntry log) throws ServiceException {
        if (formNumber == null) {
            return null;
        }
        GeneralTransmission trans = null;
        if (ComLetterTemplateType.FORM_NUMBER_290.getCode().equals(formNumber) || ComLetterTemplateType.FORM_NUMBER_291.getCode().equals(formNumber) || ComLetterTemplateType.FORM_NUMBER_292.getCode().equals(formNumber) || ComLetterTemplateType.FORM_NUMBER_293.getCode().equals(formNumber) || ComLetterTemplateType.FORM_NUMBER_298.getCode().equals(formNumber) || ComLetterTemplateType.FORM_NUMBER_299.getCode().equals(formNumber)) {
            SsnTransmission ssnTrans = new SsnTransmission(person, log.getWorkflowCaseId());
            ssnTrans.setFormNumber(formNumber);
            ssnTrans.setHelperService(this.getHelperService());
            trans = ssnTrans;
        } else {
            Integer currentIncomeYear;
            EnrollTransmission enrTrans = new EnrollTransmission(person, log.getWorkflowCaseId());
            enrTrans.setFormNumber(formNumber);
            enrTrans.setHelperService(this.getHelperService());
            String mostRecentNonNullPriorityLevel = this.eligibilityEnrollmentService.getMostRecentNonNullPriorityLevelByDate(person.getEntityKey(), log.getCreatedOn());
            enrTrans.setMostRecentNonNullPriorityLevel(mostRecentNonNullPriorityLevel);
            IncomeTest currentIncomeTest = this.personHelperService.getCurrentIncomeTest(person);
            enrTrans.setLocalIncomeTest(currentIncomeTest);
            if (currentIncomeTest != null && (currentIncomeYear = currentIncomeTest.getIncomeYear()) != null) {
                Integer total = currentIncomeTest.getTotalNumberOfDependents() != null ? currentIncomeTest.getTotalNumberOfDependents() : new Integer(0);
                enrTrans.setIncomeThreshold(((FinancialsHelperService)this.getComponent("financialsHelperService")).calculateIncomeThresholds(currentIncomeYear, total));
            }
            trans = enrTrans;
        }
        return trans;
    }

    private void sendEmailNotification(CommsExportStatistics stats) throws ServiceException {
        Hashtable<String, String> dataTab = new Hashtable<String, String>();
        dataTab.put("CompletedDateTime", stats.getEndTime().toString());
        dataTab.put("NumberOfFiles", "1");
        dataTab.put("NumberLettersSent", stats.getNumberSent() + "");
        dataTab.put("NumberLetterRejected", stats.getNumberRejected() + "");
        dataTab.put("NumberLettersRemailed", stats.getNumberRemailed() + "");
        dataTab.put("CommunicationsPerFormTxt", stats.getCountPerFormTableText());
        dataTab.put("RejectPerReasonPerFormTxt", stats.getRejectPerReasonPerFormText());
        dataTab.put("FileNameRecordCountTxt", stats.getOriginalFileName() + "          " + stats.getNumberSent());
        CommsEmailBulletinService emailSrv = null;
        emailSrv = (CommsEmailBulletinService)this.getComponent("commsEmailBulletinService");
        emailSrv.sendEmailBulletin(BulletinTrigger.DataType.ENROLLMENT_LETTER_PROCESSING, dataTab, null);
    }

    private void updateCommsTransLog(CommsExportStatistics stats) throws Exception {
        if (stats.getFileName() == null) {
            return;
        }
        Hashtable countPerformTab = stats.getCountPerFormTable();
        if (countPerformTab != null && countPerformTab.size() > 0) {
            Enumeration keys = countPerformTab.keys();
            String key = null;
            CommsTransLog entry = null;
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                entry = new CommsTransLog();
                entry.setFileName(stats.getOriginalFileName());
                entry.setFileProcessStartDate(stats.getStartTime());
                entry.setFileProcessEndDate(stats.getEndTime());
                CommsTransByFormNumber transByFormNumber = new CommsTransByFormNumber();
                transByFormNumber.setFormNumber(key);
                transByFormNumber.setFormNumberRecordCount((Integer)countPerformTab.get(key));
                entry.addTransByFormNumber(transByFormNumber);
                entry.setTransmissionType(this.getLookupService().getMessageTypeByCode(EXPORT_TRANS_TYPE_CODE));
                this.transDAO.save(entry);
            }
        }
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public CommsLogEntryDAO getCommsLogDAO() {
        return this.commsLogDAO;
    }

    @Override
    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    @Override
    public ExportFileDAO getFileDAO() {
        return this.fileDAO;
    }

    @Override
    public FormattedFileWriter getFileWriter() {
        return this.fileWriter;
    }

    @Override
    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    @Override
    public AacLetterRequestDAO getRequestDAO() {
        return this.requestDAO;
    }

    @Override
    public CommsTemplateDAO getTemplateDAO() {
        return this.templateDAO;
    }

    @Override
    public CommsTransLogDAO getTransDAO() {
        return this.transDAO;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void setCommsLogDAO(CommsLogEntryDAO commsLogDAO) {
        this.commsLogDAO = commsLogDAO;
    }

    @Override
    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }

    @Override
    public void setFileDAO(ExportFileDAO fileDAO) {
        this.fileDAO = fileDAO;
    }

    @Override
    public void setFileWriter(FormattedFileWriter fileWriter) {
        this.fileWriter = fileWriter;
    }

    @Override
    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    @Override
    public void setRequestDAO(AacLetterRequestDAO requestDAO) {
        this.requestDAO = requestDAO;
    }

    @Override
    public void setTemplateDAO(CommsTemplateDAO templateDAO) {
        this.templateDAO = templateDAO;
    }

    @Override
    public void setTransDAO(CommsTransLogDAO transDAO) {
        this.transDAO = transDAO;
    }

    public CommsLetterRequestService getLetterRequestService() {
        return this.letterRequestService;
    }

    public void setLetterRequestService(CommsLetterRequestService letterReqService) {
        this.letterRequestService = letterReqService;
    }
}

